/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes.names;

import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.TypeDef;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.WScope;
import de.peeeq.wurstscript.attributes.names.DefLink;
import de.peeeq.wurstscript.attributes.names.NameLinkType;
import de.peeeq.wurstscript.attributes.names.Visibility;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.WurstType;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class TypeDefLink
extends DefLink {
    private final TypeDef def;

    public TypeDefLink(Visibility visibility, WScope definedIn, TypeDef def) {
        super(visibility, definedIn, Collections.emptyList(), null);
        this.def = def;
    }

    public static TypeDefLink create(TypeDef def, WScope definedIn) {
        return new TypeDefLink(TypeDefLink.calcVisibility(definedIn, def), definedIn, def);
    }

    @Override
    public String getName() {
        return this.def.getName();
    }

    @Override
    public TypeDef getDef() {
        return this.def;
    }

    @Override
    public TypeDefLink withVisibility(Visibility newVis) {
        return new TypeDefLink(newVis, this.getDefinedIn(), this.def);
    }

    @Override
    public boolean receiverCompatibleWith(WurstType receiverType, Element location) {
        return receiverType == null;
    }

    @Override
    public NameLinkType getType() {
        return null;
    }

    @Override
    public TypeDefLink withTypeArgBinding(Element context, VariableBinding binding) {
        return this;
    }

    @Override
    public DefLink withGenericTypeParams(List<TypeParamDef> typeParams) {
        return this;
    }

    @Override
    public WurstType getTyp() {
        return this.def.attrTyp();
    }

    @Override
    public TypeDefLink withDef(NameDef def) {
        return new TypeDefLink(this.getVisibility(), this.getDefinedIn(), (TypeDef)def);
    }

    @Override
    public TypeDefLink hidingPrivate() {
        return (TypeDefLink)super.hidingPrivate();
    }

    @Override
    public TypeDefLink hidingPrivateAndProtected() {
        return (TypeDefLink)super.hidingPrivateAndProtected();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeDefLink that = (TypeDefLink)o;
        return Objects.equals(this.def, that.def);
    }

    public int hashCode() {
        return Objects.hash(this.def);
    }
}

