/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import com.google.common.collect.ImmutableCollection;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.ast.Arguments;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.ConstructorDefs;
import de.peeeq.wurstscript.ast.CyclicDependencyError;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprBinary;
import de.peeeq.wurstscript.ast.ExprIfElse;
import de.peeeq.wurstscript.ast.ExprMemberMethod;
import de.peeeq.wurstscript.ast.ExprUnary;
import de.peeeq.wurstscript.ast.FunctionImplementation;
import de.peeeq.wurstscript.ast.StmtCall;
import de.peeeq.wurstscript.ast.StmtReturn;
import de.peeeq.wurstscript.ast.StmtSet;
import de.peeeq.wurstscript.ast.SuperConstructorCall;
import de.peeeq.wurstscript.ast.SwitchCase;
import de.peeeq.wurstscript.ast.SwitchStmt;
import de.peeeq.wurstscript.ast.VarDef;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.attributes.SmallHelpers;
import de.peeeq.wurstscript.types.FunctionSignature;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeBool;
import de.peeeq.wurstscript.types.WurstTypeClass;
import de.peeeq.wurstscript.types.WurstTypeInt;
import de.peeeq.wurstscript.types.WurstTypeReal;
import de.peeeq.wurstscript.types.WurstTypeUnknown;
import de.peeeq.wurstscript.utils.Utils;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;

public class AttrExprExpectedType {
    public static @NonNull WurstType calculate(Expr expr) {
        try {
            Element parent = expr.getParent();
            if (parent instanceof Arguments) {
                Arguments args = (Arguments)parent;
                Element parent2 = args.getParent();
                if (parent2 instanceof StmtCall) {
                    StmtCall stmtCall = (StmtCall)parent2;
                    return AttrExprExpectedType.expectedType(expr, args, stmtCall);
                }
                if (parent2 instanceof SuperConstructorCall) {
                    SuperConstructorCall constructorDef = (SuperConstructorCall)parent2;
                    return AttrExprExpectedType.expectedTypeSuperCall(constructorDef, expr);
                }
            } else if (parent instanceof StmtSet) {
                StmtSet stmtSet = (StmtSet)parent;
                if (stmtSet.getRight() == expr) {
                    return stmtSet.getUpdatedExpr().attrTyp();
                }
                if (stmtSet.getUpdatedExpr() == expr) {
                    return WurstTypeUnknown.instance();
                }
            } else {
                if (parent instanceof VarDef) {
                    VarDef varDef = (VarDef)parent;
                    return varDef.attrTyp();
                }
                if (parent instanceof ExprBinary) {
                    WurstType rightType;
                    ExprBinary exprBinary = (ExprBinary)parent;
                    WurstType leftType = exprBinary.getLeft().attrTyp();
                    if (leftType.equalsType(rightType = exprBinary.getRight().attrTyp(), expr)) {
                        return leftType;
                    }
                    if (leftType.isSubtypeOf(rightType, expr)) {
                        return rightType;
                    }
                    if (rightType.isSubtypeOf(leftType, expr)) {
                        return leftType;
                    }
                    return WurstTypeUnknown.instance();
                }
                if (parent instanceof ExprUnary) {
                    ExprUnary exprUnary = (ExprUnary)parent;
                    if (exprUnary.attrExpectedTyp().isSubtypeOf(WurstTypeInt.instance(), expr)) {
                        return WurstTypeInt.instance();
                    }
                    if (exprUnary.attrExpectedTyp().isSubtypeOf(WurstTypeReal.instance(), expr)) {
                        return WurstTypeReal.instance();
                    }
                    if (exprUnary.attrExpectedTyp().isSubtypeOf(WurstTypeBool.instance(), expr)) {
                        return WurstTypeBool.instance();
                    }
                } else if (parent instanceof StmtReturn) {
                    StmtReturn stmtReturn = (StmtReturn)parent;
                    FunctionImplementation nearestFuncDef = stmtReturn.attrNearestFuncDef();
                    if (nearestFuncDef != null) {
                        return nearestFuncDef.attrReturnTyp();
                    }
                } else {
                    ExprMemberMethod m;
                    if (parent instanceof SwitchCase) {
                        SwitchCase sc = (SwitchCase)parent;
                        SwitchStmt s = (SwitchStmt)sc.getParent().getParent();
                        return s.getExpr().attrTyp();
                    }
                    if (parent instanceof ExprIfElse) {
                        ExprIfElse ie = (ExprIfElse)parent;
                        if (expr == ie.getCond()) {
                            return WurstTypeBool.instance();
                        }
                        return ie.attrExpectedTypRaw();
                    }
                    if (parent instanceof ExprMemberMethod && (m = (ExprMemberMethod)parent).getLeft() == expr) {
                        WurstType receiverType = m.attrFunctionSignature().getReceiverType();
                        if (receiverType == null) {
                            return WurstTypeUnknown.instance();
                        }
                        return receiverType;
                    }
                }
            }
        }
        catch (CyclicDependencyError | CompileError t) {
            WLogger.info("Something went wrong while computing the expected type for " + Utils.printElementWithSource(Optional.of(expr)) + "\nThis is probably not a bug, but we are logging it anyway since it might help to improve error messages.");
            WLogger.info(t);
        }
        return WurstTypeUnknown.instance();
    }

    private static WurstType expectedTypeSuperCall(SuperConstructorCall sc, Expr expr) {
        ConstructorDef constr = (ConstructorDef)sc.getParent();
        ClassDef c = constr.attrNearestClassDef();
        if (c == null) {
            return WurstTypeUnknown.instance();
        }
        WurstTypeClass superClass = c.attrTypC().extendedClass();
        if (superClass == null) {
            return WurstTypeUnknown.instance();
        }
        ClassDef superClassDef = superClass.getDef();
        ConstructorDefs constructors = superClassDef.getConstructors();
        WurstType res = WurstTypeUnknown.instance();
        int paramIndex = SmallHelpers.superArgs(constr).indexOf(expr);
        for (ConstructorDef superConstr : constructors) {
            if (superConstr.getParameters().size() != SmallHelpers.superArgs(constr).size()) continue;
            res = res.typeUnion(((WParameter)superConstr.getParameters().get(paramIndex)).getTyp().attrTyp(), expr);
        }
        return res;
    }

    private static WurstType expectedType(Expr expr, Arguments args, StmtCall stmtCall) {
        ImmutableCollection<FunctionSignature> sigs = stmtCall.attrPossibleFunctionSignatures();
        int index = args.indexOf(expr);
        WurstType res = WurstTypeUnknown.instance();
        for (FunctionSignature sig : sigs) {
            if (index >= sig.getMaxNumParams()) continue;
            res = res.typeUnion(sig.getParamType(index), expr);
        }
        return res;
    }

    private static WurstType expectedTypeAfterOverloading(Expr expr, Arguments args, StmtCall stmtCall) {
        FunctionSignature sig = stmtCall.attrFunctionSignature();
        int index = args.indexOf(expr);
        if (index < sig.getMaxNumParams()) {
            return sig.getParamType(index);
        }
        return WurstTypeUnknown.instance();
    }

    public static WurstType normalizedType(Expr e) {
        return e.attrExpectedTypRaw().normalize();
    }

    public static WurstType afterOverloading(Expr e) {
        Arguments args;
        Element parent2;
        Element parent = e.getParent();
        if (parent instanceof Arguments && (parent2 = (args = (Arguments)parent).getParent()) instanceof StmtCall) {
            StmtCall stmtCall = (StmtCall)parent2;
            return AttrExprExpectedType.expectedTypeAfterOverloading(e, args, stmtCall).normalize();
        }
        return e.attrExpectedTyp();
    }
}

