/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.gui;

import de.peeeq.wurstio.gui.GuiUtils;
import de.peeeq.wurstscript.WLogger;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.eclipse.jdt.annotation.Nullable;

public class WurstStatusWindow
extends JFrame {
    private final JLabel currentStatus;
    private final JProgressBar progressBar;
    private final JLabel title;

    public WurstStatusWindow() {
        super("Progress");
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getClassLoader().getResource("icon.png"));
        }
        catch (IOException e) {
            WLogger.severe(e);
        }
        this.setIconImage(image);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            Logger.getLogger(WurstStatusWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.progressBar = new JProgressBar();
        this.title = new JLabel();
        this.currentStatus = new JLabel();
        this.progressBar.setDoubleBuffered(true);
        this.setDefaultCloseOperation(2);
        this.title.setFont(new Font("Tahoma", 1, 12));
        this.title.setText("WurstScript");
        this.currentStatus.setDoubleBuffered(true);
        this.currentStatus.setText("starting...");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.progressBar, GroupLayout.Alignment.LEADING, -1, 600, 600).addComponent(this.title, -1, 300, Short.MAX_VALUE).addComponent(this.currentStatus, GroupLayout.Alignment.LEADING, -1, 600, 600)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.title, -2, 17, -2).addGap(5, 5, 5).addComponent(this.currentStatus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -2, 30, -2).addContainerGap(12, Short.MAX_VALUE)));
        this.pack();
        GuiUtils.setWindowToCenterOfScreen(this);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    public void sendProgress(@Nullable String whatsRunningNow, double percent) {
        if (whatsRunningNow != null && whatsRunningNow.length() > 1) {
            this.currentStatus.setText(whatsRunningNow);
        }
        if (percent >= 0.0 && percent <= 1.0) {
            this.progressBar.setValue((int)(percent * 100.0));
        }
    }

    public void sendFinished() {
        this.dispose();
    }
}

