/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

public enum OsType {
    Windows32("windows_32", ".dll"),
    Windows64("windows_64", ".dll"),
    Linux32("linux_32", ".so"),
    Linux64("linux_64", ".so"),
    MacOsX32("macosx_32", ".jnilib", ".dylib"),
    MacOsX64("macosx_64", ".jnilib", ".dylib"),
    AndroidArm56("android_arm56", ".so"),
    AndroidArm7("android_arm7", ".so"),
    AndroidArm8("android_arm8", ".so"),
    AndroidMips("android_mips", ".so"),
    AndroidX86("android_x86", ".so"),
    AndroidMips64("android_mips64", ".so"),
    AndroidX86_64("android_x86_64", ".so"),
    LinuxArm32("linux_arm7_hf", ".so"),
    LinuxArm64("linux_arm8_hf", ".so");

    private final String name;
    private final String[] libraryNames;

    private OsType(String name, String ... libraryNames) {
        this.name = name;
        this.libraryNames = libraryNames;
    }

    public String getName() {
        return this.name;
    }

    public String[] getLibraryNames() {
        return this.libraryNames;
    }

    public boolean is64bit() {
        return this == Linux64 || this == LinuxArm64 || this == Windows64 || this == MacOsX64 || this == AndroidArm8 || this == AndroidX86_64 || this == AndroidMips64;
    }

    public boolean is32bit() {
        return this == Linux32 || this == LinuxArm32 || this == Windows32 || this == MacOsX32 || this == AndroidArm56 || this == AndroidArm7 || this == AndroidX86 || this == AndroidMips;
    }

    public boolean isMips() {
        return this == AndroidMips || this == AndroidMips64;
    }

    public boolean isX86() {
        return this == AndroidX86 || this == AndroidX86_64;
    }

    public boolean isArm() {
        return this == LinuxArm32 || this == LinuxArm64 || this == AndroidArm56 || this == AndroidArm7 || this == AndroidArm8;
    }

    public boolean isLinux() {
        return this == Linux32 || this == Linux64 || this == LinuxArm64 || this == LinuxArm32;
    }

    public boolean isWindows() {
        return this == Windows64 || this == Windows32;
    }

    public boolean isMacOsX() {
        return this == MacOsX64 || this == MacOsX32;
    }

    public boolean isAndroid() {
        return this == AndroidArm56 || this == AndroidArm7 || this == AndroidX86 || this == AndroidMips || this == AndroidArm8 || this == AndroidX86_64 || this == AndroidMips64;
    }
}

