/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.txt.app.jass;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.antlr.JassLexer;
import net.moonlightflower.wc3libs.antlr.LightJassParser;
import net.moonlightflower.wc3libs.txt.UTF8;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ListTokenSource;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public class LightJass {
    public static final File GAME_PATH = new File("war3map.j");
    private List<Token> _tokens;
    private LightJassParser.RootContext _rootContext;

    public List<Token> getTokens() {
        return this._tokens;
    }

    public LightJassParser.RootContext getRootContext() {
        if (this._rootContext == null) {
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)new ListTokenSource(this._tokens));
            LightJassParser parser = new LightJassParser((TokenStream)tokenStream);
            this._rootContext = parser.root();
        }
        return this._rootContext;
    }

    public String toString() {
        return this._rootContext.toString();
    }

    @Nonnull
    private static List<Token> cleanDuplicateNewLines(@Nonnull List<Token> tokens) {
        ArrayList<Token> newTokens = new ArrayList<Token>();
        boolean inNewlines = false;
        for (Token token : tokens) {
            if (token.getType() == 14) {
                if (inNewlines) continue;
                inNewlines = true;
                newTokens.add(token);
                continue;
            }
            inNewlines = false;
            newTokens.add(token);
        }
        return newTokens;
    }

    @Nonnull
    private static List<Token> stripComments(@Nonnull List<Token> tokens) {
        List<Token> newTokens = new ArrayList<Token>();
        for (Token token2 : tokens) {
            if (token2.getType() == 10) {
                String s = token2.getText();
                s = s.replaceAll("\r\n", "\n");
                s = s.replaceAll("\r", "\n");
                s = s.replaceAll("[^\n]", "");
                for (int i = 0; i < s.length() + 1; ++i) {
                    CommonToken newToken = new CommonTokenFactory().create(14, "\n");
                    newTokens.add((Token)newToken);
                }
                continue;
            }
            newTokens.add(token2);
        }
        newTokens.removeIf(token -> token.getType() == 9);
        newTokens = LightJass.cleanDuplicateNewLines(newTokens);
        return newTokens;
    }

    public static LightJassParser transform(@Nonnull String input) {
        CodePointCharStream antlrStream = CharStreams.fromString((String)input);
        JassLexer lexer = new JassLexer((CharStream)antlrStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        tokenStream.fill();
        LightJassParser parser = new LightJassParser((TokenStream)tokenStream);
        return parser;
    }

    private void read(@Nonnull InputStream inStream) throws IOException {
        UTF8 reader = new UTF8(inStream, false, true);
        String input = reader.readAll(false);
        CodePointCharStream antlrStream = CharStreams.fromString((String)input);
        JassLexer lexer = new JassLexer((CharStream)antlrStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        tokenStream.fill();
        ArrayList<Token> tokens = new ArrayList<Token>(tokenStream.getTokens());
        this._tokens = LightJass.stripComments(tokens);
    }

    public LightJass(@Nonnull InputStream inStream) throws IOException {
        this.read(inStream);
    }

    public LightJass(@Nonnull File file) throws IOException {
        InputStream inStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
        this.read(inStream);
        inStream.close();
    }

    public LightJass(@Nonnull String s) {
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(s.getBytes());
            this.read(inStream);
            ((InputStream)inStream).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LightJass() {
        this._rootContext = new LightJassParser.RootContext(null, -1);
    }
}

