/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.audio;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WAV {
    private static final Logger log = LoggerFactory.getLogger(WAV.class);
    static final int RATE = 16384;
    private byte[] bytes;

    public static byte[] createSinWaveBuffer(double freq, int ms) {
        int samples = ms * 16384 / 1000;
        byte[] output = new byte[samples];
        double period = 16384.0 / freq;
        for (int i = 0; i < output.length; ++i) {
            double angle = Math.PI * 2 * (double)i / period;
            output[i] = (byte)(Math.abs(Math.sin(angle)) * 10.0);
            output[i] = angle > Math.PI ? 10 : 0;
            output[i] = angle > Math.PI ? (byte)(5.0 - 5.0 * angle / (Math.PI * 2)) : (byte)(0.0 + 5.0 * (angle %= Math.PI * 2) / (Math.PI * 2));
        }
        return output;
    }

    private byte[] getTone(int durMS) {
        int count = durMS * 16384 / 1000;
        byte[] ret = new byte[count];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = 127;
        }
        return ret;
    }

    public WAV(@Nonnull File inFile, boolean a) throws LineUnavailableException {
        AudioFormat af = new AudioFormat(16384.0f, 8, 1, true, true);
        SourceDataLine line = AudioSystem.getSourceDataLine(af);
        line.open(af, 16384);
        line.start();
        for (double freq = 3200.0; freq <= 3200.0; freq += 100.0) {
            byte[] toneBuffer = WAV.createSinWaveBuffer(freq, 5000);
            int count = line.write(toneBuffer, 0, toneBuffer.length);
            System.out.println(count);
        }
        line.drain();
        line.close();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void play() throws IOException, UnsupportedAudioFileException, LineUnavailableException {
        ByteArrayInputStream inByteStream = new ByteArrayInputStream(this.bytes);
        AudioInputStream inAudioStream = AudioSystem.getAudioInputStream(inByteStream);
        log.info(inAudioStream.toString());
        AudioFormat inFormat = inAudioStream.getFormat();
        log.info(inFormat.toString());
        log.info(String.valueOf(inFormat.getSampleRate() * 4.0f));
        AudioFormat outFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, inFormat.getSampleRate() * 4.0f, inFormat.getSampleSizeInBits(), inFormat.getChannels(), inFormat.getChannels() * 2, inFormat.getSampleRate(), !inFormat.isBigEndian());
        inAudioStream.close();
        AudioInputStream newInAudioStream = AudioSystem.getAudioInputStream(outFormat, inAudioStream);
        DataLine.Info info = new DataLine.Info(Clip.class, outFormat);
        log.info(String.valueOf(info));
        Clip clip = (Clip)AudioSystem.getLine(info);
        clip.open(newInAudioStream);
        clip.setFramePosition(0);
        clip.start();
    }

    private void read(InputStream inStream) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        int val;
        Vector<Byte> bBuf = new Vector<Byte>();
        while ((val = inStream.read()) != -1) {
            bBuf.add((byte)val);
        }
        this.bytes = new byte[bBuf.size()];
        for (int i = 0; i < bBuf.size(); ++i) {
            this.bytes[i] = (Byte)bBuf.get(i);
        }
        ByteArrayInputStream inByteStream = new ByteArrayInputStream(this.bytes);
        AudioInputStream inAudioStream = AudioSystem.getAudioInputStream(inByteStream);
        log.info(inAudioStream.toString());
        AudioFormat inFormat = inAudioStream.getFormat();
        log.info(inFormat.toString());
        log.info(String.valueOf(inFormat.getSampleRate() * 4.0f));
        inStream.close();
        inAudioStream.close();
    }

    public WAV(InputStream inStream) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this.read(inStream);
    }

    public WAV(File inFile) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        InputStream inStream = Files.newInputStream(inFile.toPath(), new OpenOption[0]);
        this.read(inStream);
        inStream.close();
    }
}

