/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc;

import java.util.LinkedHashSet;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.misc.ObservableLinkedHashSet;

public class ObservableLinkedHashSetView<T, SubType extends T>
extends LinkedHashSet<SubType> {
    private final ObservableLinkedHashSet<T> _parent;

    public void onAdd(T val) {
    }

    @Override
    public boolean add(SubType val) {
        boolean ret = super.add(val);
        if (ret) {
            this.onAdd(val);
            this._parent.add(val);
        }
        return ret;
    }

    public void onRemove(T val) {
    }

    @Override
    public boolean remove(Object val) {
        boolean ret = super.remove(val);
        if (ret) {
            this.onRemove(val);
            this._parent.remove(val);
        }
        return ret;
    }

    public void onClear() {
    }

    @Override
    public void clear() {
        this._parent.clear();
        this.onClear();
    }

    public ObservableLinkedHashSetView(@Nonnull ObservableLinkedHashSet<T> parent, final @Nonnull Predicate<T> filter) {
        this._parent = parent;
        for (Object val : this._parent) {
            if (!filter.test(val)) continue;
            this.add((SubType)val);
        }
        this._parent._listeners.add(new ObservableLinkedHashSet.Listener<T>(){

            @Override
            public void onAdd(T val) {
                if (filter.test(val)) {
                    ObservableLinkedHashSetView.this.add(val);
                }
            }

            @Override
            public void onRemove(T val) {
                if (filter.test(val)) {
                    ObservableLinkedHashSetView.this.remove(val);
                }
            }

            @Override
            public void clear() {
            }
        });
    }
}

