/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.parseq.grammars.ast;

import com.google.common.collect.Maps;
import de.peeeq.parseq.grammars.ast.SimpleType;
import java.util.Map;

public class ProdType {
    private static final ProdType empty = new ProdType();
    private final Map<String, SimpleType> data = Maps.newLinkedHashMap();

    public ProdType() {
    }

    public ProdType(String key, SimpleType type) {
        this.data.put(key, type);
    }

    public ProdType sequence(ProdType other) {
        ProdType result = new ProdType();
        result.data.putAll(this.data);
        for (Map.Entry<String, SimpleType> e : other.data.entrySet()) {
            String key = e.getKey().replaceAll("[0-9]+", "");
            int i = 0;
            while (result.data.containsKey(key)) {
                key = String.valueOf(e.getKey()) + ++i;
            }
            result.data.put(key, e.getValue());
        }
        return result;
    }

    public ProdType alternative(ProdType other) {
        ProdType result = new ProdType();
        result.data.putAll(this.data);
        result.data.putAll(other.data);
        return result;
    }

    public static ProdType empty() {
        return empty;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ProdType[");
        for (Map.Entry<String, SimpleType> e : this.data.entrySet()) {
            sb.append(String.valueOf(e.getKey()) + " -> " + e.getValue() + ", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

