/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.parseq.asts;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class FileGenerator {
    public static final String PARSEQ_COMMENT = "//generated by parseq";
    private File outputFolder;
    private List<File> oldFiles = new LinkedList<File>();

    public FileGenerator(File outputFolder) {
        this.outputFolder = outputFolder;
        outputFolder.mkdirs();
        File[] fileArray = outputFolder.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            this.oldFiles.add(f);
            ++n2;
        }
    }

    public void createFile(String name, StringBuilder sb) {
        String filename = name;
        File file = new File(this.outputFolder, filename);
        boolean writeFile = false;
        if (file.exists()) {
            try {
                String content = Files.toString(file, Charsets.UTF_8);
                if (!sb.toString().equals(content)) {
                    writeFile = true;
                }
            }
            catch (IOException e) {
                this.abort("Error: Could not read file " + filename);
            }
        } else {
            writeFile = true;
        }
        if (writeFile) {
            System.out.println("writing file " + file);
            try {
                Files.write(sb, file, Charsets.UTF_8);
            }
            catch (IOException e) {
                this.abort("Error: Could not write file " + filename);
            }
        } else {
            System.out.println("not changed: " + file);
        }
        this.oldFiles.remove(file);
    }

    public void abort(String string) {
        System.err.println(string);
        System.exit(1);
    }

    public void removeOldFiles() {
        for (File old : this.oldFiles) {
            try {
                if (!Files.readFirstLine(old, Charsets.UTF_8).startsWith(PARSEQ_COMMENT)) continue;
                System.out.println("removing file: " + old);
                old.renameTo(new File(String.valueOf(old.getAbsolutePath()) + ".backup"));
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
    }
}

