/*
 * Decompiled with CFR 0.152.
 */
package tablelayout;

import tablelayout.Cell;
import tablelayout.Toolkit;

public abstract class Value {
    public static final Value zero = new CellValue(){

        @Override
        public float get(Cell cell) {
            return 0.0f;
        }

        @Override
        public float get(Object table) {
            return 0.0f;
        }
    };
    public static Value minWidth = new CellValue(){

        @Override
        public float get(Cell cell) {
            if (cell == null) {
                throw new RuntimeException("minWidth can only be set on a cell property.");
            }
            Object widget = cell.widget;
            if (widget == null) {
                return 0.0f;
            }
            return Toolkit.instance.getMinWidth(widget);
        }
    };
    public static Value minHeight = new CellValue(){

        @Override
        public float get(Cell cell) {
            if (cell == null) {
                throw new RuntimeException("minHeight can only be set on a cell property.");
            }
            Object widget = cell.widget;
            if (widget == null) {
                return 0.0f;
            }
            return Toolkit.instance.getMinHeight(widget);
        }
    };
    public static Value prefWidth = new CellValue(){

        @Override
        public float get(Cell cell) {
            if (cell == null) {
                throw new RuntimeException("prefWidth can only be set on a cell property.");
            }
            Object widget = cell.widget;
            if (widget == null) {
                return 0.0f;
            }
            return Toolkit.instance.getPrefWidth(widget);
        }
    };
    public static Value prefHeight = new CellValue(){

        @Override
        public float get(Cell cell) {
            if (cell == null) {
                throw new RuntimeException("prefHeight can only be set on a cell property.");
            }
            Object widget = cell.widget;
            if (widget == null) {
                return 0.0f;
            }
            return Toolkit.instance.getPrefHeight(widget);
        }
    };
    public static Value maxWidth = new CellValue(){

        @Override
        public float get(Cell cell) {
            if (cell == null) {
                throw new RuntimeException("maxWidth can only be set on a cell property.");
            }
            Object widget = cell.widget;
            if (widget == null) {
                return 0.0f;
            }
            return Toolkit.instance.getMaxWidth(widget);
        }
    };
    public static Value maxHeight = new CellValue(){

        @Override
        public float get(Cell cell) {
            if (cell == null) {
                throw new RuntimeException("maxHeight can only be set on a cell property.");
            }
            Object widget = cell.widget;
            if (widget == null) {
                return 0.0f;
            }
            return Toolkit.instance.getMaxHeight(widget);
        }
    };

    public abstract float get(Object var1);

    public abstract float get(Cell var1);

    public float width(Object table) {
        return Toolkit.instance.width(this.get(table));
    }

    public float height(Object table) {
        return Toolkit.instance.height(this.get(table));
    }

    public float width(Cell cell) {
        return Toolkit.instance.width(this.get(cell));
    }

    public float height(Cell cell) {
        return Toolkit.instance.height(this.get(cell));
    }

    public static Value percentWidth(final float percent) {
        return new TableValue(){

            @Override
            public float get(Object table) {
                return Toolkit.instance.getWidth(table) * percent;
            }
        };
    }

    public static Value percentHeight(final float percent) {
        return new TableValue(){

            @Override
            public float get(Object table) {
                return Toolkit.instance.getHeight(table) * percent;
            }
        };
    }

    public static Value percentWidth(final float percent, final Object widget) {
        return new Value(){

            @Override
            public float get(Cell cell) {
                return Toolkit.instance.getWidth(widget) * percent;
            }

            @Override
            public float get(Object table) {
                return Toolkit.instance.getWidth(widget) * percent;
            }
        };
    }

    public static Value percentHeight(final float percent, final Object widget) {
        return new TableValue(){

            @Override
            public float get(Object table) {
                return Toolkit.instance.getHeight(widget) * percent;
            }
        };
    }

    public static class FixedValue
    extends Value {
        private float value;

        public FixedValue(float value) {
            this.value = value;
        }

        public void set(float value) {
            this.value = value;
        }

        @Override
        public float get(Object table) {
            return this.value;
        }

        @Override
        public float get(Cell cell) {
            return this.value;
        }
    }

    public static abstract class TableValue
    extends Value {
        @Override
        public float get(Cell cell) {
            return this.get(cell.getLayout().getTable());
        }
    }

    public static abstract class CellValue
    extends Value {
        @Override
        public float get(Object table) {
            throw new UnsupportedOperationException("This value can only be used for a cell property.");
        }
    }
}

