/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.luaAst;

import de.peeeq.wurstscript.luaAst.Element;
import de.peeeq.wurstscript.luaAst.LuaExpr;
import de.peeeq.wurstscript.luaAst.LuaExprFuncRef;
import de.peeeq.wurstscript.luaAst.LuaExprFunctionCall;
import de.peeeq.wurstscript.luaAst.LuaExprMethodCall;
import de.peeeq.wurstscript.luaAst.LuaExprVarAccess;
import de.peeeq.wurstscript.luaAst.LuaFunction;
import de.peeeq.wurstscript.luaAst.LuaIf;
import de.peeeq.wurstscript.luaAst.LuaMethod;
import de.peeeq.wurstscript.luaAst.LuaStatement;
import de.peeeq.wurstscript.luaAst.LuaStatements;
import de.peeeq.wurstscript.luaAst.LuaVariable;
import de.peeeq.wurstscript.translation.lua.printing.LuaPrinter;
import java.util.function.Consumer;

class LuaIfImpl
implements LuaIf {
    private Element parent;
    private LuaExpr cond;
    private LuaStatements thenStmts;
    private LuaStatements elseStmts;

    LuaIfImpl(LuaExpr cond, LuaStatements thenStmts, LuaStatements elseStmts) {
        if (cond == null) {
            throw new IllegalArgumentException("Element cond must not be null.");
        }
        if (thenStmts == null) {
            throw new IllegalArgumentException("Element thenStmts must not be null.");
        }
        if (elseStmts == null) {
            throw new IllegalArgumentException("Element elseStmts must not be null.");
        }
        this.cond = cond;
        this.thenStmts = thenStmts;
        this.elseStmts = elseStmts;
        cond.setParent(this);
        thenStmts.setParent(this);
        elseStmts.setParent(this);
    }

    @Override
    public Element getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Element parent) {
        if (parent != null && this.parent != null) {
            throw new Error("Cannot change parent of element " + this.getClass().getSimpleName() + ", as it is already used in another tree.Use the copy method to create a new tree or remove the tree from its old parent or set the parent to null before moving the tree. ");
        }
        this.parent = parent;
    }

    @Override
    public void replaceBy(Element other) {
        if (this.parent == null) {
            throw new RuntimeException("Node not attached to tree.");
        }
        for (int i = 0; i < this.parent.size(); ++i) {
            if (this.parent.get(i) != this) continue;
            this.parent.set(i, other);
            return;
        }
    }

    @Override
    public void setCond(LuaExpr cond) {
        if (cond == null) {
            throw new IllegalArgumentException();
        }
        this.cond.setParent(null);
        cond.setParent(this);
        this.cond = cond;
    }

    @Override
    public LuaExpr getCond() {
        return this.cond;
    }

    @Override
    public void setThenStmts(LuaStatements thenStmts) {
        if (thenStmts == null) {
            throw new IllegalArgumentException();
        }
        this.thenStmts.setParent(null);
        thenStmts.setParent(this);
        this.thenStmts = thenStmts;
    }

    @Override
    public LuaStatements getThenStmts() {
        return this.thenStmts;
    }

    @Override
    public void setElseStmts(LuaStatements elseStmts) {
        if (elseStmts == null) {
            throw new IllegalArgumentException();
        }
        this.elseStmts.setParent(null);
        elseStmts.setParent(this);
        this.elseStmts = elseStmts;
    }

    @Override
    public LuaStatements getElseStmts() {
        return this.elseStmts;
    }

    @Override
    public Element get(int i) {
        switch (i) {
            case 0: {
                return this.cond;
            }
            case 1: {
                return this.thenStmts;
            }
            case 2: {
                return this.elseStmts;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public Element set(int i, Element newElem) {
        switch (i) {
            case 0: {
                LuaExpr oldElem = this.cond;
                this.setCond((LuaExpr)newElem);
                return oldElem;
            }
            case 1: {
                LuaStatements oldElem = this.thenStmts;
                this.setThenStmts((LuaStatements)newElem);
                return oldElem;
            }
            case 2: {
                LuaStatements oldElem = this.elseStmts;
                this.setElseStmts((LuaStatements)newElem);
                return oldElem;
            }
        }
        throw new IllegalArgumentException("Index out of range: " + i);
    }

    @Override
    public void forEachElement(Consumer<? super Element> action) {
        action.accept(this.cond);
        action.accept(this.thenStmts);
        action.accept(this.elseStmts);
    }

    @Override
    public int size() {
        return 3;
    }

    @Override
    public LuaIf copy() {
        LuaIfImpl result = new LuaIfImpl(this.cond.copy(), this.thenStmts.copy(), this.elseStmts.copy());
        return result;
    }

    @Override
    public LuaIf copyWithRefs() {
        final LuaIf res = this.copy();
        final LuaIfImpl self = this;
        res.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(LuaExprMethodCall e) {
                Element elem;
                super.visit(e);
                for (elem = e.getMethod(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setMethod((LuaMethod)res.followPath(self.pathTo(e.getMethod())));
                }
            }

            @Override
            public void visit(LuaExprFunctionCall e) {
                Element elem;
                super.visit(e);
                for (elem = e.getFunc(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setFunc((LuaFunction)res.followPath(self.pathTo(e.getFunc())));
                }
            }

            @Override
            public void visit(LuaExprVarAccess e) {
                Element elem;
                super.visit(e);
                for (elem = e.getVar(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setVar((LuaVariable)res.followPath(self.pathTo(e.getVar())));
                }
            }

            @Override
            public void visit(LuaExprFuncRef e) {
                Element elem;
                super.visit(e);
                for (elem = e.getFunc(); elem != self && elem != null; elem = elem.getParent()) {
                }
                if (elem == self) {
                    e.setFunc((LuaFunction)res.followPath(self.pathTo(e.getFunc())));
                }
            }
        });
        return res;
    }

    @Override
    public void clearAttributes() {
        this.cond.clearAttributes();
        this.thenStmts.clearAttributes();
        this.elseStmts.clearAttributes();
        this.clearAttributesLocal();
    }

    @Override
    public void clearAttributesLocal() {
    }

    @Override
    public void accept(Element.Visitor v) {
        v.visit(this);
    }

    @Override
    public <T> T match(LuaStatement.Matcher<T> matcher) {
        return matcher.case_LuaIf(this);
    }

    @Override
    public void match(LuaStatement.MatcherVoid matcher) {
        matcher.case_LuaIf(this);
    }

    @Override
    public <T> T match(Element.Matcher<T> matcher) {
        return matcher.case_LuaIf(this);
    }

    @Override
    public void match(Element.MatcherVoid matcher) {
        matcher.case_LuaIf(this);
    }

    public String toString() {
        return "LuaIf(" + this.cond + ", " + this.thenStmts + ", " + this.elseStmts + ")";
    }

    @Override
    public boolean structuralEquals(Element e) {
        if (e instanceof LuaIf) {
            LuaIf o = (LuaIf)e;
            return this.cond.structuralEquals(o.getCond()) && this.thenStmts.structuralEquals(o.getThenStmts()) && this.elseStmts.structuralEquals(o.getElseStmts());
        }
        return false;
    }

    @Override
    public void print(StringBuilder sb, int indent) {
        LuaPrinter.print(this, sb, indent);
    }
}

