/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes.names;

import com.google.common.collect.ImmutableList;
import de.peeeq.datastructures.Deferred;
import de.peeeq.wurstscript.ast.AstElementWithTypeParameters;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.NameDef;
import de.peeeq.wurstscript.ast.TypeDef;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.WScope;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.attributes.names.Visibility;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.WurstType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class TypeLink
extends NameLink {
    private final Deferred<WurstType> type;
    private final TypeDef def;

    public TypeLink(Visibility visibility, WScope definedIn, List<TypeParamDef> typeParams, TypeDef def, Deferred<WurstType> type) {
        super(visibility, definedIn, typeParams);
        this.def = def;
        this.type = type;
    }

    public static TypeLink create(TypeDef def, WScope definedIn) {
        ImmutableList typeParams = Collections.emptyList();
        if (def instanceof AstElementWithTypeParameters) {
            typeParams = ImmutableList.copyOf((Collection)((AstElementWithTypeParameters)((Object)def)).getTypeParameters());
        }
        Deferred<Supplier<WurstType>> type = new Deferred<Supplier<WurstType>>(def::attrTyp);
        return new TypeLink(TypeLink.calcVisibility(definedIn, def), definedIn, (List<TypeParamDef>)typeParams, def, type);
    }

    @Override
    public String getName() {
        return this.def.getName();
    }

    @Override
    public TypeDef getDef() {
        return this.def;
    }

    @Override
    public NameLink withVisibility(Visibility newVis) {
        return new TypeLink(newVis, this.getDefinedIn(), this.typeParams, this.def, this.type);
    }

    @Override
    public boolean receiverCompatibleWith(WurstType receiverType, Element location) {
        return receiverType == null;
    }

    @Override
    public TypeLink withTypeArgBinding(Element context, VariableBinding binding) {
        return this;
    }

    @Override
    public WurstType getTyp() {
        return this.def.attrTyp();
    }

    @Override
    public TypeLink withDef(NameDef def) {
        return new TypeLink(this.getVisibility(), this.getDefinedIn(), this.getTypeParams(), (TypeDef)def, this.type);
    }

    public WurstType getTyp(VariableBinding mapping) {
        return this.def.attrTyp().setTypeArgs(mapping);
    }

    @Override
    public TypeLink hidingPrivate() {
        return (TypeLink)super.hidingPrivate();
    }

    @Override
    public TypeLink hidingPrivateAndProtected() {
        return (TypeLink)super.hidingPrivateAndProtected();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeLink typeLink = (TypeLink)o;
        return Objects.equals(this.def, typeLink.def);
    }

    public int hashCode() {
        return Objects.hash(this.def);
    }
}

