/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.ast.Annotation;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprBinary;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.ExprFuncRef;
import de.peeeq.wurstscript.ast.ExprFunctionCall;
import de.peeeq.wurstscript.ast.ExprMemberMethod;
import de.peeeq.wurstscript.ast.FuncRef;
import de.peeeq.wurstscript.ast.FunctionDefinition;
import de.peeeq.wurstscript.ast.PackageOrGlobal;
import de.peeeq.wurstscript.ast.StmtCall;
import de.peeeq.wurstscript.ast.TypeDef;
import de.peeeq.wurstscript.ast.TypeExpr;
import de.peeeq.wurstscript.ast.WShortParameter;
import de.peeeq.wurstscript.attributes.AttrVarDefType;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.attributes.names.Visibility;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.VariablePosition;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeClosure;
import de.peeeq.wurstscript.types.WurstTypeInfer;
import de.peeeq.wurstscript.types.WurstTypeInt;
import de.peeeq.wurstscript.types.WurstTypeReal;
import de.peeeq.wurstscript.types.WurstTypeString;
import de.peeeq.wurstscript.types.WurstTypeUnknown;
import de.peeeq.wurstscript.types.WurstTypeVararg;
import de.peeeq.wurstscript.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;

public class AttrFuncDef {
    public static final String overloadingPlus = "op_plus";
    public static final String overloadingMinus = "op_minus";
    public static final String overloadingMult = "op_mult";
    public static final String overloadingDiv = "op_divReal";

    public static FuncLink calculate(ExprFuncRef node) {
        Object funcs;
        if (node.getScopeName().length() > 0) {
            TypeDef typeDef = node.lookupType(node.getScopeName());
            if (typeDef == null) {
                node.addError("Could not find type " + node.getScopeName() + ".");
                return null;
            }
            WurstType receiverType = typeDef.attrTyp();
            funcs = node.lookupMemberFuncs(receiverType, node.getFuncName());
        } else {
            funcs = node.lookupFuncs(node.getFuncName());
        }
        if (funcs.size() == 0) {
            node.addError("Could not find a function with name " + node.getFuncName());
            return null;
        }
        funcs = AttrFuncDef.filterInvisible(node.getFuncName(), node, funcs);
        if (funcs.size() == 1) {
            return (FuncLink)Utils.getFirst(funcs);
        }
        if (funcs.size() > 1) {
            node.addError("Reference to function " + node.getFuncName() + " is ambiguous. Alternatives are:\n" + Utils.printAlternatives((Collection<? extends NameLink>)funcs));
        }
        return (FuncLink)Utils.getFirst(funcs);
    }

    public static @Nullable FuncLink calculate(ExprBinary node) {
        return AttrFuncDef.getExtensionFunction(node.getLeft(), node.getRight(), node.getOp());
    }

    public static @Nullable FuncLink calculate(ExprMemberMethod node) {
        String funcName;
        Expr left = node.getLeft();
        WurstType leftType = left.attrTyp();
        @Nullable FuncLink result = AttrFuncDef.searchMemberFunc(node, leftType, funcName = node.getFuncName(), AttrFuncDef.argumentTypes(node));
        if (result == null) {
            node.addError("The method " + funcName + " is undefined for receiver of type " + leftType);
        }
        return result;
    }

    public static @Nullable FuncLink calculate(ExprFunctionCall node) {
        String funcName;
        FuncLink result = AttrFuncDef.searchFunction(node.getFuncName(), node, AttrFuncDef.argumentTypes(node));
        if (!(result != null || (funcName = node.getFuncName()).startsWith("InitTrig_") && node.attrNearestFuncDef() != null && node.attrNearestFuncDef().getName().equals("InitCustomTriggers"))) {
            node.addError("Could not resolve reference to called function " + funcName);
        }
        return result;
    }

    private static @Nullable FuncLink getExtensionFunction(Expr left, Expr right, WurstOperator op) {
        String funcName = op.getOverloadingFuncName();
        if (funcName == null || AttrFuncDef.nativeOperator(op, left.attrTyp(), right.attrTyp(), left)) {
            return null;
        }
        return AttrFuncDef.searchMemberFunc(left, left.attrTyp(), funcName, Collections.singletonList(right.attrTyp()));
    }

    private static boolean nativeOperator(WurstOperator op, WurstType leftType, WurstType rightType, Element term) {
        return (leftType.isSubtypeOf(WurstTypeInt.instance(), term) || leftType.isSubtypeOf(WurstTypeReal.instance(), term)) && (rightType.isSubtypeOf(WurstTypeInt.instance(), term) || rightType.isSubtypeOf(WurstTypeReal.instance(), term)) || op == WurstOperator.PLUS && leftType instanceof WurstTypeString && rightType instanceof WurstTypeString;
    }

    public static List<WurstType> argumentTypes(StmtCall node) {
        ArrayList result = Lists.newArrayList();
        for (Expr arg : node.getArgs()) {
            WurstType argType;
            if (arg instanceof ExprClosure) {
                ExprClosure closure = (ExprClosure)arg;
                if (closure.getShortParameters().stream().allMatch(p -> p.getTypOpt() instanceof TypeExpr)) {
                    argType = arg.attrTyp();
                } else {
                    WurstType expected = arg.attrExpectedTyp();
                    ArrayList<WurstType> paramTypes = new ArrayList<WurstType>();
                    boolean hasInferredType = false;
                    int pIndex = 0;
                    for (WShortParameter p2 : closure.getShortParameters()) {
                        if (p2.getTypOpt() instanceof TypeExpr) {
                            paramTypes.add(p2.getTypOpt().attrTyp());
                        } else {
                            WurstType pt = AttrVarDefType.getParameterTypeFromClosureType(p2, pIndex, expected, false);
                            paramTypes.add(pt);
                            if (pt instanceof WurstTypeInfer) {
                                hasInferredType = true;
                            }
                        }
                        ++pIndex;
                    }
                    if (hasInferredType) {
                        WurstType resultType = WurstTypeInfer.instance();
                        argType = new WurstTypeClosure(paramTypes, resultType);
                    } else {
                        argType = arg.attrTyp();
                    }
                }
            } else {
                argType = arg.attrTyp();
            }
            result.add(argType);
        }
        return result;
    }

    public static List<WurstType> argumentTypesPre(StmtCall node) {
        ArrayList result = Lists.newArrayList();
        for (Expr arg : node.getArgs()) {
            WurstType argType;
            if (arg instanceof ExprClosure) {
                ExprClosure closure = (ExprClosure)arg;
                if (closure.getShortParameters().stream().allMatch(p -> p.getTypOpt() instanceof TypeExpr)) {
                    argType = arg.attrTyp();
                } else {
                    ArrayList<WurstType> paramTypes = new ArrayList<WurstType>();
                    for (WShortParameter p2 : closure.getShortParameters()) {
                        if (p2.getTypOpt() instanceof TypeExpr) {
                            paramTypes.add(p2.getTypOpt().attrTyp());
                            continue;
                        }
                        paramTypes.add(WurstTypeInfer.instance());
                    }
                    WurstType resultType = WurstTypeInfer.instance();
                    argType = new WurstTypeClosure(paramTypes, resultType);
                }
            } else {
                argType = arg.attrTyp();
            }
            result.add(argType);
        }
        return result;
    }

    private static FuncLink searchFunction(String funcName, @Nullable FuncRef node, List<WurstType> argumentTypes) {
        if (node == null) {
            return null;
        }
        ImmutableCollection<FuncLink> funcs1 = node.lookupFuncs(funcName);
        if (funcs1.size() == 0) {
            if (funcName.startsWith("InitTrig_")) {
                return null;
            }
            if (node instanceof Annotation) {
                node.addWarning("Annotation " + funcName + " is not defined.");
            } else {
                node.addError("Reference to function " + funcName + " could not be resolved.");
            }
            return null;
        }
        if (funcs1.size() == 1) {
            return Utils.getFirst(funcs1);
        }
        Object funcs = AttrFuncDef.filterAnnotation(node, funcs1);
        if (funcs.size() == 1) {
            return Utils.getFirst(funcs);
        }
        if ((funcs = AttrFuncDef.filterInvisible(funcName, node, funcs)).size() == 1) {
            return (FuncLink)Utils.getFirst(funcs);
        }
        if ((funcs = AttrFuncDef.filterByReceiverType(node, funcName, (List<FuncLink>)funcs)).size() == 1) {
            return (FuncLink)Utils.getFirst(funcs);
        }
        if ((funcs = AttrFuncDef.filterByParameters(node, argumentTypes, (List<FuncLink>)funcs)).size() == 1) {
            return (FuncLink)Utils.getFirst(funcs);
        }
        if ((funcs = AttrFuncDef.ignoreWithIfNotDefinedAnnotation(node, (List<FuncLink>)funcs)).size() == 1) {
            return (FuncLink)Utils.getFirst(funcs);
        }
        if ((funcs = AttrFuncDef.useLocalPackageIfPossible(node, (List<FuncLink>)funcs)).size() == 1) {
            return (FuncLink)Utils.getFirst(funcs);
        }
        node.addError("Call to function " + funcName + " is ambiguous. Alternatives are:\n" + Utils.printAlternatives((Collection<? extends NameLink>)funcs));
        return (FuncLink)Utils.getFirst(funcs);
    }

    static ImmutableList<FuncLink> filterAnnotation(FuncRef node, ImmutableCollection<FuncLink> funcs1) {
        Predicate<FuncLink> filter = node instanceof Annotation ? f -> f.getDef().hasAnnotation("@annotation") : f -> !f.getDef().hasAnnotation("@annotation");
        ImmutableList res = funcs1.stream().filter(filter).collect(Utils.toImmutableList());
        if (res.isEmpty()) {
            return ImmutableList.copyOf(funcs1);
        }
        return res;
    }

    private static List<FuncLink> ignoreWithIfNotDefinedAnnotation(FuncRef node, List<FuncLink> funcs) {
        return funcs.stream().filter(fl -> !fl.hasIfNotDefinedAnnotation()).collect(Collectors.toList());
    }

    private static List<FuncLink> useLocalPackageIfPossible(FuncRef node, List<FuncLink> funcs) {
        int localCount = 0;
        FuncLink local = null;
        PackageOrGlobal myPackage = node.attrNearestPackage();
        for (FuncLink n : funcs) {
            if (n.getDef().attrNearestPackage() != myPackage) continue;
            local = n;
            ++localCount;
        }
        if (localCount == 0) {
            return funcs;
        }
        if (localCount == 1) {
            return ImmutableList.of(local);
        }
        ArrayList result = Lists.newArrayList();
        for (FuncLink n : funcs) {
            if (n.getDef().attrNearestPackage() != myPackage) continue;
            result.add(n);
        }
        return result;
    }

    private static @Nullable FuncLink searchMemberFunc(Expr node, WurstType leftType, String funcName, List<WurstType> argumentTypes) {
        ImmutableCollection<FuncLink> funcs1 = node.lookupMemberFuncs(leftType, funcName);
        if (funcs1.size() == 0) {
            return null;
        }
        if (funcs1.size() == 1) {
            return Utils.getFirst(funcs1);
        }
        List<FuncLink> funcs = AttrFuncDef.filterInvisible(funcName, node, funcs1);
        if (funcs.size() == 1) {
            return Utils.getFirst(funcs);
        }
        if ((funcs = AttrFuncDef.filterByReceiverType(node, funcName, funcs)).size() == 1) {
            return Utils.getFirst(funcs);
        }
        if ((funcs = AttrFuncDef.filterByParameters(node, argumentTypes, funcs)).size() == 1) {
            return Utils.getFirst(funcs);
        }
        node.addError("Call to function " + funcName + " is ambiguous. Alternatives are:\n" + Utils.printAlternatives(funcs));
        return Utils.getFirst(funcs);
    }

    private static List<FuncLink> filterByParameters(Element node, List<WurstType> argumentTypes, List<FuncLink> funcs) {
        if ((funcs = AttrFuncDef.filterByParamaeterNumber(argumentTypes, funcs)).size() == 1) {
            return funcs;
        }
        funcs = AttrFuncDef.filterByParameterTypes(node, argumentTypes, funcs);
        return funcs;
    }

    private static List<FuncLink> filterByParameterTypes(Element node, List<WurstType> argumentTypes, List<FuncLink> funcs3) {
        ArrayList funcs4 = Lists.newArrayListWithCapacity((int)funcs3.size());
        block0: for (FuncLink f : funcs3) {
            VariableBinding mapping = f.getVariableBinding();
            for (int i = 0; i < argumentTypes.size(); ++i) {
                WurstType pt;
                WurstType at = argumentTypes.get(i);
                VariableBinding m2 = at.matchAgainstSupertype(pt = f.getParameterType(i), node, mapping, VariablePosition.RIGHT);
                if (m2 == null) continue block0;
                mapping = m2;
            }
            funcs4.add(f);
        }
        if (funcs4.size() == 0) {
            return ImmutableList.of((Object)Utils.getFirst(funcs3));
        }
        if (funcs4.size() == 1) {
            return ImmutableList.of((Object)((FuncLink)Utils.getFirst(funcs4)));
        }
        if (argumentTypes.stream().anyMatch(t -> t instanceof WurstTypeUnknown)) {
            return ImmutableList.of((Object)((FuncLink)Utils.getFirst(funcs4)));
        }
        return funcs4;
    }

    private static List<FuncLink> filterByParamaeterNumber(List<WurstType> argumentTypes, List<FuncLink> funcs2) {
        ArrayList funcs3 = Lists.newArrayListWithCapacity((int)funcs2.size());
        for (FuncLink f : funcs2) {
            if (f.getParameterTypes().size() != argumentTypes.size() && (f.getParameterTypes().size() != 1 || !(f.getParameterTypes().get(0) instanceof WurstTypeVararg))) continue;
            funcs3.add(f);
        }
        if (funcs3.size() == 0) {
            return Collections.singletonList(Utils.getFirst(funcs2));
        }
        return funcs3;
    }

    private static List<FuncLink> filterInvisible(String funcName, Element node, Collection<FuncLink> funcs1) {
        if (node.attrSource().getFile().equals("<REPL>")) {
            return Lists.newArrayList(funcs1);
        }
        List<Object> funcs2 = Lists.newArrayListWithCapacity((int)funcs1.size());
        for (FuncLink nl : funcs1) {
            if (nl.getVisibility() == Visibility.PRIVATE_OTHER || nl.getVisibility() == Visibility.PROTECTED_OTHER) continue;
            funcs2.add(nl);
        }
        if ((funcs2 = Utils.removedDuplicates(funcs2)).size() == 0) {
            node.addError("Function " + funcName + " is not visible here.");
            return ImmutableList.of((Object)Utils.getFirst(funcs1));
        }
        return funcs2;
    }

    private static List<FuncLink> filterByReceiverType(Element node, String funcName, List<FuncLink> funcs2) {
        ArrayList funcs3 = Lists.newArrayListWithCapacity((int)funcs2.size());
        for (FuncLink f : funcs2) {
            boolean existsMoreSpecific = false;
            WurstType f_receiverType = f.getReceiverType();
            if (f_receiverType != null) {
                for (FuncLink g : funcs2) {
                    WurstType g_receiverType;
                    if (f == g || (g_receiverType = g.getReceiverType()) == null || !g_receiverType.isSubtypeOf(f_receiverType, node) || g_receiverType.equalsType(f_receiverType, node)) continue;
                    existsMoreSpecific = true;
                    break;
                }
            }
            if (existsMoreSpecific) continue;
            funcs3.add(f);
        }
        if (funcs3.size() == 0) {
            node.addError("Function " + funcName + " dfopsdfmpso.");
            return ImmutableList.of((Object)Utils.getFirst(funcs2));
        }
        return funcs3;
    }

    public static FunctionDefinition calculateDef(FuncRef e) {
        FuncLink f = e.attrFuncLink();
        return f == null ? null : f.getDef();
    }

    public static FunctionDefinition calculateDef(ExprBinary e) {
        FuncLink f = e.attrFuncLink();
        return f == null ? null : f.getDef();
    }

    public static FuncLink calculate(Annotation node) {
        List<WurstType> argumentTypes = node.getArgs().stream().map(Expr::attrTyp).collect(Collectors.toList());
        FuncLink result = AttrFuncDef.searchFunction(node.getFuncName(), node, argumentTypes);
        if (result == null) {
            return null;
        }
        FunctionDefinition def = result.getDef();
        if (def != null && !def.hasAnnotation("@annotation")) {
            node.addWarning("The function " + def.getName() + " must be annotated with @annotation to be usable as an annotation.");
        }
        return result;
    }
}

