/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.immutablecollections;

import com.google.common.base.Preconditions;
import de.peeeq.immutablecollections.ImmutableList;
import de.peeeq.immutablecollections.ImmutableListImpl;
import java.util.Iterator;
import java.util.NoSuchElementException;

class ImmutableListEmpty<T>
extends ImmutableList<T> {
    private static final ImmutableList<Object> instance = new ImmutableListEmpty<Object>();

    static <T> ImmutableList<T> instance() {
        return instance;
    }

    private ImmutableListEmpty() {
    }

    @Override
    public Iterator<T> iterator() {
        return new MyIterator();
    }

    @Override
    public ImmutableList<T> appFront(T elem) {
        Preconditions.checkNotNull(elem);
        return new ImmutableListImpl<T>(elem);
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public T head() {
        throw new Error("Tried to get head of empty list");
    }

    @Override
    public ImmutableList<T> tail() {
        throw new Error("Tried to get tail of empty list");
    }

    @Override
    public <R extends T> ImmutableList<T> cons(ImmutableList<R> other) {
        ImmutableList<R> result = other;
        return result;
    }

    @Override
    public ImmutableList<T> removeAll(T t) {
        return this;
    }

    private static class MyIterator<T>
    implements Iterator<T> {
        private MyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

