/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.datastructures;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jdt.annotation.Nullable;

public class ImmutableTree<T>
implements Iterable<ImmutableTree<T>> {
    private final @Nullable ImmutableList<ImmutableTree<T>> children;
    private final @Nullable T elem;

    private ImmutableTree(@Nullable ImmutableList<ImmutableTree<T>> children, @Nullable T elem) {
        Preconditions.checkArgument((children == null != (elem == null) ? 1 : 0) != 0);
        this.children = children;
        this.elem = elem;
    }

    public static <T> ImmutableTree<T> node(ImmutableList<ImmutableTree<T>> children) {
        return new ImmutableTree<Object>(children, null);
    }

    public static <T> ImmutableTree<T> leaf(T t) {
        return new ImmutableTree<T>(null, t);
    }

    public int size() {
        ImmutableList<ImmutableTree<T>> ch = this.children;
        if (ch == null) {
            return 1;
        }
        int size = 0;
        for (ImmutableTree c : ch) {
            size += c.size();
        }
        return size;
    }

    @Override
    public Iterator<ImmutableTree<T>> iterator() {
        ImmutableList<ImmutableTree<T>> children2 = this.children;
        if (children2 != null) {
            return children2.iterator();
        }
        return Collections.emptyIterator();
    }

    public ImmutableList<T> allValues() {
        ImmutableList.Builder b = ImmutableList.builder();
        this.addValues(b);
        return b.build();
    }

    private void addValues(// Could not load outer class - annotation placement on inner may be incorrect
    ImmutableList.Builder<@Nullable T> b) {
        ImmutableList<ImmutableTree<T>> ch = this.children;
        if (ch == null) {
            b.add(this.elem);
        } else {
            for (ImmutableTree c : ch) {
                c.addValues(b);
            }
        }
    }

    public static <T> ImmutableTree<T> empty() {
        return ImmutableTree.node(ImmutableList.of());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        ImmutableList<ImmutableTree<T>> c = this.children;
        @Nullable T e = this.elem;
        result = 31 * result + (c == null ? 0 : c.hashCode());
        result = 31 * result + (e == null ? 0 : e.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImmutableTree other = (ImmutableTree)obj;
        ImmutableList<ImmutableTree<T>> c = this.children;
        if (c == null ? other.children != null : !c.equals(other.children)) {
            return false;
        }
        @Nullable T e = this.elem;
        if (e == null) {
            return other.elem == null;
        }
        return e.equals(other.elem);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ImmutableList<ImmutableTree<T>> c = this.children;
        if (c == null) {
            sb.append("[");
            sb.append(this.elem);
            sb.append("]");
        } else {
            sb.append("[");
            boolean first = true;
            for (ImmutableTree t : c) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(t);
                first = false;
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public T getOnlyEment() {
        ImmutableList<ImmutableTree<T>> ch = this.children;
        @Nullable T el = this.elem;
        if (el != null) {
            return el;
        }
        if (ch != null && !ch.isEmpty()) {
            return ((ImmutableTree)ch.get(0)).getOnlyEment();
        }
        throw new RuntimeException("There are " + this.size() + " elements in this tree.");
    }

    public boolean isLeaf() {
        return this.children == null;
    }
}

