/*
 * Decompiled with CFR 0.152.
 */
package file;

import file.Download;
import file.SetupApp;
import global.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import ui.MainWindow;
import workers.DownloadWithProgressWorker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\fJ\u001a\u0010\u000e\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\fJ$\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00042\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\fH\u0002J$\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00042\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\fH\u0002J\u001a\u0010\u0012\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\fJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0004J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lfile/Download;", "", "()V", "bareboneUrl", "", "baseUrl", "compileName", "log", "Lmu/KLogger;", "downloadBareboneProject", "", "callback", "Lkotlin/Function1;", "Ljava/nio/file/Path;", "downloadCompiler", "downloadDirect", "filePath", "downloadFile", "downloadSetup", "getHttpURLConnection", "Ljava/net/HttpURLConnection;", "readStream", "substring", "input", "Ljava/io/BufferedInputStream;", "WurstSetup"})
public final class Download {
    @NotNull
    public static final Download INSTANCE = new Download();
    @NotNull
    private static final KLogger log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);
    @NotNull
    private static final String baseUrl = "grill.wurstlang.org/hudson/job/Wurst/lastSuccessfulBuild/artifact/downloads/";
    @NotNull
    private static final String bareboneUrl = "github.com/wurstscript/WurstBareboneTemplate/archive/master.zip";
    @NotNull
    private static final String compileName = "wurstpack_compiler.zip";

    private Download() {
    }

    private final void downloadFile(String filePath, Function1<? super Path, Unit> callback) throws IOException {
        if (SetupApp.INSTANCE.getSetup().isGUILaunch()) {
            new DownloadWithProgressWorker(filePath, MainWindow.INSTANCE.getUi().getProgressBar(), callback).execute();
        } else {
            this.downloadDirect(filePath, callback);
        }
    }

    @NotNull
    public final HttpURLConnection getHttpURLConnection(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        URL url = new URL(filePath);
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection httpConnection = (HttpURLConnection)uRLConnection;
        httpConnection.setConnectTimeout(14000);
        httpConnection.setReadTimeout(20000);
        httpConnection.addRequestProperty("User-Agent", "Chrome");
        return httpConnection;
    }

    public final void downloadSetup(@NotNull Function1<? super Path, Unit> callback) throws IOException {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        try {
            this.downloadFile("https://grill.wurstlang.org/hudson/job/WurstSetup/lastSuccessfulBuild/artifact/downloads/WurstSetup.jar", callback);
        }
        catch (Exception e) {
            log.warn("downloadCompiler Exception caught", (Throwable)e);
            Log.INSTANCE.println("Https error, falling back to unsafe http.");
            this.downloadFile("http://grill.wurstlang.org/hudson/job/WurstSetup/lastSuccessfulBuild/artifact/downloads/WurstSetup.jar", callback);
        }
    }

    public final void downloadCompiler(@NotNull Function1<? super Path, Unit> callback) throws IOException {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        try {
            this.downloadFile("https://grill.wurstlang.org/hudson/job/Wurst/lastSuccessfulBuild/artifact/downloads/wurstpack_compiler.zip", callback);
        }
        catch (Exception e) {
            log.warn("downloadCompiler Exception caught", (Throwable)e);
            Log.INSTANCE.println("Https error, falling back to unsafe http.");
            this.downloadFile("http://grill.wurstlang.org/hudson/job/Wurst/lastSuccessfulBuild/artifact/downloads/wurstpack_compiler.zip", callback);
        }
    }

    public final void downloadBareboneProject(@NotNull Function1<? super Path, Unit> callback) throws IOException {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        try {
            this.downloadFile("https://github.com/wurstscript/WurstBareboneTemplate/archive/master.zip", callback);
        }
        catch (Exception e) {
            log.warn("downloadBareboneProject Exception caught", (Throwable)e);
            Log.INSTANCE.println("Https error, falling back to unsafe http.");
            this.downloadFile("http://github.com/wurstscript/WurstBareboneTemplate/archive/master.zip", callback);
        }
    }

    private final void downloadDirect(String filePath, Function1<? super Path, Unit> callback) {
        HttpURLConnection httpConnection = this.getHttpURLConnection(filePath);
        int completeFileSize = httpConnection.getContentLength();
        int size = completeFileSize / 1024 / 1024;
        log.info("\t\ud83d\udce5 (" + (size == 0 ? "<1" : Integer.valueOf(size)) + "MB)");
        BufferedInputStream input = new BufferedInputStream(httpConnection.getInputStream());
        String string = filePath.substring(StringsKt.lastIndexOf$default((CharSequence)filePath, (String)"/", (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        Object substring = string;
        if (Files.exists(Paths.get((String)substring, new String[0]), new LinkOption[0])) {
            substring = (String)substring + ".2.jar";
        }
        this.readStream((String)substring, input);
        input.close();
        Path path = Paths.get((String)substring, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        callback.invoke((Object)path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readStream(String substring, BufferedInputStream input) {
        Closeable closeable = new FileOutputStream(substring);
        Throwable throwable = null;
        try {
            FileOutputStream fos = (FileOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new BufferedOutputStream(fos, 1024);
            Throwable throwable2 = null;
            try {
                BufferedOutputStream it = (BufferedOutputStream)closeable2;
                boolean bl2 = false;
                byte[] data = new byte[1024];
                long downloadedFileSize = 0L;
                int x = input.read(data, 0, 1024);
                do {
                    downloadedFileSize += (long)x;
                    it.write(data, 0, x);
                } while ((x = input.read(data, 0, 1024)) >= 0);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

