/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.intermediatelang;

import com.google.common.collect.ImmutableList;
import de.peeeq.wurstscript.intermediatelang.ILconst;
import de.peeeq.wurstscript.intermediatelang.ILconstAbstract;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeString;
import java.util.List;

public class ILconstTuple
extends ILconstAbstract {
    private final ILconst[] values;

    public ILconstTuple(ILconst ... values) {
        this.values = values;
    }

    @Override
    public String print() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean first = true;
        for (ILconst v : this.values) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(v.print());
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public WurstType getType() {
        return WurstTypeString.instance();
    }

    @Override
    public boolean isEqualTo(ILconst other) {
        if (other instanceof ILconstTuple) {
            ILconstTuple o = (ILconstTuple)other;
            if (o.values.length != this.values.length) {
                return false;
            }
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i].equals(o.values[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ILconst getValue(int index) {
        return this.values[index];
    }

    public List<ILconst> values() {
        return ImmutableList.copyOf((Object[])this.values);
    }

    public ILconstTuple updated(int tupleIndex, ILconst newVal) {
        ILconst[] newValues = new ILconst[this.values.length];
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newValues[tupleIndex] = newVal;
        return new ILconstTuple(newValues);
    }
}

