/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.bin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;

public class BinInputStream
extends BinStream
implements AutoCloseable {
    private InputStream _inStream;

    public byte readByte() throws BinStream.StreamException {
        try {
            return this._bytes.get(this._pos++);
        }
        catch (IndexOutOfBoundsException e) {
            throw new BinStream.StreamException(this);
        }
    }

    public byte[] readBytes(int size) throws BinStream.StreamException {
        try {
            byte[] vals = new byte[size];
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = this._bytes.get(this._pos++);
            }
            return vals;
        }
        catch (IndexOutOfBoundsException e) {
            throw new BinStream.StreamException(this, e.getMessage());
        }
    }

    public byte[] readBytes(int size, String label) throws BinStream.StreamException {
        try {
            byte[] vals = new byte[size];
            this.logBegin();
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = this._bytes.get(this._pos++);
            }
            this.log("bytes", label, vals);
            return vals;
        }
        catch (IndexOutOfBoundsException e) {
            throw new BinStream.StreamException(this);
        }
    }

    public void rewind() {
        this._logLines.clear();
        this._pos = 0L;
    }

    public void rewind(long delta) {
        delta = Math.min(this._pos, delta);
        this._pos -= delta;
    }

    public void skip(long delta) {
        this._pos += delta;
    }

    public void read(@Nonnull InputStream inStream) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = inStream.read(buf, 0, buf.length)) != -1) {
            for (int i = 0; i < len; ++i) {
                this._bytes.add(buf[i]);
            }
        }
    }

    public void read(@Nonnull File file) throws IOException {
        InputStream inStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
        this.read(inStream);
        inStream.close();
    }

    @Nonnull
    public byte[] writeToByteArray() {
        BinStream.ByteList bytes = this._bytes;
        if (bytes.size() > Integer.MAX_VALUE) {
            throw new RuntimeException("size out of bounds " + bytes.size());
        }
        byte[] buf = new byte[(int)bytes.size()];
        int i = 0;
        while ((long)i < bytes.size()) {
            buf[i] = bytes.get(i);
            ++i;
        }
        return buf;
    }

    @Override
    public void close() throws IOException {
        this._inStream.close();
    }

    public BinInputStream(@Nonnull InputStream inStream) throws IOException {
        this._inStream = inStream;
        this.read(this._inStream);
    }

    public BinInputStream(@Nonnull File file) throws IOException {
        this._inStream = Files.newInputStream(file.toPath(), new OpenOption[0]);
        this.read(this._inStream);
    }
}

