/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.jassinterpreter.providers;

import com.google.common.collect.ArrayListMultimap;
import de.peeeq.wurstio.jassinterpreter.Implements;
import de.peeeq.wurstio.jassinterpreter.providers.Provider;
import de.peeeq.wurstscript.intermediatelang.ILconst;
import de.peeeq.wurstscript.intermediatelang.ILconstBool;
import de.peeeq.wurstscript.intermediatelang.ILconstInt;
import de.peeeq.wurstscript.intermediatelang.ILconstReal;
import de.peeeq.wurstscript.intermediatelang.ILconstString;
import de.peeeq.wurstscript.intermediatelang.IlConstHandle;
import de.peeeq.wurstscript.intermediatelang.interpreter.AbstractInterpreter;
import java.util.Objects;

public class GamecacheProvider
extends Provider {
    public GamecacheProvider(AbstractInterpreter interpreter) {
        super(interpreter);
    }

    public IlConstHandle InitGameCache(ILconstString name) {
        return new IlConstHandle(name.getVal(), ArrayListMultimap.create());
    }

    @Implements(funcNames={"StoreInteger", "StoreReal", "StoreBoolean", "StoreUnit", "StoreString"})
    public void Store(IlConstHandle ht, ILconstString key1, ILconstString key2, ILconst value) {
        ArrayListMultimap map = (ArrayListMultimap)ht.getObj();
        KeyPair keyPair = new KeyPair(key1.getVal(), key2.getVal());
        GamecacheProvider.deleteIfPresent((ArrayListMultimap<KeyPair, Object>)map, keyPair, value.getClass());
        map.put((Object)keyPair, (Object)value);
    }

    @Implements(funcNames={"SyncStoredInteger", "SyncStoredReal", "SyncStoredBoolean", "SyncStoredUnit", "SyncStoredString"})
    public void Sync(IlConstHandle ht, ILconstString key1, ILconstString key2, ILconst value) {
    }

    public ILconstInt GetStoredInteger(IlConstHandle ht, ILconstString key1, ILconstString key2) {
        return this.haveSaved(ht, key1, key2, ILconstInt.class) ? this.load(ht, key1, key2, ILconstInt.class) : ILconstInt.create(0);
    }

    public ILconstReal GetStoredReal(IlConstHandle ht, ILconstString key1, ILconstString key2) {
        return this.haveSaved(ht, key1, key2, ILconstReal.class) ? this.load(ht, key1, key2, ILconstReal.class) : new ILconstReal(0.0);
    }

    public ILconstString GetStoredString(IlConstHandle ht, ILconstString key1, ILconstString key2) {
        return this.haveSaved(ht, key1, key2, ILconstString.class) ? this.load(ht, key1, key2, ILconstString.class) : new ILconstString("");
    }

    public ILconstBool GetStoredBoolean(IlConstHandle ht, ILconstString key1, ILconstString key2) {
        return this.haveSaved(ht, key1, key2, ILconstBool.class) ? this.load(ht, key1, key2, ILconstBool.class) : ILconstBool.FALSE;
    }

    public IlConstHandle RestoreUnit(IlConstHandle ht, ILconstString key1, ILconstString key2, IlConstHandle player, ILconstReal x, ILconstReal y, ILconstReal facing) {
        return this.load(ht, key1, key2, IlConstHandle.class);
    }

    public void FlushGameCache(IlConstHandle ht) {
        ArrayListMultimap map = (ArrayListMultimap)ht.getObj();
        map.clear();
    }

    public void FlushStoredMission(IlConstHandle ht, ILconstString missionKey) {
        ArrayListMultimap map = (ArrayListMultimap)ht.getObj();
        map.entries().removeIf(entry -> ((KeyPair)entry.getKey()).missionKey.equalsIgnoreCase(missionKey.getVal()));
    }

    public void FlushStoredInteger(IlConstHandle ht, ILconstString key1, ILconstString key2) {
        this.removeSaved(ht, key1, key2, ILconstInt.class);
    }

    public void FlushStoredReal(IlConstHandle ht, ILconstString key1, ILconstString key2) {
        this.removeSaved(ht, key1, key2, ILconstReal.class);
    }

    public void FlushStoredBoolean(IlConstHandle ht, ILconstString key1, ILconstString key2) {
        this.removeSaved(ht, key1, key2, ILconstBool.class);
    }

    public void FlushStoredString(IlConstHandle ht, ILconstString key1, ILconstString key2) {
        this.removeSaved(ht, key1, key2, ILconstString.class);
    }

    public void FlushStoredUnit(IlConstHandle ht, ILconstString key1, ILconstString key2) {
        this.removeSaved(ht, key1, key2, IlConstHandle.class);
    }

    public ILconstBool HaveStoredString(IlConstHandle ht, ILconstString key1, ILconstString key2) {
        return ILconstBool.instance(this.haveSaved(ht, key1, key2, ILconstInt.class));
    }

    public ILconstBool HaveStoredInteger(IlConstHandle ht, ILconstString key1, ILconstString key2) {
        return ILconstBool.instance(this.haveSaved(ht, key1, key2, ILconstInt.class));
    }

    public ILconstBool HaveStoredReal(IlConstHandle ht, ILconstString key1, ILconstString key2) {
        return ILconstBool.instance(this.haveSaved(ht, key1, key2, ILconstReal.class));
    }

    public ILconstBool HaveStoredBoolean(IlConstHandle ht, ILconstString key1, ILconstString key2) {
        return ILconstBool.instance(this.haveSaved(ht, key1, key2, ILconstBool.class));
    }

    public ILconstBool HaveStoredUnit(IlConstHandle ht, ILconstString key1, ILconstString key2) {
        return ILconstBool.instance(this.haveSaved(ht, key1, key2, IlConstHandle.class));
    }

    private <T> T load(IlConstHandle ht, ILconstString key1, ILconstString key2, Class<T> clazz) {
        KeyPair keyPair;
        ArrayListMultimap map = (ArrayListMultimap)ht.getObj();
        if (GamecacheProvider.hasValueOfType((ArrayListMultimap<KeyPair, Object>)map, keyPair = new KeyPair(key1.getVal(), key2.getVal()), clazz)) {
            return GamecacheProvider.getValueOfType((ArrayListMultimap<KeyPair, Object>)map, keyPair, clazz);
        }
        return null;
    }

    private <T> void removeSaved(IlConstHandle ht, ILconstString key1, ILconstString key2, T type) {
        ArrayListMultimap map = (ArrayListMultimap)ht.getObj();
        KeyPair keyPair = new KeyPair(key1.getVal(), key2.getVal());
        GamecacheProvider.deleteIfPresent((ArrayListMultimap<KeyPair, Object>)map, keyPair, type);
    }

    private <T> boolean haveSaved(IlConstHandle ht, ILconstString key1, ILconstString key2, Class<T> clazz) {
        ArrayListMultimap map = (ArrayListMultimap)ht.getObj();
        KeyPair keyPair = new KeyPair(key1.getVal(), key2.getVal());
        return GamecacheProvider.hasValueOfType((ArrayListMultimap<KeyPair, Object>)map, keyPair, clazz);
    }

    private static <T> T getValueOfType(ArrayListMultimap<KeyPair, Object> map, KeyPair key, Class<T> clazz) {
        for (Object o : map.get((Object)key)) {
            if (o.getClass() != clazz) continue;
            return (T)o;
        }
        return null;
    }

    private static <T> boolean hasValueOfType(ArrayListMultimap<KeyPair, Object> map, KeyPair key, Class<T> type) {
        for (Object o : map.get((Object)key)) {
            if (o.getClass() != type) continue;
            return true;
        }
        return false;
    }

    private static <T> void deleteIfPresent(ArrayListMultimap<KeyPair, Object> map, KeyPair key, T type) {
        Object toRemove = null;
        for (Object o : map.get((Object)key)) {
            if (o.getClass() != type) continue;
            toRemove = o;
            break;
        }
        if (toRemove != null && !map.remove((Object)key, toRemove)) {
            throw new Error("object was found but not deleted");
        }
    }

    static class KeyPair {
        String missionKey;
        String key;

        KeyPair(String missionKey, String key) {
            this.missionKey = missionKey;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyPair keyPair = (KeyPair)o;
            return Objects.equals(this.missionKey, keyPair.missionKey) && Objects.equals(this.key, keyPair.key);
        }

        public int hashCode() {
            return Objects.hash(this.missionKey, this.key);
        }
    }
}

