/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.FuncDef;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.attributes.names.NameLink;
import de.peeeq.wurstscript.types.WurstType;
import java.util.Collection;

public class ImplicitFuncs {
    public static FuncDef findToIndexFunc(WurstType typ, Element e) {
        typ = typ.normalize();
        for (NameLink nameLink : ImplicitFuncs.findToIndexFuncs(typ, e)) {
            if (!(nameLink.getDef() instanceof FuncDef)) continue;
            return (FuncDef)nameLink.getDef();
        }
        e.addError("Could not find function " + ImplicitFuncs.toIndexFuncName(typ));
        return null;
    }

    public static FuncDef findFromIndexFunc(WurstType typ, Element e) {
        typ = typ.normalize();
        for (NameLink nameLink : ImplicitFuncs.findFromIndexFuncs(typ, e)) {
            if (!(nameLink.getDef() instanceof FuncDef)) continue;
            return (FuncDef)nameLink.getDef();
        }
        e.addError("Could not find function " + ImplicitFuncs.fromIndexFuncName(typ));
        return null;
    }

    public static String toIndexFuncName(WurstType typ) {
        return typ + "ToIndex";
    }

    public static String fromIndexFuncName(WurstType typ) {
        return typ + "FromIndex";
    }

    public static Collection<FuncLink> findToIndexFuncs(WurstType typ, Element e) {
        String funcName = ImplicitFuncs.toIndexFuncName(typ);
        return ImplicitFuncs.findFunc(e, funcName);
    }

    public static Collection<FuncLink> findFromIndexFuncs(WurstType typ, Element e) {
        String funcName = ImplicitFuncs.fromIndexFuncName(typ);
        return ImplicitFuncs.findFunc(e, funcName);
    }

    private static Collection<FuncLink> findFunc(Element e, String funcName) {
        return e.lookupFuncs(funcName, false);
    }
}

