/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.Chunk;
import net.moonlightflower.wc3libs.misc.model.mdx.Extent;

public class ModelInfoChunk
extends Chunk {
    public static Id TOKEN = Id.valueOf("MODL");
    private String _name = "unset";
    private String _animFileName = "unset";
    private Extent _extent = new Extent();
    private long _blendTime = 0L;

    @Override
    public Id getToken() {
        return TOKEN;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    public void setName(@Nonnull String name) {
        this._name = name;
    }

    @Nonnull
    public String getAnimFileName() {
        return this._animFileName;
    }

    public void setAnimFileName(@Nonnull String animFileName) {
        this._animFileName = animFileName;
    }

    @Nonnull
    public Extent getExtent() {
        return this._extent;
    }

    public void setExtent(@Nonnull Extent extent) {
        this._extent = extent;
    }

    public long getBlendTime() {
        return this._blendTime;
    }

    public void setBlendTime(long blendTime) {
        this._blendTime = blendTime;
    }

    private void read_0x0(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        Chunk.Header header = new Chunk.Header(this, stream);
        this._name = new String(stream.readBytes(80), StandardCharsets.US_ASCII);
        this._animFileName = new String(stream.readBytes(260), StandardCharsets.US_ASCII);
        this._extent = new Extent(stream);
        this._blendTime = stream.readUInt32();
    }

    private void write_0x0(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        Chunk.Header header = new Chunk.Header(this);
        header.write(stream);
        stream.writeBytes(Arrays.copyOf(this._name.getBytes(StandardCharsets.US_ASCII), 80));
        stream.writeBytes(Arrays.copyOf(this._animFileName.getBytes(StandardCharsets.US_ASCII), 260));
        this._extent.write(stream);
        stream.writeUInt32(this._blendTime);
        header.rewrite();
    }

    public void read(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        switch ((MDX.EncodingFormat.Enum)((Object)format.toEnum())) {
            case MDX_0x0: {
                this.read_0x0(stream);
            }
        }
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        switch ((MDX.EncodingFormat.Enum)((Object)format.toEnum())) {
            case MDX_0x0: 
            case AUTO: {
                this.write_0x0(stream);
            }
        }
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public ModelInfoChunk(@Nonnull Wc3BinInputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        this();
        this.read(stream, format);
    }

    public ModelInfoChunk() {
    }
}

