/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.intermediatelang;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.intermediatelang.ILconst;
import de.peeeq.wurstscript.intermediatelang.ILconstAbstract;
import de.peeeq.wurstscript.jassIm.ImClass;
import de.peeeq.wurstscript.jassIm.ImClassType;
import de.peeeq.wurstscript.jassIm.ImVar;
import java.util.List;
import java.util.Optional;

public class ILconstObject
extends ILconstAbstract {
    private final ImClassType classType;
    private final int objectId;
    private final Table<ImVar, List<Integer>, ILconst> attributes = HashBasedTable.create();
    private boolean destroyed = false;
    private final Element trace;

    public ILconstObject(ImClassType classType, int objectId, Element trace) {
        this.classType = classType;
        this.objectId = objectId;
        this.trace = trace;
    }

    public int getObjectId() {
        return this.objectId;
    }

    @Override
    public String print() {
        return this.classType + "_" + this.hashCode();
    }

    @Override
    public boolean isEqualTo(ILconst other) {
        return other == this;
    }

    public void set(ImVar attr, List<Integer> indexes, ILconst value) {
        this.attributes.put((Object)attr, indexes, (Object)value);
    }

    public Optional<ILconst> get(ImVar attr, List<Integer> indexes) {
        return Optional.ofNullable((ILconst)this.attributes.get((Object)attr, indexes));
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void destroy() {
        this.destroyed = true;
    }

    public ImClass getImClass() {
        return this.classType.getClassDef();
    }

    public Element getTrace() {
        return this.trace;
    }

    public ImClassType getType() {
        return this.classType;
    }

    @Override
    public int hashCode() {
        return this.objectId;
    }

    public Table<ImVar, List<Integer>, ILconst> getAttributes() {
        return this.attributes;
    }
}

