/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ConstructorDef;
import de.peeeq.wurstscript.ast.ConstructorDefs;
import de.peeeq.wurstscript.ast.Expr;
import de.peeeq.wurstscript.ast.ExprNewObject;
import de.peeeq.wurstscript.ast.FunctionCall;
import de.peeeq.wurstscript.ast.OptExpr;
import de.peeeq.wurstscript.ast.StmtCall;
import de.peeeq.wurstscript.ast.TypeDef;
import de.peeeq.wurstscript.ast.TypeParamDefs;
import de.peeeq.wurstscript.ast.WParameter;
import de.peeeq.wurstscript.attributes.AttrFuncDef;
import de.peeeq.wurstscript.attributes.AttrImplicitParameter;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.attributes.GenericsHelper;
import de.peeeq.wurstscript.attributes.names.FuncLink;
import de.peeeq.wurstscript.types.FunctionSignature;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.VariablePosition;
import de.peeeq.wurstscript.types.WurstType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AttrPossibleFunctionSignatures {
    public static ImmutableCollection<FunctionSignature> calculate(FunctionCall fc) {
        ImmutableCollection<FuncLink> fs = fc.attrPossibleFuncDefs();
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (FuncLink f : fs) {
            FunctionSignature sig = FunctionSignature.fromNameLink(f);
            OptExpr implicitParameterOpt = AttrImplicitParameter.getFunctionCallImplicitParameter(fc, f, false);
            if (implicitParameterOpt instanceof Expr) {
                Expr expr = (Expr)implicitParameterOpt;
                VariableBinding mapping = expr.attrTyp().matchAgainstSupertype(sig.getReceiverType(), fc, sig.getMapping(), VariablePosition.RIGHT);
                if (mapping == null) continue;
                sig = sig.setTypeArgs(fc, mapping);
            }
            VariableBinding mapping = GenericsHelper.givenBinding(fc, sig.getDefinitionTypeVariables());
            sig = sig.setTypeArgs(fc, mapping);
            resultBuilder.add((Object)sig);
        }
        return AttrPossibleFunctionSignatures.findBestSignature(fc, (ImmutableCollection<FunctionSignature>)resultBuilder.build());
    }

    private static ImmutableCollection<FunctionSignature> findBestSignature(StmtCall fc, ImmutableCollection<FunctionSignature> res) {
        ImmutableList.Builder resultBuilder2 = ImmutableList.builder();
        List<WurstType> argTypes = AttrFuncDef.argumentTypesPre(fc);
        for (FunctionSignature sig2 : res) {
            FunctionSignature sig22 = sig2.matchAgainstArgs(argTypes, fc);
            if (sig22 == null) continue;
            resultBuilder2.add((Object)sig22);
        }
        ImmutableCollection res2 = resultBuilder2.build();
        if (res2.isEmpty()) {
            ImmutableList match3 = (ImmutableList)res.stream().map(sig -> sig.tryMatchAgainstArgs(argTypes, fc.getArgs(), fc)).collect(ImmutableList.toImmutableList());
            if (match3.isEmpty()) {
                return ImmutableList.of();
            }
            FunctionSignature.ArgsMatchResult min = Collections.min(match3, Comparator.comparing(FunctionSignature.ArgsMatchResult::getBadness));
            for (CompileError c : min.getErrors()) {
                fc.getErrorHandler().sendError(c);
            }
            return (ImmutableCollection)match3.stream().map(FunctionSignature.ArgsMatchResult::getSig).collect(ImmutableList.toImmutableList());
        }
        return res2;
    }

    public static ImmutableCollection<FunctionSignature> calculate(ExprNewObject fc) {
        TypeDef typeDef = fc.attrTypeDef();
        if (!(typeDef instanceof ClassDef)) {
            return ImmutableList.of();
        }
        ClassDef classDef = (ClassDef)typeDef;
        ConstructorDefs constructors = classDef.getConstructors();
        ImmutableList.Builder res = ImmutableList.builder();
        for (ConstructorDef f : constructors) {
            WurstType returnType = classDef.attrTyp().dynamic();
            VariableBinding binding2 = GenericsHelper.givenBinding(fc, GenericsHelper.typeParameters(classDef));
            ArrayList paramTypes = Lists.newArrayList();
            for (WParameter p : f.getParameters()) {
                paramTypes.add(p.attrTyp());
            }
            List<String> pNames = FunctionSignature.getParamNames(f.getParameters());
            TypeParamDefs typeParams = classDef.getTypeParameters();
            VariableBinding mapping = VariableBinding.emptyMapping().withTypeVariables(typeParams);
            FunctionSignature sig = new FunctionSignature(f, mapping, null, "construct", paramTypes, pNames, returnType);
            sig = sig.setTypeArgs(fc, binding2);
            res.add((Object)sig);
        }
        return AttrPossibleFunctionSignatures.findBestSignature(fc, (ImmutableCollection<FunctionSignature>)res.build());
    }
}

