/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.txt;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.port.Context;
import net.moonlightflower.wc3libs.port.MpqPort;
import net.moonlightflower.wc3libs.txt.TXT;
import net.moonlightflower.wc3libs.txt.UTF8;

public class WTS {
    public static final File GAME_PATH = new File("war3map.WTS");
    public static final File CAMPAIGN_PATH = new File("war3campaign.WTS");
    private static final Pattern KEY_PATTERN = Pattern.compile("STRING ([\\d]+)[\\n\\s]*\\{([^\\}]*)[\\n]*\\}");
    private static final Pattern COMMENT_PATTERN = Pattern.compile("(?m)^//.*");
    private final Map<Integer, String> _vals = new LinkedHashMap<Integer, String>();

    @Nonnull
    public Map<Integer, String> getKeyedEntries() {
        return this._vals;
    }

    @Nonnull
    public Map<String, String> getNamedEntries() {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        for (Map.Entry<Integer, String> valEntry : this._vals.entrySet()) {
            int key = valEntry.getKey();
            String val = valEntry.getValue();
            res.put(String.format("TRIGSTR_%03d", key), val);
        }
        return res;
    }

    @Nonnull
    public TXT toTXT() {
        TXT txt = new TXT();
        for (Map.Entry<String, String> entry : this.getNamedEntries().entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            txt.set(key, val);
        }
        return txt;
    }

    @Nonnull
    public String getEntry(int key) {
        return this._vals.getOrDefault(key, "");
    }

    public void addEntry(int key, @Nullable String val) {
        this._vals.put(key, val);
    }

    public void removeEntry(int key) {
        this._vals.remove(key);
    }

    public void removeEntry(String object) {
        this._vals.values().remove(object);
    }

    public void write(@Nonnull File file) throws IOException {
        this.write(new FileOutputStream(file));
    }

    public void write(@Nonnull OutputStream outputStream) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        for (Map.Entry<Integer, String> entry : this._vals.entrySet()) {
            int key = entry.getKey();
            String val = entry.getValue();
            writer.write(String.format("STRING %s\r\n{\r\n%s\r\n}\r\n", key, val));
        }
        writer.close();
    }

    private void read(@Nonnull InputStream inStream) throws IOException {
        UTF8 reader = new UTF8(inStream);
        String input = reader.readAll();
        Matcher commentMatcher = COMMENT_PATTERN.matcher(input);
        input = commentMatcher.replaceAll("");
        Matcher matcher = KEY_PATTERN.matcher(input);
        while (matcher.find()) {
            int key = Integer.parseInt(matcher.group(1));
            String val = matcher.group(2).trim();
            this.addEntry(key, val);
        }
    }

    public WTS() {
    }

    public WTS(@Nonnull InputStream inStream) throws IOException {
        this.read(inStream);
    }

    public WTS(@Nonnull File file) throws IOException {
        FileInputStream inStream = new FileInputStream(file);
        this.read(inStream);
        ((InputStream)inStream).close();
    }

    @Nonnull
    public static WTS ofMapFile(@Nonnull File mapFile) throws Exception {
        MpqPort.Out portOut = Context.getService(MpqPort.class).createOut();
        portOut.add(GAME_PATH);
        MpqPort.Out.Result portResult = portOut.commit(mapFile);
        if (!portResult.getExports().containsKey(GAME_PATH)) {
            throw new IOException("could not extract WTS file");
        }
        byte[] bytes = portResult.getExports().get(GAME_PATH).getOutBytes();
        ByteArrayInputStream inStream = new ByteArrayInputStream(bytes);
        WTS wts = new WTS(inStream);
        ((InputStream)inStream).close();
        return wts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WTS wts = (WTS)o;
        return Objects.equals(this._vals, wts._vals);
    }

    public int hashCode() {
        return Objects.hash(this._vals);
    }
}

