/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio;

import de.peeeq.wurstio.gui.GuiUtils;
import de.peeeq.wurstio.utils.FileUtils;
import de.peeeq.wurstscript.ErrorReporting;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.utils.Utils;
import java.awt.Desktop;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class ErrorReportingIO
extends ErrorReporting {
    @Override
    public void handleSevere(Throwable t, String sourcecode) {
        WLogger.severe(t);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String title = "Sor!";
        String message = "You have encountered a bug in the Wurst Compiler.\nYour version is: 1.8.1.0-jenkins-Wurst-1367\nThe Error message is: " + t.getMessage() + "\n" + Utils.printExceptionWithStackTrace(t) + "\n\nWhat do you want to do in order to help us fix this bug?";
        Object[] options = new Object[]{"Nothing", "Send automatic error report", "Create manual bug report"};
        JFrame parent = new JFrame();
        parent.pack();
        parent.setVisible(true);
        GuiUtils.setWindowToCenterOfScreen(parent);
        int n = JOptionPane.showOptionDialog(parent, message, title, 0, 3, null, options, options[1]);
        if (n == 1) {
            boolean[] results = new boolean[3];
            Thread[] threads = new Thread[]{new Thread(() -> {
                results[0] = this.sendErrorReport(t, "");
            }), new Thread(() -> {
                results[1] = this.sendErrorReport(t, "\n\nLog: \n\n" + WLogger.getLog());
            }), new Thread(() -> {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                results[1] = this.sendErrorReport(t, "\n\nSource Code: \n\n" + sourcecode);
            }), new Thread(() -> {
                String customMessage = this.showMultilineMessageDialog();
                results[2] = this.sendErrorReport(t, "Custom message:\n\n" + customMessage);
            })};
            for (Thread tr : threads) {
                tr.start();
            }
            for (Thread tr : threads) {
                try {
                    tr.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            try {
                FileUtils.write(sourcecode, new File("errorreport_source.wurst"));
            }
            catch (IOException e) {
                WLogger.severe(e);
            }
            if (results[0] && results[1] && results[2]) {
                JOptionPane.showMessageDialog(parent, "Thank you!");
            } else if (results[0]) {
                JOptionPane.showMessageDialog(parent, "Error Report could only be sent partially.");
            } else {
                JOptionPane.showMessageDialog(parent, "Error report could not be sent.");
            }
        } else if (n == 2) {
            Desktop desk = Desktop.getDesktop();
            try {
                desk.browse(new URI("https://github.com/peq/WurstScript/issues"));
            }
            catch (Exception e) {
                WLogger.severe(e);
                JOptionPane.showMessageDialog(parent, "Could not open browser.");
            }
        }
        parent.setVisible(false);
        parent.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendErrorReport(Throwable t, String sourcecode) {
        HttpURLConnection connection = null;
        try {
            int ch;
            String data = URLEncoder.encode("errormessage", StandardCharsets.UTF_8) + "=" + URLEncoder.encode(t.getMessage(), StandardCharsets.UTF_8);
            data = data + "&" + URLEncoder.encode("stacktrace", StandardCharsets.UTF_8) + "=" + URLEncoder.encode(Utils.printExceptionWithStackTrace(t), StandardCharsets.UTF_8);
            data = data + "&" + URLEncoder.encode("version", StandardCharsets.UTF_8) + "=" + URLEncoder.encode("1.8.1.0-jenkins-Wurst-1367", StandardCharsets.UTF_8);
            data = data + "&" + URLEncoder.encode("source", StandardCharsets.UTF_8) + "=" + URLEncoder.encode(sourcecode, StandardCharsets.UTF_8);
            String request = "http://peeeq.de/wursterrors.php";
            URL url = new URL(request);
            connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setInstanceFollowRedirects(false);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("charset", "utf-8");
            connection.setRequestProperty("Content-Length", String.valueOf(data.getBytes().length));
            connection.setUseCaches(false);
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(data);
            wr.flush();
            wr.close();
            InputStream input = connection.getInputStream();
            StringBuilder output = new StringBuilder();
            while ((ch = input.read()) >= 0) {
                output.append((char)ch);
            }
            input.close();
            if (!output.toString().startsWith("Success")) {
                ErrorReportingIO.handleError("Could not send error report:\n" + output);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (MalformedURLException e) {
            WLogger.severe(e);
            ErrorReportingIO.handleError("Malformed URL\n" + e.getMessage());
        }
        catch (ProtocolException e) {
            WLogger.severe(e);
            ErrorReportingIO.handleError("ProtocolException\n" + e.getMessage());
        }
        catch (FileNotFoundException e) {
            WLogger.severe(e);
            ErrorReportingIO.handleError("Error reporting URL not found...\n" + e.getMessage());
        }
        catch (IOException e) {
            WLogger.severe(e);
            ErrorReportingIO.handleError("IOException\n" + e.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return false;
    }

    private static void handleError(String msg) {
        WLogger.severe(msg);
        System.err.println(msg);
    }

    private String showMultilineMessageDialog() {
        JTextArea textArea = new JTextArea();
        textArea.setRows(8);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        JScrollPane areaScrollPane = new JScrollPane(textArea);
        JComponent[] inputs = new JComponent[]{new JLabel("Please add some contact information here in case we have further questions regarding this problem."), new JLabel("This can be your hive user-name or your mail address."), new JLabel("You can also add more information on how to reproduce the problem."), areaScrollPane};
        int r = JOptionPane.showConfirmDialog(null, inputs, "My custom dialog", 2);
        if (r == 0) {
            return textArea.getText();
        }
        return "(cancel" + r + " selected) ";
    }
}

