/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.slk.app.objs;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.dataTypes.DataList;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.DataTypeInfo;
import net.moonlightflower.wc3libs.dataTypes.app.AbilId;
import net.moonlightflower.wc3libs.dataTypes.app.ArmorSound;
import net.moonlightflower.wc3libs.dataTypes.app.ItemClass;
import net.moonlightflower.wc3libs.dataTypes.app.ItemId;
import net.moonlightflower.wc3libs.dataTypes.app.Model;
import net.moonlightflower.wc3libs.dataTypes.app.War3Bool;
import net.moonlightflower.wc3libs.dataTypes.app.War3Int;
import net.moonlightflower.wc3libs.dataTypes.app.War3Real;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import net.moonlightflower.wc3libs.misc.FieldId;
import net.moonlightflower.wc3libs.misc.ObjId;
import net.moonlightflower.wc3libs.slk.ObjSLK;
import net.moonlightflower.wc3libs.slk.SLK;

public class ItemSLK
extends ObjSLK<ItemSLK, ItemId, Obj> {
    public static final File GAME_PATH = new File("Units\\ItemData.slk");

    @Override
    protected void read(@Nonnull SLK<?, ? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slk) {
        for (Map.Entry<? extends ObjId, ? extends SLK.Obj<? extends ObjId>> slkEntry : slk.getObjs().entrySet()) {
            ObjId id = slkEntry.getKey();
            SLK.Obj<? extends ObjId> slkObj = slkEntry.getValue();
            Obj obj = new Obj(slkObj);
            this.addObj(obj);
        }
    }

    @Override
    public void read(@Nonnull File file) throws IOException {
        super.read(file);
    }

    @Override
    public void write(@Nonnull File file) throws IOException {
        super.write(file);
    }

    public ItemSLK(SLK slk) {
        this.read(slk);
    }

    public ItemSLK() {
        this.addField(State.OBJ_ID);
        for (State state : State.values(State.class)) {
            this.addField(state);
        }
    }

    public ItemSLK(File file) throws IOException {
        this();
        this.read(file);
    }

    @Override
    @Nonnull
    public Obj createObj(@Nonnull ObjId id) {
        return new Obj(ItemId.valueOf(id));
    }

    @Override
    public void merge(@Nonnull ItemSLK other, boolean overwrite) {
        for (Map.Entry objEntry : other.getObjs().entrySet()) {
            ItemId objId = (ItemId)objEntry.getKey();
            Obj otherObj = (Obj)objEntry.getValue();
            Obj obj = (Obj)this.addObj(objId);
            obj.merge(otherObj);
        }
    }

    public static class Obj
    extends SLK.Obj<ItemId> {
        private final Map<State, DataType> _stateVals = new LinkedHashMap<State, DataType>();

        @Override
        public Map<State, DataType> getStateVals() {
            return new LinkedHashMap<State, DataType>(this._stateVals);
        }

        @Override
        protected void on_set(@Nonnull FieldId fieldId, @Nullable DataType val) {
            State state = (State)State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.put(state, val);
            }
        }

        @Override
        protected void on_remove(@Nonnull FieldId fieldId) {
            State state = (State)State.valueByField(State.class, fieldId);
            if (state != null) {
                this._stateVals.remove(state);
            }
        }

        @Override
        protected void on_clear() {
            this._stateVals.clear();
        }

        public <T extends DataType> T get(State<T> state) {
            try {
                if (!super.contains((FieldId)state.getFieldId())) {
                    return state.getDefVal();
                }
                return state.tryCastVal(super.get((FieldId)state.getFieldId()));
            }
            catch (DataTypeInfo.CastException castException) {
                return null;
            }
        }

        public <T extends DataType> void set(State<T> state, T val) {
            super.set((FieldId)state.getFieldId(), (DataType)val);
        }

        private void read(SLK.Obj<? extends ObjId> slkObj) {
            this.merge(slkObj, true);
        }

        public Obj(SLK.Obj<? extends ObjId> slkObj) {
            super(ItemId.valueOf(slkObj.getId()));
            this.read(slkObj);
        }

        public Obj(ItemId id) {
            super(id);
        }

        @Override
        public void reduce() {
        }
    }

    public static class State<T extends DataType>
    extends ObjSLK.State<T> {
        public static final State<ItemId> OBJ_ID = new State<ItemId>("itemID", ItemId.class);
        public static final State<War3String> EDITOR_COMMENT = new State<War3String>("comment", War3String.class);
        public static final State<War3String> DATA_SCRIPT_NAME = new State<War3String>("scriptname", War3String.class);
        public static final State<War3Int> EDITOR_VERSION = new State<War3Int>("version", War3Int.class);
        public static final State<ItemClass> DATA_CLASS = new State<ItemClass>("class", ItemClass.class);
        public static final State<War3Int> DATA_LEVEL = new State<War3Int>("Level", War3Int.class);
        public static final State<War3Int> DATA_LEVEL_OLD = new State<War3Int>("oldLevel", War3Int.class);
        public static final State<DataList<AbilId>> DATA_ABILS = new State("abilList", new DataTypeInfo((Class<? extends DataType>)DataList.class, (Class<? extends DataType>)AbilId.class));
        public static final State<AbilId> DATA_COOLDOWN_ID = new State<AbilId>("cooldownID", AbilId.class);
        public static final State<War3Bool> DATA_IGNORE_COOLDOWN = new State<War3Bool>("ignoreCD", War3Bool.class);
        public static final State<War3Int> DATA_CHARGES = new State<War3Int>("uses", War3Int.class);
        public static final State<War3Int> DATA_PRIO = new State<War3Int>("prio", War3Int.class);
        public static final State<War3Bool> DATA_USABLE = new State<War3Bool>("usable", War3Bool.class);
        public static final State<War3Bool> DATA_PERISHABLE = new State<War3Bool>("perishable", War3Bool.class);
        public static final State<War3Bool> DATA_DROPPABLE = new State<War3Bool>("droppable", War3Bool.class);
        public static final State<War3Bool> DATA_PAWNABLE = new State<War3Bool>("pawnable", War3Bool.class);
        public static final State<War3Bool> DATA_SELLABLE = new State<War3Bool>("sellable", War3Bool.class);
        public static final State<War3Bool> DATA_USE_IN_RANDOM = new State<War3Bool>("pickRandom", War3Bool.class);
        public static final State<War3Bool> DATA_POWERUP = new State<War3Bool>("powerup", War3Bool.class);
        public static final State<War3Bool> DATA_DROPPED = new State<War3Bool>("drop", War3Bool.class);
        public static final State<War3Int> DATA_STOCK_REGEN = new State<War3Int>("stockMax", War3Int.class);
        public static final State<War3Int> DATA_STOCK_MAX = new State<War3Int>("stockRegen", War3Int.class);
        public static final State<War3Int> DATA_STOCK_INITIAL = new State<War3Int>("stockStart", War3Int.class);
        public static final State<War3Int> DATA_COSTS_GOLD = new State<War3Int>("goldcost", War3Int.class);
        public static final State<War3Int> DATA_COSTS_LUMBER = new State<War3Int>("lumbercost", War3Int.class);
        public static final State<War3Int> DATA_LIFE = new State<War3Int>("HP", War3Int.class);
        public static final State<War3Bool> DATA_MORPHABLE = new State<War3Bool>("morph", War3Bool.class);
        public static final State<ArmorSound> SOUND_ARMOR = new State<ArmorSound>("armor", ArmorSound.class);
        public static final State<Model> ART_MODEL = new State<Model>("file", Model.class);
        public static final State<War3Real> ART_SCALE = new State<War3Real>("scale", War3Real.class);
        public static final State<War3Real> ART_SELECTION_SCALE = new State<War3Real>("selSize", War3Real.class);
        public static final State<War3Int> ART_COLOR_RED = new State<War3Int>("colorB", War3Int.class);
        public static final State<War3Int> ART_COLOR_BLUE = new State<War3Int>("colorR", War3Int.class);
        public static final State<War3Int> ART_COLOR_GREEN = new State<War3Int>("colorG", War3Int.class);
        public static final State<War3Bool> EDITOR_IN_BETA = new State<War3Bool>("InBeta", War3Bool.class);

        public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo, @Nullable T defVal) {
            super(idString, typeInfo, defVal);
        }

        public State(@Nonnull String idString, @Nonnull DataTypeInfo typeInfo) {
            super(idString, typeInfo);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type) {
            super(idString, type);
        }

        public State(@Nonnull String idString, @Nonnull Class<T> type, @Nullable T defVal) {
            super(idString, type, defVal);
        }
    }
}

