/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.dataTypes.app.FlagsInt;
import net.moonlightflower.wc3libs.misc.AsyncTask;
import net.moonlightflower.wc3libs.port.JMpqPort;
import net.moonlightflower.wc3libs.port.MpqPort;
import net.moonlightflower.wc3libs.port.Orient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GamePrefetch {
    private static final Logger log = LoggerFactory.getLogger((String)FlagsInt.class.getName());
    private static File STORAGE_DIR = null;
    private final Queue<Obj> _objs = new LinkedList<Obj>();
    private final List<File> _loadingFiles = new ArrayList<File>();
    private static final Map<File, MpqPort.Out.FileExport> _cache = new LinkedHashMap<File, MpqPort.Out.FileExport>();
    private boolean _started = false;
    private static final int INTERVAL = 1000;
    private static final int MAX_OBJS_PER_CYCLE = 500;
    private ScheduledExecutorService _timeline;
    private Runnable _timelineTask;
    private static final GamePrefetch _instance = new GamePrefetch();

    public void add(@Nonnull Obj obj) {
        File inFile = obj.getInFile();
        if (new File(STORAGE_DIR, inFile.toString()).exists()) {
            // empty if block
        }
        if (_cache.containsKey(inFile)) {
            obj.onFinish(_cache.get(inFile));
            return;
        }
        this._objs.add(obj);
        if (this._loadingFiles.contains(inFile)) {
            return;
        }
        this._loadingFiles.add(inFile);
        if (this._started) {
            return;
        }
        if (this._timeline == null) {
            this._timeline = Executors.newSingleThreadScheduledExecutor();
            this._timelineTask = new Runnable(){

                @Override
                public void run() {
                    ArrayList<File> procFiles = new ArrayList<File>();
                    for (File inFile : GamePrefetch.this._loadingFiles) {
                        procFiles.add(inFile);
                        if (procFiles.size() != 500) continue;
                        break;
                    }
                    GamePrefetch.this._loadingFiles.removeAll(procFiles);
                    1 eventHandler = this;
                    PortTask task = new PortTask(procFiles, GamePrefetch.this._objs, () -> {
                        ArrayList<Obj> removeObjs = new ArrayList<Obj>(GamePrefetch.this._objs);
                        GamePrefetch.this._objs.removeAll(removeObjs);
                        if (GamePrefetch.this._loadingFiles.isEmpty()) {
                            GamePrefetch.this._started = false;
                            GamePrefetch.this._timeline = null;
                            GamePrefetch.this._timelineTask = null;
                        } else {
                            GamePrefetch.this._timeline = Executors.newSingleThreadScheduledExecutor();
                            GamePrefetch.this._timeline.scheduleAtFixedRate(eventHandler, 1000L, 1000L, TimeUnit.MILLISECONDS);
                        }
                    });
                    task.start();
                }
            };
        }
        this._started = true;
        this._timeline.scheduleAtFixedRate(this._timelineTask, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    private void clear() {
        Orient.removeDir(STORAGE_DIR);
        Orient.createDir(STORAGE_DIR);
        _cache.clear();
        this._objs.clear();
    }

    public static GamePrefetch getInstance() {
        return _instance;
    }

    private GamePrefetch() {
    }

    public static void preload(@Nonnull File inFile) {
        GamePrefetch.getInstance().add(new Obj(inFile){

            @Override
            public void onError() {
            }

            @Override
            public void onFinish(MpqPort.Out.FileExport outFile) {
            }
        });
    }

    public static void preload(@Nonnull String inFileS) {
        GamePrefetch.preload(new File(inFileS));
    }

    static {
        try {
            STORAGE_DIR = new File(new File(".").getCanonicalFile(), "prefetch");
            GamePrefetch.getInstance().clear();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private static class PortTask
    extends AsyncTask {
        private final List<File> _procFiles;
        private final Collection<Obj> _objs;
        private MpqPort.Out.Result _result = null;

        @Override
        public void run() {
            JMpqPort.Out port = new JMpqPort.Out();
            for (File inFile : this._procFiles) {
                File outFile = new File(STORAGE_DIR, inFile.toString());
                if (_cache.containsKey(inFile)) continue;
                port.add(inFile, outFile, false);
            }
            try {
                this._result = ((MpqPort.Out)port).commit(MpqPort.getWar3Mpqs());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            throw new AsyncTask.FinishedException();
        }

        @Override
        public void onPostExec() {
            if (this._result != null) {
                File inFile;
                for (Map.Entry<File, MpqPort.Out.Result.Segment> exportEntry : this._result.getExports().entrySet()) {
                    inFile = exportEntry.getKey();
                    MpqPort.Out.Result.Segment segment = exportEntry.getValue();
                    _cache.put(inFile, segment.getExport());
                }
                for (Obj obj : this._objs) {
                    inFile = obj.getInFile();
                    if (_cache.containsKey(inFile)) {
                        obj.onFinish(_cache.get(inFile));
                        continue;
                    }
                    obj.onError();
                }
            }
        }

        public PortTask(@Nonnull List<File> procFiles, @Nonnull Collection<Obj> objs, @Nonnull AsyncTask.FinishedHandler finishedHandler) {
            super(finishedHandler);
            this._procFiles = procFiles;
            this._objs = objs;
        }
    }

    public static abstract class Obj
    implements Comparable<Obj> {
        private final File _inFile;
        private static final int PRIO_LOW = 0;
        private static final int PRIO_MEDIUM = 1;
        private static final int PRIO_HIGH = 2;
        private int _prio = 2;
        private static final Queue<Obj> _toFinish = new ArrayDeque<Obj>();

        public File getInFile() {
            return this._inFile;
        }

        public String toString() {
            return this._inFile.toString();
        }

        @Override
        public int compareTo(@Nonnull Obj other) {
            if (this._prio < other._prio) {
                return -1;
            }
            if (this._prio > other._prio) {
                return 1;
            }
            return 0;
        }

        public void changePriority(int prio) {
            this._prio = prio;
        }

        public abstract void onError();

        public abstract void onFinish(MpqPort.Out.FileExport var1);

        public Obj(@Nonnull File inFile) {
            this._inFile = inFile;
        }
    }
}

