/*
 * Decompiled with CFR 0.152.
 */
package ru.eustas.zopfli;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import ru.eustas.zopfli.Options;
import ru.eustas.zopfli.Zopfli;

class Main {
    Main() {
    }

    public static void main(String[] args) {
        Options.OutputFormat outputType = Options.OutputFormat.GZIP;
        Options.BlockSplitting blockSplitting = Options.BlockSplitting.FIRST;
        int numIterations = 15;
        boolean outputToStdOut = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-c".equals(arg)) {
                outputToStdOut = true;
                continue;
            }
            if ("--deflate".equals(arg)) {
                outputType = Options.OutputFormat.DEFLATE;
                continue;
            }
            if ("--zlib".equals(arg)) {
                outputType = Options.OutputFormat.ZLIB;
                continue;
            }
            if ("--gzip".equals(arg)) {
                outputType = Options.OutputFormat.GZIP;
                continue;
            }
            if ("--splitlast".equals(arg)) {
                blockSplitting = Options.BlockSplitting.LAST;
                continue;
            }
            if (arg.startsWith("--i")) {
                try {
                    numIterations = Integer.parseInt(arg.substring(3));
                    continue;
                }
                catch (NumberFormatException e) {
                    System.err.println("Can't parse number of iterations option.");
                    return;
                }
            }
            if (!"-h".equals(arg)) continue;
            Main.printHelp();
            return;
        }
        if (numIterations < 1) {
            System.err.println("Error: must have 1 or more iterations");
        }
        Zopfli compressor = new Zopfli(0x800000);
        byte[] buffer = new byte[65536];
        Options options = new Options(outputType, blockSplitting, numIterations);
        String fileName = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.charAt(0) == '-') continue;
            fileName = arg;
            String outFileName = outputToStdOut ? null : (outputType == Options.OutputFormat.GZIP ? fileName + ".gz" : (outputType == Options.OutputFormat.ZLIB ? fileName + ".zlib" : fileName + ".deflate"));
            try {
                Main.compressFile(compressor, options, fileName, outFileName, buffer);
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return;
            }
        }
        if (fileName == null) {
            System.err.println("Please provide filename\nFor help, try -h");
        }
    }

    private static void silentlyClose(Closeable stream) {
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFile(String fileName, byte[] buffer) throws IOException {
        FileInputStream inputStream = new FileInputStream(fileName);
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(inputStream.available());
            baos.reset();
            while ((len = inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            Main.silentlyClose(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compressFile(Zopfli compressor, Options options, String fileName, String outFileName, byte[] buffer) throws IOException {
        byte[] input = Main.readFile(fileName, buffer);
        if (input == null) {
            return;
        }
        OutputStream output = outFileName != null ? new FileOutputStream(outFileName) : System.out;
        try {
            compressor.compress(options, input, output);
        }
        finally {
            if (outFileName != null) {
                Main.silentlyClose(output);
            }
        }
    }

    private static void printHelp() {
        System.err.println("Usage: zopfli [OPTION]... FILE\n  -h    gives this help\n  -c    write the result on standard output, instead of disk filename + '.gz'\n  --i#  perform # iterations (default 15). More gives more compression but is slower. Examples: --i10, --i50, --i1000\n  --gzip        output to gzip format (default)\n  --zlib        output to zlib format instead of gzip\n  --deflate     output to deflate format instead of gzip\n  --splitlast   do block splitting last instead of first");
    }
}

