/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.intermediatelang.optimizer;

import de.peeeq.datastructures.Worklist;
import de.peeeq.wurstscript.intermediatelang.optimizer.ControlFlowGraph;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImLExpr;
import de.peeeq.wurstscript.jassIm.ImMemberAccess;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImSet;
import de.peeeq.wurstscript.jassIm.ImStatementExpr;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImTupleExpr;
import de.peeeq.wurstscript.jassIm.ImTupleSelection;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVarAccess;
import de.peeeq.wurstscript.jassIm.ImVarArrayAccess;
import de.peeeq.wurstscript.jassIm.ImVarargLoop;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imoptimizer.OptimizerPass;
import de.peeeq.wurstscript.translation.imtranslation.FunctionFlagEnum;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.TypesHelper;
import io.vavr.collection.HashSet;
import io.vavr.collection.Set;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

public class LocalMerger
implements OptimizerPass {
    private int totalLocalsMerged = 0;

    @Override
    public int optimize(ImTranslator trans) {
        ImProg prog = trans.getImProg();
        this.totalLocalsMerged = 0;
        for (ImFunction func : ImHelper.calculateFunctionsOfProg(prog)) {
            if (func.isNative() || func.isBj()) continue;
            this.optimizeFunc(func);
        }
        return this.totalLocalsMerged;
    }

    @Override
    public String getName() {
        return "Local variables merged";
    }

    void optimizeFunc(ImFunction func) {
        Map<ImStmt, Set<ImVar>> livenessInfo = this.calculateLiveness(func);
        this.eliminateDeadCode(livenessInfo);
        this.mergeLocals(livenessInfo, func);
    }

    private boolean canMerge(ImType a, ImType b) {
        return a.equalsType(b);
    }

    private void mergeLocals(Map<ImStmt, Set<ImVar>> livenessInfo, ImFunction func) {
        Map<ImVar, Set<ImVar>> inferenceGraph = this.calculateInferenceGraph(livenessInfo);
        PriorityQueue<ImVar> vars = new PriorityQueue<ImVar>((a, b) -> ((Set)inferenceGraph.get(b)).size() - ((Set)inferenceGraph.get(a)).size());
        vars.addAll(inferenceGraph.keySet());
        vars.removeAll(func.getParameters());
        ArrayList<ImVar> assigned = new ArrayList<ImVar>(func.getParameters());
        if (func.hasFlag(FunctionFlagEnum.IS_VARARG)) {
            assigned.remove(assigned.size() - 1);
        }
        final HashMap<ImVar, ImVar> merges = new HashMap<ImVar, ImVar>();
        block0: while (!vars.isEmpty()) {
            ImVar v = (ImVar)vars.poll();
            block1: for (ImVar other : assigned) {
                if (!this.canMerge(other.getType(), v.getType())) continue;
                for (ImVar inferingVar : inferenceGraph.get(v)) {
                    if (merges.getOrDefault(inferingVar, inferingVar) != other) continue;
                    continue block1;
                }
                merges.put(v, other);
                continue block0;
            }
            assigned.add(v);
        }
        this.totalLocalsMerged += merges.size();
        func.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImVarAccess va) {
                super.visit(va);
                ImVar v = va.getVar();
                if (merges.containsKey(v)) {
                    va.setVar((ImVar)merges.get(v));
                }
            }

            @Override
            public void visit(ImSet set) {
                ImVar v;
                super.visit(set);
                if (set.getLeft() instanceof ImVarAccess && merges.containsKey(v = ((ImVarAccess)set.getLeft()).getVar())) {
                    set.setLeft(JassIm.ImVarAccess((ImVar)merges.get(v)));
                }
            }

            @Override
            public void visit(ImVarargLoop varargLoop) {
                super.visit(varargLoop);
                ImVar v = varargLoop.getLoopVar();
                if (merges.containsKey(v)) {
                    varargLoop.setLoopVar((ImVar)merges.get(v));
                }
            }
        });
    }

    private Map<ImVar, Set<ImVar>> calculateInferenceGraph(Map<ImStmt, Set<ImVar>> livenessInfo) {
        LinkedHashMap<ImVar, Set<ImVar>> inferenceGraph = new LinkedHashMap<ImVar, Set<ImVar>>();
        java.util.Set<ImStmt> keys = livenessInfo.keySet();
        int i = 0;
        for (ImStmt s : keys) {
            ++i;
            Set<ImVar> live = livenessInfo.get(s);
            for (ImVar v1 : live) {
                Set inferenceSet = inferenceGraph.getOrDefault(v1, (Set<ImVar>)HashSet.empty());
                inferenceSet = inferenceSet.addAll((Iterable)live.filter(v2 -> this.canMerge(v1.getType(), v2.getType())));
                inferenceGraph.put(v1, (Set<ImVar>)inferenceSet);
            }
        }
        return inferenceGraph;
    }

    private void eliminateDeadCode(Map<ImStmt, Set<ImVar>> livenessInfo) {
        for (ImStmt s : livenessInfo.keySet()) {
            if (!(s instanceof ImSet)) continue;
            ImSet imSet = (ImSet)s;
            ImVar v = null;
            if (imSet.getLeft() instanceof ImVarAccess) {
                ImVarAccess va = (ImVarAccess)imSet.getLeft();
                v = va.getVar();
            } else if (imSet.getLeft() instanceof ImTupleSelection) {
                v = TypesHelper.getSimpleAndPureTupleVar((ImTupleSelection)imSet.getLeft());
            }
            if (v == null || v.isGlobal() || livenessInfo.get(s).contains((Object)v)) continue;
            ImExpr right = imSet.getRight();
            right.setParent(null);
            s.replaceBy(right);
        }
    }

    public Map<ImStmt, Set<ImVar>> calculateLiveness(ImFunction func) {
        ControlFlowGraph cfg = new ControlFlowGraph(func.getBody());
        LinkedHashMap<ControlFlowGraph.Node, Object> in = new LinkedHashMap<ControlFlowGraph.Node, Object>();
        LinkedHashMap<ControlFlowGraph.Node, Object> out = new LinkedHashMap<ControlFlowGraph.Node, Object>();
        Worklist<ControlFlowGraph.Node> todo = new Worklist<ControlFlowGraph.Node>();
        LinkedHashMap<ControlFlowGraph.Node, Integer> index = new LinkedHashMap<ControlFlowGraph.Node, Integer>();
        for (ControlFlowGraph.Node node : cfg.getNodes()) {
            in.put(node, HashSet.empty());
            out.put(node, HashSet.empty());
            todo.addFirst(node);
            index.put(node, 1 + index.size());
        }
        Map<ControlFlowGraph.Node, Set<ImVar>> def = this.calculateDefs(cfg.getNodes());
        Map<ControlFlowGraph.Node, Set<ImVar>> use = this.calculateUses(cfg.getNodes());
        while (!todo.isEmpty()) {
            Set newOut;
            ControlFlowGraph.Node node = (ControlFlowGraph.Node)todo.poll();
            Set newIn = newOut = node.getSuccessors().stream().map(in::get).reduce((Set)HashSet.empty(), Set::union);
            newIn = newIn.diff(def.get(node));
            if (!(newIn = newIn.union(use.get(node))).equals(in.get(node))) {
                in.put(node, newIn);
                for (ControlFlowGraph.Node pred : node.getPredecessors()) {
                    todo.addLast(pred);
                }
            }
            if (newOut.equals(out.get(node))) continue;
            out.put(node, newOut);
        }
        LinkedHashMap<ImStmt, Set<ImVar>> result = new LinkedHashMap<ImStmt, Set<ImVar>>();
        for (ControlFlowGraph.Node node : cfg.getNodes()) {
            ImStmt stmt = node.getStmt();
            if (stmt == null) continue;
            result.put(stmt, (Set<ImVar>)((Set)out.get(node)));
        }
        return result;
    }

    private Map<ControlFlowGraph.Node, Set<ImVar>> calculateUses(List<ControlFlowGraph.Node> nodes) {
        LinkedHashMap<ControlFlowGraph.Node, Set<ImVar>> result = new LinkedHashMap<ControlFlowGraph.Node, Set<ImVar>>();
        for (ControlFlowGraph.Node node : nodes) {
            final ArrayList uses = new ArrayList();
            ImStmt stmt = node.getStmt();
            if (stmt != null) {
                stmt.accept(new Element.DefaultVisitor(){

                    @Override
                    public void visit(ImVarAccess va) {
                        super.visit(va);
                        if (!va.getVar().isGlobal()) {
                            uses.add(va.getVar());
                        }
                    }

                    @Override
                    public void visit(ImSet set) {
                        set.getRight().accept(this);
                        final 2 outerThis = this;
                        set.getLeft().match(new ImLExpr.MatcherVoid(){

                            @Override
                            public void case_ImTupleSelection(ImTupleSelection e) {
                                ((ImLExpr)e.getTupleExpr()).match(this);
                            }

                            @Override
                            public void case_ImVarAccess(ImVarAccess e) {
                            }

                            @Override
                            public void case_ImVarArrayAccess(ImVarArrayAccess e) {
                                e.getIndexes().accept(outerThis);
                            }

                            @Override
                            public void case_ImMemberAccess(ImMemberAccess e) {
                                e.getReceiver().accept(outerThis);
                                e.getIndexes().accept(outerThis);
                            }

                            @Override
                            public void case_ImStatementExpr(ImStatementExpr e) {
                                e.getStatements().accept(outerThis);
                                ((ImLExpr)e.getExpr()).match(this);
                            }

                            @Override
                            public void case_ImTupleExpr(ImTupleExpr e) {
                                for (ImExpr expr : e.getExprs()) {
                                    ((ImLExpr)expr).match(this);
                                }
                            }
                        });
                    }
                });
            }
            result.put(node, (Set<ImVar>)HashSet.ofAll(uses));
        }
        return result;
    }

    private Map<ControlFlowGraph.Node, Set<ImVar>> calculateDefs(List<ControlFlowGraph.Node> nodes) {
        LinkedHashMap<ControlFlowGraph.Node, Set<ImVar>> result = new LinkedHashMap<ControlFlowGraph.Node, Set<ImVar>>();
        for (ControlFlowGraph.Node node : nodes) {
            ImVar v;
            ImSet imSet;
            result.put(node, (Set<ImVar>)HashSet.empty());
            ImStmt stmt = node.getStmt();
            if (!(stmt instanceof ImSet) || !((imSet = (ImSet)stmt).getLeft() instanceof ImVarAccess) || (v = ((ImVarAccess)imSet.getLeft()).getVar()).isGlobal()) continue;
            result.put(node, (Set<ImVar>)HashSet.of((Object)v));
        }
        return result;
    }
}

