/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.os.OS;
import dorkbox.util.LocationResolver;
import dorkbox.util.Sys;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\fJ\u0016\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0004J\u0016\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u001e"}, d2={"Ldorkbox/util/FontUtil;", "", "()V", "FONTS_LOCATION", "", "getFONTS_LOCATION", "()Ljava/lang/String;", "setFONTS_LOCATION", "(Ljava/lang/String;)V", "version", "getVersion", "getAlphaNumericFontHeight", "", "font", "Ljava/awt/Font;", "getFontAsImage", "Ljava/awt/image/BufferedImage;", "text", "foregroundColor", "Ljava/awt/Color;", "getFontForSpecificHeight", "height", "getFontHeight", "string", "getFontWidth", "getMaxFontHeight", "loadAllFonts", "", "parseFont", "fontInfo", "Utilities"})
public final class FontUtil {
    @NotNull
    public static final FontUtil INSTANCE = new FontUtil();
    @NotNull
    private static final String version = Sys.INSTANCE.getVersion();
    @NotNull
    private static volatile String FONTS_LOCATION = OS.INSTANCE.getProperty(FontUtil.class.getCanonicalName() + ".FONTS_LOCATION", "resources/fonts");

    private FontUtil() {
    }

    @NotNull
    public final String getVersion() {
        return version;
    }

    @NotNull
    public final String getFONTS_LOCATION() {
        return FONTS_LOCATION;
    }

    public final void setFONTS_LOCATION(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        FONTS_LOCATION = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadAllFonts() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Enumeration<URL> enumeration = LocationResolver.Companion.getResources(FONTS_LOCATION);
        if (enumeration == null) {
            return;
        }
        Enumeration<URL> fonts = enumeration;
        if (fonts.hasMoreElements()) {
            fonts.nextElement();
            while (fonts.hasMoreElements()) {
                URL url = fonts.nextElement();
                InputStream is = null;
                try {
                    String path = url.toURI().getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                    if (!StringsKt.endsWith$default((String)path, (String)".ttf", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)path, (String)".otf", (boolean)false, (int)2, null)) continue;
                    is = url.openStream();
                    Font newFont = Font.createFont(0, is);
                    ge.registerFont(newFont);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                catch (FontFormatException e) {
                    e.printStackTrace();
                }
                finally {
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @NotNull
    public final Font parseFont(@NotNull String fontInfo) {
        Font font;
        Intrinsics.checkNotNullParameter((Object)fontInfo, (String)"fontInfo");
        try {
            int sizeIndex = StringsKt.lastIndexOf$default((CharSequence)fontInfo, (String)" ", (int)0, (boolean)false, (int)6, null);
            String string = fontInfo.substring(sizeIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String size = string;
            int styleIndex = StringsKt.indexOf$default((CharSequence)fontInfo, (String)" ", (int)(sizeIndex - 7), (boolean)false, (int)4, null);
            String string2 = fontInfo.substring(styleIndex + 1, sizeIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String styleString = string2;
            int style = 0;
            if (StringsKt.equals((String)styleString, (String)"bold", (boolean)true)) {
                style = 1;
            } else if (StringsKt.equals((String)styleString, (String)"italic", (boolean)true)) {
                style = 2;
            }
            String string3 = fontInfo.substring(0, styleIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String fontName = string3;
            font = new Font(fontName, style, Integer.parseInt(size));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load font info from '" + fontInfo + '\'', e);
        }
        return font;
    }

    @NotNull
    public final Font getFontForSpecificHeight(@NotNull Font font, int height) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        int size = font.getSize();
        Boolean lastAction = null;
        while (true) {
            Boolean bl;
            Font fontCheck;
            int maxFontHeight;
            if ((maxFontHeight = this.getMaxFontHeight(fontCheck = new Font(font.getName(), 0, size))) < height && lastAction != Boolean.FALSE) {
                ++size;
                bl = Boolean.TRUE;
            } else if (maxFontHeight > height && lastAction != Boolean.TRUE) {
                --size;
                bl = Boolean.FALSE;
            } else {
                return fontCheck;
            }
            lastAction = bl;
        }
    }

    public final int getFontHeight(@NotNull Font font, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        BufferedImage image = new BufferedImage(1, 1, 2);
        Graphics2D g = image.createGraphics();
        FontRenderContext frc = g.getFontRenderContext();
        GlyphVector gv = font.createGlyphVector(frc, string);
        int height = gv.getPixelBounds(null, (float)0.0f, (float)0.0f).height;
        g.dispose();
        return height;
    }

    public final int getFontWidth(@NotNull Font font, @NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        BufferedImage image = new BufferedImage(1, 1, 2);
        Graphics2D g = image.createGraphics();
        FontRenderContext frc = g.getFontRenderContext();
        GlyphVector gv = font.createGlyphVector(frc, string);
        int width = gv.getPixelBounds(null, (float)0.0f, (float)0.0f).width;
        g.dispose();
        return width;
    }

    public final int getAlphaNumericFontHeight(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        BufferedImage image = new BufferedImage(1, 1, 2);
        Graphics2D g = image.createGraphics();
        FontMetrics metrics = g.getFontMetrics(font);
        int height = metrics.getAscent() + metrics.getDescent();
        g.dispose();
        return height;
    }

    public final int getMaxFontHeight(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        BufferedImage image = new BufferedImage(1, 1, 2);
        Graphics2D g = image.createGraphics();
        FontMetrics metrics = g.getFontMetrics(font);
        int height = metrics.getMaxAscent() + metrics.getMaxDescent();
        g.dispose();
        return height;
    }

    @NotNull
    public final BufferedImage getFontAsImage(@NotNull Font font, @NotNull String text, @NotNull Color foregroundColor) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)foregroundColor, (String)"foregroundColor");
        BufferedImage img = new BufferedImage(1, 1, 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setFont(font);
        FontMetrics fm = g2d.getFontMetrics();
        int width = fm.stringWidth(text);
        int height = fm.getHeight();
        g2d.dispose();
        if (width > height) {
            height = width;
        } else {
            width = height;
        }
        img = new BufferedImage(width, height, 2);
        g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setFont(font);
        fm = g2d.getFontMetrics();
        g2d.setColor(foregroundColor);
        g2d.drawString(text, (float)width / 4.0f, (float)fm.getAscent());
        g2d.dispose();
        return img;
    }
}

