/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio.languageserver;

import de.peeeq.wurstio.languageserver.WFile;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.ModuleInstanciations;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.CompileError;
import io.vavr.collection.HashSet;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4j.PublishDiagnosticsParams;

public interface ModelManager {
    public Changes removeCompilationUnit(WFile var1);

    public void clean();

    public List<CompileError> getParseErrors();

    public void onCompilationResult(Consumer<PublishDiagnosticsParams> var1);

    public void buildProject();

    public Changes syncCompilationUnit(WFile var1);

    public Changes syncCompilationUnitContent(WFile var1, String var2);

    public CompilationUnit replaceCompilationUnitContent(WFile var1, String var2, boolean var3);

    public Set<File> getDependencyWurstFiles();

    public @Nullable CompilationUnit getCompilationUnit(WFile var1);

    public WurstModel getModel();

    public boolean hasErrors();

    public static WurstModel copy(WurstModel model) {
        WurstModel m = model.copy();
        m.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ModuleInstanciations mis) {
                super.visit(mis);
                mis.clear();
            }
        });
        return m;
    }

    public File getProjectPath();

    public String getFirstErrorDescription();

    public void reconcile(Changes var1);

    public static class Changes {
        private static final Changes EMPTY = new Changes((Iterable<WFile>)HashSet.empty(), (Iterable<String>)HashSet.empty());
        private final HashSet<WFile> affectedFiles;
        private final HashSet<String> affectedPackageNames;

        public Changes(Iterable<WFile> affectedFiles, Iterable<String> affectedPackageNames) {
            this.affectedFiles = HashSet.ofAll(affectedFiles);
            this.affectedPackageNames = HashSet.ofAll(affectedPackageNames);
        }

        public Changes(Stream<WFile> affectedFiles, Stream<String> affectedPackageNames) {
            this.affectedFiles = HashSet.ofAll(affectedFiles);
            this.affectedPackageNames = HashSet.ofAll(affectedPackageNames);
        }

        public static Changes empty() {
            return EMPTY;
        }

        public HashSet<WFile> getAffectedFiles() {
            return this.affectedFiles;
        }

        public HashSet<String> getAffectedPackageNames() {
            return this.affectedPackageNames;
        }

        public Changes mergeWith(Changes affected) {
            HashSet newF = this.affectedFiles.addAll(affected.affectedFiles);
            HashSet newP = this.affectedPackageNames.addAll(affected.affectedPackageNames);
            if (newF == this.affectedFiles && newP == this.affectedPackageNames) {
                return this;
            }
            return new Changes((Iterable<WFile>)newF, (Iterable<String>)newP);
        }

        public boolean isEmpty() {
            return this.affectedFiles.isEmpty() && this.affectedPackageNames.isEmpty();
        }
    }
}

