/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import config.WurstProjectConfigData;
import de.peeeq.wurstio.AbortCompilationException;
import de.peeeq.wurstio.CompiletimeFunctionRunner;
import de.peeeq.wurstio.ModelChangedException;
import de.peeeq.wurstio.TimeTaker;
import de.peeeq.wurstio.languageserver.requests.RequestFailedException;
import de.peeeq.wurstio.map.importer.ImportFile;
import de.peeeq.wurstio.mpq.MpqEditor;
import de.peeeq.wurstio.utils.FileReading;
import de.peeeq.wurstio.utils.FileUtils;
import de.peeeq.wurstscript.ErrorReporting;
import de.peeeq.wurstscript.RunArgs;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.WurstChecker;
import de.peeeq.wurstscript.WurstCompiler;
import de.peeeq.wurstscript.WurstOperator;
import de.peeeq.wurstscript.WurstParser;
import de.peeeq.wurstscript.ast.Ast;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.JassToplevelDeclaration;
import de.peeeq.wurstscript.ast.WImport;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.CompilationUnitInfo;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.attributes.ErrorHandler;
import de.peeeq.wurstscript.gui.WurstGui;
import de.peeeq.wurstscript.jassAst.JassProg;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ImCompiletimeExpr;
import de.peeeq.wurstscript.jassIm.ImExpr;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImFunctionCall;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImStmt;
import de.peeeq.wurstscript.jassIm.ImStmts;
import de.peeeq.wurstscript.jassIm.ImTypeArgument;
import de.peeeq.wurstscript.jassIm.ImTypeVar;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.luaAst.LuaCompilationUnit;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.translation.imoptimizer.ImOptimizer;
import de.peeeq.wurstscript.translation.imtojass.ImAttrType;
import de.peeeq.wurstscript.translation.imtojass.ImToJassTranslator;
import de.peeeq.wurstscript.translation.imtranslation.AssertProperty;
import de.peeeq.wurstscript.translation.imtranslation.CallType;
import de.peeeq.wurstscript.translation.imtranslation.CyclicFunctionRemover;
import de.peeeq.wurstscript.translation.imtranslation.DebugMessageRemover;
import de.peeeq.wurstscript.translation.imtranslation.EliminateClasses;
import de.peeeq.wurstscript.translation.imtranslation.EliminateGenerics;
import de.peeeq.wurstscript.translation.imtranslation.EliminateLocalTypes;
import de.peeeq.wurstscript.translation.imtranslation.EliminateTuples;
import de.peeeq.wurstscript.translation.imtranslation.FuncRefRemover;
import de.peeeq.wurstscript.translation.imtranslation.FunctionFlagEnum;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.translation.imtranslation.MultiArrayEliminator;
import de.peeeq.wurstscript.translation.imtranslation.StackTraceInjector2;
import de.peeeq.wurstscript.translation.imtranslation.VarargEliminator;
import de.peeeq.wurstscript.translation.lua.translation.LuaTranslator;
import de.peeeq.wurstscript.types.TypesHelper;
import de.peeeq.wurstscript.utils.LineOffsets;
import de.peeeq.wurstscript.utils.NotNullList;
import de.peeeq.wurstscript.utils.TempDir;
import de.peeeq.wurstscript.utils.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.lsp4j.MessageType;
import org.jetbrains.annotations.NotNull;

public class WurstCompilerJassImpl
implements WurstCompiler {
    private final List<File> files = Lists.newArrayList();
    private final Map<String, Reader> otherInputs = Maps.newLinkedHashMap();
    private @Nullable JassProg prog;
    private final WurstGui gui;
    private boolean hasCommonJ;
    private RunArgs runArgs;
    private Optional<File> mapFile = Optional.empty();
    private @Nullable File projectFolder;
    private final ErrorHandler errorHandler;
    private @Nullable Map<String, File> libCache = null;
    private @Nullable ImProg imProg;
    private final List<File> parsedFiles = Lists.newArrayList();
    private final WurstParser parser;
    private final WurstChecker checker;
    private @Nullable ImTranslator imTranslator;
    private final List<File> dependencies = Lists.newArrayList();
    private final @Nullable MpqEditor mapFileMpq;
    private final TimeTaker timeTaker;
    private static final Map<File, WeakReference<CompilationUnit>> fileCompilationUnitCache = new HashMap<File, WeakReference<CompilationUnit>>();

    public WurstCompilerJassImpl(@Nullable File projectFolder, WurstGui gui, @Nullable MpqEditor mapFileMpq, RunArgs runArgs) {
        this(new TimeTaker.Default(), projectFolder, gui, mapFileMpq, runArgs);
    }

    public WurstCompilerJassImpl(TimeTaker timeTaker, @Nullable File projectFolder, WurstGui gui, @Nullable MpqEditor mapFileMpq, RunArgs runArgs) {
        this.timeTaker = timeTaker;
        this.projectFolder = projectFolder;
        this.gui = gui;
        this.runArgs = runArgs;
        this.errorHandler = new ErrorHandler(gui);
        this.parser = new WurstParser(this.errorHandler, gui);
        this.checker = new WurstChecker(gui, this.errorHandler);
        this.mapFileMpq = mapFileMpq;
    }

    @Override
    public void loadFiles(String ... filenames) {
        this.gui.sendProgress("Loading Files");
        for (String filename : filenames) {
            File file = new File(filename);
            if (!file.exists()) {
                throw new Error("File " + filename + " does not exist.");
            }
            this.files.add(file);
        }
    }

    @Override
    public void loadFiles(File ... files) {
        this.gui.sendProgress("Loading Files");
        for (File file : files) {
            this.loadFile(file);
        }
    }

    @Override
    public void runCompiletime(WurstProjectConfigData projectConfigData, boolean isProd, boolean cache) {
        if (this.runArgs.runCompiletimeFunctions()) {
            this.gui.sendProgress("Running compiletime functions");
            CompiletimeFunctionRunner ctr = new CompiletimeFunctionRunner(this.imTranslator, this.getImProg(), this.getMapFile(), this.getMapfileMpqEditor(), this.gui, CompiletimeFunctionRunner.FunctionFlagToRun.CompiletimeFunctions, projectConfigData, isProd, cache);
            ctr.setInjectObjects(this.runArgs.isInjectObjects());
            ctr.setOutputStream(new PrintStream(System.err));
            ctr.run();
        }
        if (this.gui.getErrorCount() > 0) {
            CompileError compileError = this.gui.getErrorList().get(0);
            throw new RequestFailedException(MessageType.Error, "Could not compile project (error in running compiletime functions/expressions): ", compileError);
        }
        if (this.runArgs.isInjectObjects()) {
            Preconditions.checkNotNull((Object)this.mapFileMpq);
            Preconditions.checkNotNull((Object)this.projectFolder);
            ImportFile.importFilesFromImports(this.projectFolder, this.mapFileMpq);
        }
    }

    private void loadFile(File file) throws Error {
        Preconditions.checkNotNull((Object)file);
        if (!file.exists()) {
            throw new Error("File " + file + " does not exist.");
        }
        this.files.add(file);
    }

    public void loadWurstFilesInDir(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.loadWurstFilesInDir(f);
                continue;
            }
            if (Utils.isWurstFile(f)) {
                this.loadFile(f);
                continue;
            }
            if (f.getName().equals("wurst.dependencies")) {
                this.dependencies.addAll((Collection<File>)WurstCompilerJassImpl.checkDependencyFile(f, this.gui));
                continue;
            }
            if (this.mapFile.isPresent() && !this.runArgs.isNoExtractMapScript() || !f.getName().equals("war3map.j")) continue;
            this.loadFile(f);
        }
    }

    public static ImmutableList<File> checkDependencyFile(File depFile, WurstGui gui) {
        List lines;
        try {
            lines = Files.readLines((File)depFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error(e);
        }
        LineOffsets offsets = new LineOffsets();
        int lineNr = 0;
        int offset = 0;
        for (String line : lines) {
            offsets.set(lineNr, offset);
            ++lineNr;
            offset += line.length() + 1;
        }
        offsets.set(lineNr, offset);
        lineNr = 0;
        ImmutableList.Builder dependencies = ImmutableList.builder();
        for (String line : lines) {
            int lineOffset = offsets.get(lineNr);
            WPos pos = new WPos(depFile.getAbsolutePath(), offsets, lineOffset + 1, lineOffset + line.length() + 1);
            File folder = new File(line);
            if (!folder.exists()) {
                gui.sendError(new CompileError(pos, "Folder " + line + " not found."));
            } else if (!folder.isDirectory()) {
                gui.sendError(new CompileError(pos, line + " is not a folder."));
            } else {
                dependencies.add((Object)folder);
            }
            ++lineNr;
        }
        return dependencies.build();
    }

    @Override
    public @Nullable WurstModel parseFiles() {
        for (File file : this.files) {
            if (file.getName().endsWith(".w3x") || file.getName().endsWith(".w3m")) {
                this.mapFile = Optional.ofNullable(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            if (this.projectFolder != null && !file.getParent().equals(this.projectFolder.getAbsolutePath())) {
                throw new RuntimeException("Cannot set projectFolder to " + file + " because it is already set to non parent " + this.projectFolder);
            }
            this.projectFolder = file;
        }
        Optional<File> l_mapFile = this.mapFile;
        if (l_mapFile.isPresent()) {
            File relativeWurstDir;
            if (this.projectFolder == null) {
                this.projectFolder = l_mapFile.get().getParentFile();
            }
            if ((relativeWurstDir = new File(this.projectFolder, "wurst")).exists()) {
                WLogger.info("Importing wurst files from " + relativeWurstDir);
                this.loadWurstFilesInDir(relativeWurstDir);
            } else {
                WLogger.info("No wurst folder found in " + relativeWurstDir);
            }
            File dependencyFile = new File(this.projectFolder, "wurst.dependencies");
            if (dependencyFile.exists()) {
                this.dependencies.addAll((Collection<File>)WurstCompilerJassImpl.checkDependencyFile(dependencyFile, this.gui));
            }
            WurstCompilerJassImpl.addDependenciesFromFolder(this.projectFolder, this.dependencies);
        }
        ArrayList dirs = Lists.newArrayList();
        for (File file : this.files) {
            if (!file.isDirectory()) continue;
            dirs.add(file);
        }
        for (Iterator<Map.Entry<String, Reader>> dir : dirs) {
            this.loadWurstFilesInDir((File)((Object)dir));
        }
        this.gui.sendProgress("Parsing Files");
        NotNullList<CompilationUnit> compilationUnits = new NotNullList<CompilationUnit>();
        for (File file : this.files) {
            if (file.isDirectory()) continue;
            if (file.getName().endsWith(".w3x") || file.getName().endsWith(".w3m")) {
                CompilationUnit r = this.processMap(file);
                if (r == null) continue;
                compilationUnits.add(r);
                continue;
            }
            if (file.getName().endsWith("common.j")) {
                this.hasCommonJ = true;
            }
            compilationUnits.add(this.parseFile(file));
        }
        for (Map.Entry<String, Reader> in : this.otherInputs.entrySet()) {
            compilationUnits.add(this.parse(in.getKey(), in.getValue()));
        }
        try {
            this.addImportedLibs(compilationUnits);
        }
        catch (CompileError e) {
            this.gui.sendError(e);
            return null;
        }
        if (this.errorHandler.getErrorCount() > 0) {
            return null;
        }
        WurstModel merged = this.mergeCompilationUnits(compilationUnits);
        StringBuilder sb = new StringBuilder();
        for (CompilationUnit cu : merged) {
            sb.append(cu.getCuInfo().getFile()).append(", ");
        }
        WLogger.info("Compiling compilation units: " + sb);
        return merged;
    }

    public static void addDependenciesFromFolder(File projectFolder, Collection<File> dependencies) {
        File dependencyFolder = new File(new File(projectFolder, "_build"), "dependencies");
        File[] depProjects = dependencyFolder.listFiles();
        if (depProjects != null) {
            for (File depFile : depProjects) {
                if (!depFile.isDirectory() || !dependencies.stream().noneMatch(f -> FileUtils.sameFile(f, depFile))) continue;
                dependencies.add(depFile);
            }
        }
    }

    private void addImportedLibs(List<CompilationUnit> compilationUnits) {
        this.addImportedLibs(compilationUnits, file -> {
            CompilationUnit lib = this.parseFile((File)file);
            lib.getCuInfo().setFile(file.getAbsolutePath());
            compilationUnits.add(lib);
            return lib;
        });
    }

    public void addImportedLibs(List<CompilationUnit> compilationUnits, Function<File, CompilationUnit> addCompilationUnit) {
        LinkedHashSet packages = Sets.newLinkedHashSet();
        LinkedHashSet<WImport> imports = new LinkedHashSet<WImport>();
        for (CompilationUnit c : compilationUnits) {
            c.getCuInfo().setCuErrorHandler(this.errorHandler);
            for (WPackage p : c.getPackages()) {
                packages.add(p.getName());
                imports.addAll(p.getImports());
            }
        }
        for (WImport imp : imports) {
            this.resolveImport(addCompilationUnit, packages, imp);
        }
    }

    private void resolveImport(Function<File, CompilationUnit> addCompilationUnit, Set<String> packages, WImport imp) throws CompileError {
        if (!packages.contains(imp.getPackagename())) {
            if (this.getLibs().containsKey(imp.getPackagename())) {
                CompilationUnit lib = this.loadLibPackage(addCompilationUnit, imp.getPackagename());
                boolean foundPackage = false;
                for (WPackage p : lib.getPackages()) {
                    packages.add(p.getName());
                    if (p.getName().equals(imp.getPackagename())) {
                        foundPackage = true;
                    }
                    for (WImport i : p.getImports()) {
                        this.resolveImport(addCompilationUnit, packages, i);
                    }
                }
                if (!foundPackage) {
                    imp.addError("The import " + imp.getPackagename() + " could not be found in file " + lib.getCuInfo().getFile());
                }
            } else {
                if (imp.getPackagename().equals("Wurst")) {
                    imp.addError("The standard library could not be imported.");
                }
                if (!imp.getPackagename().equals("NoWurst")) {
                    imp.addError("The import '" + imp.getPackagename() + "' could not be resolved.\nAvailable packages: " + Utils.join(this.getLibs().keySet(), ", "));
                }
            }
        }
    }

    private CompilationUnit loadLibPackage(Function<File, CompilationUnit> addCompilationUnit, String imp) {
        File file = this.getLibs().get(imp);
        if (file == null) {
            this.gui.sendError(new CompileError(new WPos("", null, 0, 0), "Could not find lib-package " + imp + ". Are you missing your wurst.dependencies file?"));
            return Ast.CompilationUnit(new CompilationUnitInfo(this.errorHandler), Ast.JassToplevelDeclarations(new JassToplevelDeclaration[0]), Ast.WPackages(new WPackage[0]));
        }
        return addCompilationUnit.apply(file);
    }

    public Map<String, File> getLibs() {
        LinkedHashMap lc = this.libCache;
        if (lc == null) {
            this.libCache = lc = Maps.newLinkedHashMap();
            for (File libDir : this.runArgs.getAdditionalLibDirs()) {
                this.addLibDir(libDir);
            }
            for (File libDir : this.dependencies) {
                this.addLibDir(libDir);
            }
        }
        return lc;
    }

    private void addLibDir(File libDir) throws Error {
        if (!libDir.exists() || !libDir.isDirectory()) {
            throw new Error("Library folder " + libDir + " does not exist.");
        }
        for (File f : libDir.listFiles()) {
            if (f.isDirectory()) {
                this.addLibDir(f);
            }
            if (!Utils.isWurstFile(f)) continue;
            String libName = Utils.getLibName(f);
            this.getLibs().put(libName, f);
        }
    }

    public void checkProg(WurstModel model) {
        this.checkProg(model, model);
    }

    public void checkProg(WurstModel model, Collection<CompilationUnit> toCheck) {
        for (CompilationUnit cu : toCheck) {
            Preconditions.checkNotNull((Object)cu);
            if (model.contains(cu)) continue;
            throw new ModelChangedException();
        }
        this.checker.checkProg(model, toCheck);
    }

    public JassProg transformProgToJass() {
        ImTranslator imTranslator2 = this.getImTranslator();
        ImProg imProg2 = this.getImProg();
        imTranslator2.assertProperties(new AssertProperty[0]);
        this.checkNoCompiletimeExpr(imProg2);
        int stage = 2;
        this.beginPhase(2, "Eliminate generics");
        new EliminateGenerics(imTranslator2, imProg2).transform();
        this.printDebugImProg("./test-output/im " + stage++ + "_genericsEliminated.im");
        this.timeTaker.endPhase();
        this.beginPhase(2, "translate classes");
        new EliminateClasses(imTranslator2, imProg2, !this.runArgs.isUncheckedDispatch()).eliminateClasses();
        imTranslator2.assertProperties(new AssertProperty[0]);
        this.printDebugImProg("./test-output/im " + stage++ + "_classesEliminated.im");
        this.timeTaker.endPhase();
        new VarargEliminator(imProg2).run();
        this.printDebugImProg("./test-output/im " + stage++ + "_varargEliminated.im");
        imTranslator2.assertProperties(new AssertProperty[0]);
        this.timeTaker.endPhase();
        if (this.runArgs.isNoDebugMessages()) {
            this.beginPhase(3, "remove debug messages");
            DebugMessageRemover.removeDebugMessages(imProg2);
            this.timeTaker.endPhase();
        } else if (this.runArgs.isIncludeStacktraces()) {
            this.beginPhase(4, "add stack traces");
            new StackTraceInjector2(imProg2, imTranslator2).transform(this.timeTaker);
            this.timeTaker.endPhase();
        }
        imTranslator2.assertProperties(new AssertProperty[0]);
        ImOptimizer optimizer = new ImOptimizer(this.timeTaker, imTranslator2);
        if (this.runArgs.isInline()) {
            this.beginPhase(5, "inlining");
            optimizer.doInlining();
            imTranslator2.assertProperties(new AssertProperty[0]);
            this.printDebugImProg("./test-output/im " + stage++ + "_afterinline.im");
            this.timeTaker.endPhase();
        }
        this.beginPhase(6, "eliminate tuples");
        this.timeTaker.measure("flatten", () -> this.getImProg().flatten(imTranslator2));
        this.timeTaker.measure("kill tuples", () -> EliminateTuples.eliminateTuplesProg(this.getImProg(), imTranslator2));
        this.getImTranslator().assertProperties(AssertProperty.NOTUPLES);
        this.printDebugImProg("./test-output/im " + stage++ + "_withouttuples.im");
        this.timeTaker.endPhase();
        this.beginPhase(7, "eliminate multi arrays");
        new MultiArrayEliminator(imProg2, imTranslator2, this.runArgs.isIncludeStacktraces() && !this.runArgs.isNoDebugMessages()).run();
        this.printDebugImProg("./test-output/im " + stage++ + "_withoutmultiarrays.im");
        imTranslator2.assertProperties(new AssertProperty[0]);
        this.timeTaker.endPhase();
        this.beginPhase(8, "remove func refs");
        new FuncRefRemover(imProg2, imTranslator2).run();
        this.timeTaker.endPhase();
        this.beginPhase(9, "remove cyclic functions");
        new CyclicFunctionRemover(imTranslator2, imProg2, this.timeTaker).work();
        this.printDebugImProg("./test-output/im " + stage++ + "_nocyc.im");
        this.timeTaker.endPhase();
        this.beginPhase(10, "flatten");
        this.getImProg().flatten(imTranslator2);
        this.getImTranslator().assertProperties(AssertProperty.NOTUPLES, AssertProperty.FLAT);
        this.printDebugImProg("./test-output/im " + stage++ + "_flat.im");
        this.timeTaker.endPhase();
        if (this.runArgs.isLocalOptimizations()) {
            this.beginPhase(11, "local optimizations");
            optimizer.localOptimizations();
            this.timeTaker.endPhase();
        }
        this.printDebugImProg("./test-output/im " + stage++ + "_afterlocalopts.im");
        if (this.runArgs.isNullsetting()) {
            this.beginPhase(12, "null setting");
            optimizer.doNullsetting();
            this.printDebugImProg("./test-output/im " + stage++ + "_afternullsetting.im");
            this.timeTaker.endPhase();
        }
        this.beginPhase(13, "flatten");
        optimizer.removeGarbage();
        this.imProg.flatten(this.imTranslator);
        optimizer.removeGarbage();
        this.imProg.flatten(this.imTranslator);
        this.printDebugImProg("./test-output/im " + stage++ + "_afterremoveGarbage1.im");
        this.timeTaker.endPhase();
        if (this.runArgs.isHotStartmap() || this.runArgs.isHotReload()) {
            this.addJassHotCodeReloadCode();
        }
        if (this.runArgs.isOptimize()) {
            this.beginPhase(13, "froptimize");
            optimizer.optimize();
            optimizer.removeGarbage();
            this.imProg.flatten(this.imTranslator);
            this.printDebugImProg("./test-output/im " + stage++ + "_afteroptimize.im");
        }
        this.beginPhase(14, "translate to jass");
        this.getImTranslator().calculateCallRelationsAndUsedVariables();
        ImToJassTranslator translator = new ImToJassTranslator(this.getImProg(), this.getImTranslator().getCalledFunctions(), this.getImTranslator().getMainFunc(), this.getImTranslator().getConfFunc());
        this.prog = translator.translate();
        if (this.errorHandler.getErrorCount() > 0) {
            this.prog = null;
        }
        this.timeTaker.endPhase();
        return this.prog;
    }

    private void addJassHotCodeReloadCode() {
        Preconditions.checkNotNull((Object)this.imTranslator);
        Preconditions.checkNotNull((Object)this.imProg);
        ImFunction mainFunc = this.imTranslator.getMainFunc();
        Preconditions.checkNotNull((Object)mainFunc);
        Element trace = this.imProg.getTrace();
        ArrayList<ImStmt> stmts = new ArrayList<ImStmt>();
        stmts.add(this.callExtern(trace, CallType.EXECUTE, "JHCR_Init_init", new ImExpr[0]));
        ImFunction statusFunction = JassIm.ImFunction(trace, "JHCR_API_GetLastStatus", JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(new ImVar[0]), JassIm.ImSimpleType("integer"), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(JassIm.ImReturn(trace, JassIm.ImIntVal(0))), List.of());
        this.imProg.getFunctions().add(statusFunction);
        ImFunctionCall jhcrStatusCall = JassIm.ImFunctionCall(trace, statusFunction, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(new ImExpr[0]), false, CallType.NORMAL);
        ImFunction I2S = this.findNative("I2S", trace.attrErrorPos());
        ImFunctionCall statusCall = JassIm.ImFunctionCall(trace, I2S, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(jhcrStatusCall), false, CallType.NORMAL);
        ImStmts reloadBody = JassIm.ImStmts(this.callExtern(trace, CallType.EXECUTE, "JHCR_Init_parse", new ImExpr[0]), this.callExtern(trace, CallType.NORMAL, "BJDebugMsg", JassIm.ImOperatorCall(WurstOperator.PLUS, JassIm.ImExprs(JassIm.ImStringVal("Code reloaded, status: "), statusCall))));
        ImFunction jhcr_reload = JassIm.ImFunction(trace, "jhcr_reload_on_escape", JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(new ImVar[0]), JassIm.ImVoid(), JassIm.ImVars(new ImVar[0]), reloadBody, Collections.emptyList());
        ImVar trig = JassIm.ImVar(trace, TypesHelper.imTrigger(), "trig", false);
        mainFunc.getLocals().add(trig);
        stmts.add(JassIm.ImSet(trace, JassIm.ImVarAccess(trig), this.callExtern(trace, CallType.NORMAL, "CreateTrigger", new ImExpr[0])));
        stmts.add(this.callExtern(trace, CallType.NORMAL, "TriggerRegisterPlayerEventEndCinematic", JassIm.ImVarAccess(trig), this.callExtern(trace, CallType.NORMAL, "Player", JassIm.ImIntVal(0))));
        stmts.add(this.callExtern(trace, CallType.NORMAL, "TriggerAddAction", JassIm.ImVarAccess(trig), JassIm.ImFuncRef(trace, jhcr_reload)));
        mainFunc.getBody().addAll(0, stmts);
    }

    @NotNull
    private ImFunction findNative(String funcName, WPos trace) {
        return this.imProg.getFunctions().stream().filter(ImFunction::isNative).filter(func -> func.getName().equals(funcName)).findFirst().orElseGet(() -> {
            throw new CompileError(trace, "Could not find native " + funcName);
        });
    }

    @NotNull
    private ImFunction findFunction(String funcName, WPos trace) {
        return this.imProg.getFunctions().stream().filter(func -> func.getName().equals(funcName)).findFirst().orElseGet(() -> {
            throw new CompileError(trace, "Could not find native " + funcName);
        });
    }

    @NotNull
    private ImFunctionCall callExtern(Element trace, CallType callType, String functionName, ImExpr ... arguments) {
        ImFunction jhcrinit = JassIm.ImFunction(trace, functionName, JassIm.ImTypeVars(new ImTypeVar[0]), JassIm.ImVars(new ImVar[0]), JassIm.ImVoid(), JassIm.ImVars(new ImVar[0]), JassIm.ImStmts(new ImStmt[0]), Collections.singletonList(FunctionFlagEnum.IS_EXTERN));
        return JassIm.ImFunctionCall(trace, jhcrinit, JassIm.ImTypeArguments(new ImTypeArgument[0]), JassIm.ImExprs(arguments), true, callType);
    }

    public void checkNoCompiletimeExpr(ImProg prog) {
        prog.accept(new Element.DefaultVisitor(){

            @Override
            public void visit(ImCompiletimeExpr e) {
                super.visit(e);
                throw new CompileError(e.attrTrace().attrSource(), "Compiletime expressions require compilation with '-runcompiletimefunctions' option.");
            }
        });
    }

    public ImTranslator getImTranslator() {
        ImTranslator t = this.imTranslator;
        if (t != null) {
            return t;
        }
        throw new Error("translator not initialized");
    }

    public @Nullable ImProg translateProgToIm(WurstModel root) {
        this.beginPhase(1, "to intermediate lang");
        this.imTranslator = new ImTranslator(root, this.errorHandler.isUnitTestMode(), this.runArgs);
        this.imProg = this.getImTranslator().translateProg();
        int stage = 1;
        this.printDebugImProg("./test-output/im " + stage++ + ".im");
        this.timeTaker.endPhase();
        return this.imProg;
    }

    private void beginPhase(int phase, String description) {
        this.errorHandler.setProgress("Translating wurst. Phase " + phase + ": " + description, 0.6 + 0.01 * (double)phase);
        this.timeTaker.beginPhase(description);
    }

    private void printDebugImProg(String debugFile) {
        if (!this.errorHandler.isUnitTestMode()) {
            return;
        }
        try {
            File file = new File(debugFile);
            file.getParentFile().mkdirs();
            try (BufferedWriter w = Files.newWriter((File)file, (Charset)Charsets.UTF_8);){
                this.getImProg().print(w, 0);
            }
        }
        catch (IOException e) {
            ErrorReporting.instance.handleSevere(e, this.getCompleteSourcecode());
        }
    }

    private WurstModel mergeCompilationUnits(List<CompilationUnit> compilationUnits) {
        this.gui.sendProgress("Merging Files");
        WurstModel result = Ast.WurstModel(new CompilationUnit[0]);
        for (CompilationUnit compilationUnit : compilationUnits) {
            compilationUnit.setParent(null);
            result.add(compilationUnit);
        }
        return result;
    }

    private CompilationUnit processMap(File file) {
        this.gui.sendProgress("Processing Map " + file.getName());
        if (!this.mapFile.isPresent() || !file.equals(this.mapFile.get())) {
            throw new Error("file: " + file + " is not the mapfile: " + this.mapFile);
        }
        MpqEditor mapMpq = this.mapFileMpq;
        if (mapMpq == null) {
            throw new RuntimeException("map mpq is null");
        }
        if (this.runArgs.isNoExtractMapScript()) {
            return null;
        }
        try {
            byte[] tempBytes = mapMpq.extractFile("war3map.j");
            File tempFile = File.createTempFile("war3map", ".j", TempDir.get());
            tempFile.deleteOnExit();
            Files.write((byte[])tempBytes, (File)tempFile);
            if (this.isWurstGenerated(tempFile)) {
                throw new AbortCompilationException("Map was not saved correctly. Please try saving the map again.\n\nThis usually happens if you change the name of the map or \nif you have used the test-map-button without saving the map first.");
            }
            File wurstFolder = new File(file.getParentFile(), "wurst");
            wurstFolder.mkdirs();
            if (!wurstFolder.isDirectory()) {
                throw new AbortCompilationException("Could not create Wurst folder at " + wurstFolder + ".");
            }
            File wurstwar3map = new File(wurstFolder, "war3map.j");
            wurstwar3map.delete();
            if (tempFile.renameTo(wurstwar3map)) {
                return this.parseFile(wurstwar3map);
            }
            throw new Error("Could not move war3map.j from " + tempFile + " to " + wurstwar3map);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isWurstGenerated(File tempFile) {
        try (FileReader fr = new FileReader(tempFile);){
            boolean bl;
            try (BufferedReader in = new BufferedReader(fr);){
                String firstLine = in.readLine();
                WLogger.info("firstLine = '" + firstLine + "'");
                bl = firstLine.equals("// this script was compiled with wurst 1.8.1.0-jenkins-Wurst-1367");
            }
            return bl;
        }
        catch (IOException e) {
            WLogger.severe(e);
            return false;
        }
    }

    private CompilationUnit parseFile(File file) {
        if (this.errorHandler.isUnitTestMode()) {
            CompilationUnit res;
            WeakReference<CompilationUnit> wr = fileCompilationUnitCache.get(file);
            CompilationUnit compilationUnit = res = wr == null ? null : (CompilationUnit)wr.get();
            if (res == null) {
                res = this.parseFile2(file);
                fileCompilationUnitCache.put(file, new WeakReference<CompilationUnit>(res));
            } else {
                res = res.copy();
            }
            return res;
        }
        return this.parseFile2(file);
    }

    private CompilationUnit parseFile2(File file) {
        CompilationUnit compilationUnit;
        block11: {
            if (file.isDirectory()) {
                throw new Error("Is a directory: " + file);
            }
            this.parsedFiles.add(file);
            this.gui.sendProgress("Parsing File " + file.getName());
            String source = file.getAbsolutePath();
            Reader reader = FileReading.getFileReader(file);
            try {
                compilationUnit = this.parse(source, reader);
                if (reader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CompileError e) {
                    this.gui.sendError(e);
                    return this.emptyCompilationUnit();
                }
                catch (FileNotFoundException e) {
                    this.gui.sendError(new CompileError(new WPos(source, LineOffsets.dummy, 0, 0), "File not found."));
                    return this.emptyCompilationUnit();
                }
                catch (IOException e) {
                    this.gui.sendError(new CompileError(new WPos(source, LineOffsets.dummy, 0, 0), "Could not read file."));
                    return this.emptyCompilationUnit();
                }
            }
            reader.close();
        }
        return compilationUnit;
    }

    public CompilationUnit parse(String fileName, Reader reader) {
        if (fileName.endsWith(".j")) {
            return this.parser.parseJass(reader, fileName, this.hasCommonJ);
        }
        if (fileName.endsWith(".jurst")) {
            return this.parser.parseJurst(reader, fileName, this.hasCommonJ);
        }
        if (this.runArgs.isPrettyPrint()) {
            this.parser.setRemoveSugar(false);
        }
        return this.parser.parse(reader, fileName, this.hasCommonJ);
    }

    private CompilationUnit emptyCompilationUnit() {
        return this.parser.emptyCompilationUnit();
    }

    public @Nullable JassProg getProg() {
        return this.prog;
    }

    public void loadReader(String name, Reader input) {
        this.otherInputs.put(name, input);
    }

    public void setHasCommonJ(boolean hasCommonJ) {
        this.hasCommonJ = hasCommonJ;
    }

    public ImProg getImProg() {
        ImProg imProg2 = this.imProg;
        if (imProg2 != null) {
            return imProg2;
        }
        throw new Error("imProg is null");
    }

    public Optional<File> getMapFile() {
        return this.mapFile;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public String getCompleteSourcecode() {
        StringBuilder sb = new StringBuilder();
        try {
            for (File file : this.parsedFiles) {
                sb.append(" //######################################################\n");
                sb.append(" // File ").append(file.getAbsolutePath()).append("\n");
                sb.append(" //######################################################\n");
                sb.append(Files.toString((File)file, (Charset)Charsets.UTF_8));
            }
            for (Map.Entry entry : this.otherInputs.entrySet()) {
                sb.append(" //######################################################\n");
                sb.append(" // Input ").append((String)entry.getKey()).append("\n");
                sb.append(" //######################################################\n");
                Reader reader = (Reader)entry.getValue();
                try {
                    int len;
                    char[] buffer = new char[1024];
                    while ((len = reader.read(buffer)) >= 0) {
                        sb.append(buffer, 0, len);
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
        }
        catch (Throwable t) {
            sb.append(Utils.printExceptionWithStackTrace(t));
            WLogger.severe(t);
        }
        return sb.toString();
    }

    public void setRunArgs(RunArgs runArgs) {
        this.runArgs = runArgs;
    }

    public void setMapFile(Optional<File> mapFile) {
        this.mapFile = mapFile;
    }

    public @Nullable MpqEditor getMapfileMpqEditor() {
        return this.mapFileMpq;
    }

    public LuaCompilationUnit transformProgToLua() {
        ImAttrType.setWurstClassType(null);
        if (this.runArgs.isNoDebugMessages()) {
            this.beginPhase(3, "remove debug messages");
            DebugMessageRemover.removeDebugMessages(this.imProg);
            this.timeTaker.endPhase();
        } else if (this.runArgs.isIncludeStacktraces()) {
            this.beginPhase(4, "add stack traces");
            new StackTraceInjector2(this.imProg, this.imTranslator).transform(this.timeTaker);
            this.timeTaker.endPhase();
        }
        ImTranslator imTranslator2 = this.getImTranslator();
        ImOptimizer optimizer = new ImOptimizer(this.timeTaker, imTranslator2);
        int stage = 5;
        if (this.runArgs.isInline()) {
            this.beginPhase(5, "inlining");
            optimizer.doInlining();
            imTranslator2.assertProperties(new AssertProperty[0]);
            this.printDebugImProg("./test-output/lua/im " + stage++ + "_afterinline.im");
            this.timeTaker.endPhase();
        }
        this.beginPhase(6, "eliminate local type");
        this.getImProg().flatten(imTranslator2);
        EliminateLocalTypes.eliminateLocalTypesProg(this.getImProg(), imTranslator2);
        optimizer.removeGarbage();
        this.imProg.flatten(this.imTranslator);
        this.timeTaker.endPhase();
        stage = 10;
        if (this.runArgs.isLocalOptimizations()) {
            this.beginPhase(10, "local optimizations");
            optimizer.localOptimizations();
            this.timeTaker.endPhase();
        }
        this.printDebugImProg("./test-output/lua/im " + stage++ + "_afterlocalopts.im");
        optimizer.removeGarbage();
        this.imProg.flatten(this.imTranslator);
        optimizer.removeGarbage();
        this.imProg.flatten(this.imTranslator);
        this.printDebugImProg("./test-output/lua/im " + stage++ + "_afterremoveGarbage1.im");
        stage = 12;
        if (this.runArgs.isOptimize()) {
            this.beginPhase(12, "froptimize");
            optimizer.optimize();
            optimizer.removeGarbage();
            this.imProg.flatten(this.imTranslator);
            this.printDebugImProg("./test-output/lua/im " + stage++ + "_afteroptimize.im");
            this.timeTaker.endPhase();
        }
        this.beginPhase(13, "translate to lua");
        LuaTranslator luaTranslator = new LuaTranslator(this.imProg, this.imTranslator);
        LuaCompilationUnit luaCode = luaTranslator.translate();
        ImAttrType.setWurstClassType(TypesHelper.imInt());
        this.timeTaker.endPhase();
        return luaCode;
    }
}

