/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtojass;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.jassAst.JassAst;
import de.peeeq.wurstscript.jassAst.JassExpr;
import de.peeeq.wurstscript.jassAst.JassFunction;
import de.peeeq.wurstscript.jassAst.JassFunctionOrNative;
import de.peeeq.wurstscript.jassAst.JassFunctions;
import de.peeeq.wurstscript.jassAst.JassInitializedVar;
import de.peeeq.wurstscript.jassAst.JassNative;
import de.peeeq.wurstscript.jassAst.JassProg;
import de.peeeq.wurstscript.jassAst.JassSimpleVar;
import de.peeeq.wurstscript.jassAst.JassStatement;
import de.peeeq.wurstscript.jassAst.JassTypeDef;
import de.peeeq.wurstscript.jassAst.JassVar;
import de.peeeq.wurstscript.jassAst.JassVars;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ElementWithTrace;
import de.peeeq.wurstscript.jassIm.ImArrayType;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImSimpleType;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.JassImElementWithName;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.translation.imoptimizer.RestrictedCompressedNames;
import de.peeeq.wurstscript.translation.imtranslation.FunctionFlagEnum;
import de.peeeq.wurstscript.translation.imtranslation.ImHelper;
import de.peeeq.wurstscript.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;

public class ImToJassTranslator {
    private final ImProg imProg;
    private final Multimap<ImFunction, ImFunction> calledFunctions;
    private final ImFunction mainFunc;
    private final ImFunction confFunction;
    private @Nullable JassProg prog;
    private final Stack<ImFunction> translatingFunctions = new Stack();
    private final Set<ImFunction> translatedFunctions = Sets.newLinkedHashSet();
    private final Set<String> usedNames = Sets.newLinkedHashSet();
    private final Multimap<ImFunction, String> usedLocalNames = HashMultimap.create();
    private final Map<ImVar, JassVar> jassVars = Maps.newLinkedHashMap();
    private final Set<ImVar> globalImVars = Sets.newLinkedHashSet();
    private final Pattern jassValidName = Pattern.compile("[a-zA-Z][a-zA-Z0-9_]*");
    private final Map<ImFunction, JassFunctionOrNative> jassFuncs = Maps.newLinkedHashMap();

    public ImToJassTranslator(ImProg imProg, Multimap<ImFunction, ImFunction> calledFunctions, ImFunction mainFunc, ImFunction confFunction) {
        this.imProg = imProg;
        this.calledFunctions = calledFunctions;
        this.mainFunc = mainFunc;
        this.confFunction = confFunction;
    }

    public JassProg translate() {
        this.makeNamesUnique(this.imProg.getGlobals());
        this.makeNamesUnique(this.imProg.getFunctions());
        JassVars globals = JassAst.JassVars(new JassVar[0]);
        JassFunctions functions = JassAst.JassFunctions(new JassFunction[0]);
        this.prog = JassAst.JassProg(JassAst.JassTypeDefs(new JassTypeDef[0]), globals, JassAst.JassNatives(new JassNative[0]), functions);
        this.collectGlobalVars();
        this.translateFunctionTransitive(this.mainFunc);
        this.translateFunctionTransitive(this.confFunction);
        return this.prog;
    }

    private <T extends JassImElementWithName> void makeNamesUnique(List<T> list) {
        List sorted = list.stream().sorted(Comparator.comparing(JassImElementWithName::getName).thenComparing(v -> v.getTrace().attrSource().getFile()).thenComparing(v -> v.getTrace().attrSource().getLine()).thenComparing(v -> v.getTrace().attrSource().getStartColumn())).collect(Collectors.toList());
        for (int i = 0; i < sorted.size(); ++i) {
            JassImElementWithName vi = (JassImElementWithName)sorted.get(i);
            for (int j = i + 1; j < sorted.size(); ++j) {
                JassImElementWithName vj = (JassImElementWithName)sorted.get(j);
                if (!vi.getName().equals(vj.getName())) continue;
                vj.setName(vi.getName() + "_" + j);
            }
        }
    }

    private void collectGlobalVars() {
        for (ImVar v : this.imProg.getGlobals()) {
            this.globalImVars.add(v);
            this.getJassVarFor(v);
        }
    }

    private void translateFunctionTransitive(ImFunction imFunc) {
        if (this.translatedFunctions.contains(imFunc)) {
            return;
        }
        if (this.translatingFunctions.contains(imFunc)) {
            if (imFunc != this.translatingFunctions.peek()) {
                StringBuilder msg = new StringBuilder("cyclic dependency between functions: ");
                boolean start = false;
                for (ImFunction f : this.translatingFunctions) {
                    if (imFunc == f) {
                        start = true;
                    }
                    if (!start) continue;
                    msg.append("\n - ").append(Utils.printElement(ImToJassTranslator.getTrace(f))).append("  ( ").append(f.attrTrace().attrSource().getFile()).append(" line  ").append(f.attrTrace().attrSource().getLine()).append(")");
                }
                WPos src = ImToJassTranslator.getTrace(imFunc).attrSource();
                throw new CompileError(src, msg.toString());
            }
            return;
        }
        this.translatingFunctions.push(imFunc);
        for (ImFunction f : this.sorted(this.calledFunctions.get((Object)imFunc))) {
            this.translateFunctionTransitive(f);
        }
        this.translateFunction(imFunc);
        if (this.translatingFunctions.pop() != imFunc) {
            throw new Error("something went wrong...");
        }
        this.translatedFunctions.add(imFunc);
    }

    private List<ImFunction> sorted(Collection<ImFunction> collection) {
        ArrayList r = Lists.newArrayList(collection);
        r.sort(Comparator.comparing(ImFunction::getName));
        return r;
    }

    private static de.peeeq.wurstscript.ast.Element getTrace(@Nullable Element elem) {
        while (elem != null) {
            ElementWithTrace ElementWithTrace2;
            de.peeeq.wurstscript.ast.Element t;
            if (elem instanceof ElementWithTrace && (t = (ElementWithTrace2 = (ElementWithTrace)elem).getTrace()) != null) {
                return t;
            }
            elem = elem.getParent();
        }
        throw new Error("Could not get trace to original program.");
    }

    private void translateFunction(ImFunction imFunc) {
        if (imFunc.isBj() || imFunc.hasFlag(FunctionFlagEnum.IS_VARARG)) {
            return;
        }
        JassFunctionOrNative f = this.getJassFuncFor(imFunc);
        f.setReturnType(imFunc.getReturnType().translateType());
        for (ImVar v : imFunc.getParameters()) {
            f.getParams().add((JassSimpleVar)this.getJassVarFor(v));
        }
        if (f instanceof JassFunction) {
            JassFunction jf = (JassFunction)f;
            for (ImVar v : imFunc.getLocals()) {
                jf.getLocals().add(this.getJassVarFor(v));
            }
            imFunc.getBody().translate(jf.getBody(), jf, this);
        }
    }

    private String getUniqueGlobalName(String name) {
        name = this.jassifyName(name);
        name = Utils.makeUniqueName(name, n -> !this.usedNames.contains(n));
        this.usedNames.add(name);
        return name;
    }

    private String getUniqueLocalName(ImFunction imFunction, String name) {
        name = this.jassifyName(name);
        name = Utils.makeUniqueName(name, n -> !this.usedNames.contains(n) && !this.usedLocalNames.containsEntry((Object)imFunction, n));
        this.usedLocalNames.put((Object)imFunction, (Object)name);
        return name;
    }

    JassVar getJassVarFor(ImVar v) {
        JassVar result = this.jassVars.get(v);
        if (result == null) {
            boolean isArray = v.getType() instanceof ImArrayType;
            String type = v.getType().translateType();
            String name = v.getName();
            name = v.getNearestFunc() != null ? this.getUniqueLocalName(v.getNearestFunc(), name) : this.getUniqueGlobalName(name);
            if (isArray) {
                result = JassAst.JassArrayVar(type, name);
            } else if (this.isGlobal(v) && v.getType() instanceof ImSimpleType) {
                JassExpr initialVal = ImHelper.defaultValueForType((ImSimpleType)v.getType()).translate(this);
                result = JassAst.JassInitializedVar(type, name, initialVal, v.getIsBJ());
            } else {
                result = JassAst.JassSimpleVar(type, name);
            }
            if (this.isGlobal(v) && (!v.getIsBJ() || result instanceof JassInitializedVar)) {
                this.prog.getGlobals().add(result);
            }
            this.jassVars.put(v, result);
        }
        return result;
    }

    private String jassifyName(String name) {
        if (RestrictedCompressedNames.contains((String)(name = this.filterInvalidSymbols((String)name))) || ((String)name).startsWith("_")) {
            name = "w" + (String)name;
        }
        if (((String)name).endsWith("_")) {
            name = (String)name + "u";
        }
        if (((String)name).isEmpty()) {
            name = "empty";
        }
        return name;
    }

    private String filterInvalidSymbols(String name) {
        if (this.jassValidName.matcher(name).matches()) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            int c = name.charAt(i);
            if (!(c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95)) {
                c = 95;
            }
            sb.append((char)c);
        }
        return sb.toString();
    }

    private boolean isGlobal(ImVar v) {
        return this.globalImVars.contains(v);
    }

    public JassFunctionOrNative getJassFuncFor(ImFunction func) {
        JassFunctionOrNative f = this.jassFuncs.get(func);
        if (f == null) {
            if (func.isNative()) {
                f = JassAst.JassNative(func.getName(), JassAst.JassSimpleVars(new JassSimpleVar[0]), "nothing");
                if (!func.isBj() && !func.isExtern()) {
                    this.prog.getNatives().add((JassNative)f);
                }
            } else {
                String name = func.getName();
                if (!(name.equals("main") || name.equals("config") || func.hasFlag(FunctionFlagEnum.IS_EXTERN))) {
                    name = this.getUniqueGlobalName(func.getName());
                }
                boolean isCompiletimeNative = func.hasFlag(FunctionFlagEnum.IS_COMPILETIME_NATIVE);
                f = JassAst.JassFunction(name, JassAst.JassSimpleVars(new JassSimpleVar[0]), "nothing", JassAst.JassVars(new JassVar[0]), JassAst.JassStatements(new JassStatement[0]), isCompiletimeNative);
                if (!func.isBj() && !func.isExtern()) {
                    this.prog.getFunctions().add((JassFunction)f);
                }
            }
            this.jassFuncs.put(func, f);
        }
        return f;
    }
}

