/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstio;

import com.google.common.base.Charsets;
import config.WurstProjectConfig;
import config.WurstProjectConfigData;
import de.peeeq.wurstio.AbortCompilationException;
import de.peeeq.wurstio.CompilationProcess;
import de.peeeq.wurstio.ErrorReportingIO;
import de.peeeq.wurstio.compilationserver.WurstServer;
import de.peeeq.wurstio.gui.AboutDialog;
import de.peeeq.wurstio.gui.WurstGuiImpl;
import de.peeeq.wurstio.hotdoc.HotdocGenerator;
import de.peeeq.wurstio.languageserver.LanguageServerStarter;
import de.peeeq.wurstio.languageserver.ProjectConfigBuilder;
import de.peeeq.wurstio.languageserver.WFile;
import de.peeeq.wurstio.languageserver.WurstCommands;
import de.peeeq.wurstio.map.importer.ImportFile;
import de.peeeq.wurstio.mpq.MpqEditor;
import de.peeeq.wurstio.mpq.MpqEditorFactory;
import de.peeeq.wurstio.utils.W3InstallationData;
import de.peeeq.wurstscript.ErrorReporting;
import de.peeeq.wurstscript.RunArgs;
import de.peeeq.wurstscript.WLogger;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.attributes.prettyPrint.PrettyUtils;
import de.peeeq.wurstscript.gui.WurstGui;
import de.peeeq.wurstscript.gui.WurstGuiCliImpl;
import de.peeeq.wurstscript.utils.Utils;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.swing.JOptionPane;

public class Main {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length == 0) {
            new RunArgs("-help");
            return;
        }
        WurstGui gui = null;
        RunArgs runArgs = new RunArgs(args);
        try {
            if (runArgs.isLanguageServer()) {
                WLogger.setLogger("languageServer");
            }
            Main.logStartup(args);
            if (runArgs.showHelp()) {
                return;
            }
            if (runArgs.isShowVersion()) {
                System.out.println("1.8.1.0-jenkins-Wurst-1367");
                return;
            }
            if (runArgs.showAbout()) {
                new AboutDialog(null, false).setVisible(true);
                return;
            }
            if (runArgs.isStartServer()) {
                WurstServer.startServer();
                return;
            }
            if (runArgs.isLanguageServer()) {
                LanguageServerStarter.start();
                return;
            }
            if (runArgs.isPrettyPrint()) {
                PrettyUtils.pretty(runArgs.getFiles());
                return;
            }
            WLogger.info("runArgs.isExtractImports() = " + runArgs.isExtractImports());
            if (runArgs.isExtractImports()) {
                File mapFile = new File(runArgs.getMapFile());
                ImportFile.extractImportsFromMap(mapFile, runArgs);
                return;
            }
            if (runArgs.createHotDoc()) {
                HotdocGenerator hg = new HotdocGenerator(runArgs.getFiles());
                hg.generateDoc();
                return;
            }
            if (runArgs.isGui()) {
                gui = new WurstGuiImpl();
                ErrorReporting.instance = new ErrorReportingIO();
            } else {
                gui = new WurstGuiCliImpl();
            }
            if (runArgs.showLastErrors()) {
                JOptionPane.showMessageDialog(null, "not implemented");
                return;
            }
            try {
                CharSequence compiledScript;
                WurstProjectConfigData projectConfig = null;
                Path buildDir = null;
                Optional<Object> target = Optional.empty();
                String workspaceroot = runArgs.getWorkspaceroot();
                if (runArgs.isBuild() && runArgs.getInputmap() != null && workspaceroot != null) {
                    Path root = Paths.get(workspaceroot, new String[0]);
                    Path inputMap = root.resolve(runArgs.getInputmap());
                    projectConfig = WurstProjectConfig.INSTANCE.loadProject(root.resolve("wurst.build"));
                    if (Files.exists(inputMap, new LinkOption[0]) && projectConfig != null) {
                        buildDir = root.resolve("_build");
                        Files.createDirectories(buildDir, new FileAttribute[0]);
                        target = Optional.of(buildDir.resolve(projectConfig.getBuildMapData().getFileName() + ".w3x"));
                        Files.copy(inputMap, (Path)target.get(), StandardCopyOption.REPLACE_EXISTING);
                        runArgs.setMapFile(((Path)target.get()).toAbsolutePath().toString());
                    }
                }
                String mapFilePath = runArgs.getMapFile();
                RunArgs compileArgs = runArgs;
                if (workspaceroot != null) {
                    WLogger.info("workspaceroot: " + workspaceroot);
                    LinkedList<String> argList = new LinkedList<String>(Arrays.asList(args));
                    List<String> argsList = WurstCommands.getCompileArgs(WFile.create(workspaceroot), new String[0]);
                    WLogger.info("workspaceroot: " + (argsList == null));
                    argList.addAll(argsList);
                    compileArgs = new RunArgs(argList);
                }
                CompilationProcess compilationProcess = new CompilationProcess(gui, compileArgs);
                if (mapFilePath != null && workspaceroot != null) {
                    try (MpqEditor mpqEditor = MpqEditorFactory.getEditor(Optional.of(new File(mapFilePath)));){
                        File projectFolder = Paths.get(workspaceroot, new String[0]).toFile();
                        compiledScript = compilationProcess.doCompilation(mpqEditor, projectFolder, true);
                        if (compiledScript != null) {
                            gui.sendProgress("Writing to map");
                            mpqEditor.deleteFile("war3map.j");
                            byte[] war3map = compiledScript.toString().getBytes(Charsets.UTF_8);
                            mpqEditor.insertFile("war3map.j", war3map);
                        }
                        ImportFile.importFilesFromImports(projectFolder, mpqEditor);
                    }
                } else {
                    compiledScript = compilationProcess.doCompilation(null, true);
                }
                if (compiledScript != null) {
                    File scriptFile = new File("compiled.j.txt");
                    com.google.common.io.Files.write((byte[])compiledScript.toString().getBytes(Charsets.UTF_8), (File)scriptFile);
                    if (projectConfig != null && target.isPresent()) {
                        ProjectConfigBuilder.apply(projectConfig, ((Path)target.get()).toFile(), scriptFile, buildDir.toFile(), runArgs, new W3InstallationData(null, Paths.get(workspaceroot, new String[0]).toFile(), false));
                        WLogger.info("map build success");
                        System.out.println("Build succeeded. Output file: <" + ((Path)target.get()).toAbsolutePath() + ">");
                    }
                }
                gui.sendProgress("Finished!");
            }
            catch (AbortCompilationException e) {
                gui.showInfoMessage(e.getMessage());
            }
        }
        catch (Throwable t) {
            String source = "";
            ErrorReporting.instance.handleSevere(t, source);
            if (!runArgs.isGui()) {
                System.exit(2);
            }
        }
        finally {
            if (gui != null) {
                gui.sendFinished();
                if (!runArgs.isGui()) {
                    if (gui.getErrorCount() > 0) {
                        for (CompileError err : gui.getErrorList()) {
                            System.out.println(err);
                        }
                        System.exit(1);
                    }
                    for (CompileError err : gui.getWarningList()) {
                        System.out.println(err);
                    }
                }
            }
        }
    }

    private static void logStartup(String[] args) {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = runtimeMxBean.getInputArguments();
        WLogger.info("### Started wurst version: (1.8.1.0-jenkins-Wurst-1367)");
        WLogger.info("### With wurst-args " + Utils.printSep(", ", args));
        if (arguments != null && arguments.size() > 0) {
            WLogger.info("### With vm-args " + Utils.printSep(", ", arguments.toArray(new String[0])));
        }
        try {
            WLogger.info("### compiler path1: " + Main.class.getProtectionDomain().getCodeSource().getLocation());
            WLogger.info("### compiler path2: " + ClassLoader.getSystemClassLoader().getResource(".").getPath());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        WLogger.info("### ============================================");
    }
}

