/*
 * Decompiled with CFR 0.152.
 */
package systems.crigges.jmpq3.security;

final class CryptographicLUT {
    private static final int TABLE_NUMBER = 5;
    private static final int VALUE_NUMBER = 256;
    private static final int[][] CRYPTOGRAPHIC_TABLES = new int[5][256];
    public static final CryptographicLUT HASH_TABLE_OFFSET;
    public static final CryptographicLUT HASH_TABLE_KEY1;
    public static final CryptographicLUT HASH_TABLE_KEY2;
    public static final CryptographicLUT HASH_ENCRYPTION_KEY;
    public static final CryptographicLUT ENCRYPTION;
    private final int[] cryptographicLUT;

    private static int updateSeed(int seed) {
        return (seed * 125 + 3) % 0x2AAAAB;
    }

    private CryptographicLUT(int table) {
        this.cryptographicLUT = CRYPTOGRAPHIC_TABLES[table];
    }

    public int lookup(byte value) {
        return this.cryptographicLUT[Byte.toUnsignedInt(value)];
    }

    static {
        int seed = 0x100001;
        for (int value = 0; value < 256; ++value) {
            for (int table = 0; table < 5; ++table) {
                seed = CryptographicLUT.updateSeed(seed);
                short seed1 = (short)seed;
                seed = CryptographicLUT.updateSeed(seed);
                short seed2 = (short)seed;
                CryptographicLUT.CRYPTOGRAPHIC_TABLES[table][value] = seed1 << 16 | Short.toUnsignedInt(seed2);
            }
        }
        HASH_TABLE_OFFSET = new CryptographicLUT(0);
        HASH_TABLE_KEY1 = new CryptographicLUT(1);
        HASH_TABLE_KEY2 = new CryptographicLUT(2);
        HASH_ENCRYPTION_KEY = new CryptographicLUT(3);
        ENCRYPTION = new CryptographicLUT(4);
    }
}

