/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.dataTypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.dataTypes.DataType;
import net.moonlightflower.wc3libs.dataTypes.DataTypeInfo;
import net.moonlightflower.wc3libs.dataTypes.app.FlagsInt;
import net.moonlightflower.wc3libs.dataTypes.app.War3String;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataList<T extends DataType>
extends DataType
implements List<T> {
    private static final Logger log = LoggerFactory.getLogger((String)FlagsInt.class.getName());
    private final List<T> _list = new ArrayList<T>();
    private DataTypeInfo _elementsTypeInfo;

    @Nonnull
    public static DataTypeInfo getTypeDescriptor() {
        return new DataTypeInfo((Class<? extends DataType>)DataList.class);
    }

    @Nonnull
    public List<T> getVal() {
        return this._list;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this._list.size(); ++i) {
            if (i > 0) {
                s.append(",");
            }
            s.append(this._list.get(i));
        }
        return s.toString();
    }

    public List<T> asList() {
        return this._list;
    }

    public DataTypeInfo getElementsTypeInfo() {
        return this._elementsTypeInfo;
    }

    public String name() {
        return "abc";
    }

    @Override
    @Nonnull
    public DataTypeInfo getTypeInfo() {
        return new DataTypeInfo(this.getClass(), this.getElementsTypeInfo());
    }

    @Override
    public Object toSLKVal() {
        StringBuilder s = new StringBuilder();
        for (DataType el : this.asList()) {
            s.append(",");
            s.append(el.toSLKVal().toString());
        }
        return s.toString();
    }

    @Override
    public Object toTXTVal() {
        StringBuilder s = new StringBuilder();
        for (DataType el : this.asList()) {
            s.append(",");
            s.append(el.toTXTVal().toString());
        }
        return s.toString();
    }

    public DataList(@Nonnull DataTypeInfo elementsTypeInfo) {
        this._elementsTypeInfo = elementsTypeInfo;
    }

    public DataList(@Nonnull Class<? extends DataType> elementsType) {
        this(new DataTypeInfo(elementsType));
    }

    @Override
    public boolean add(T e) {
        return this._list.add(e);
    }

    @Override
    public void add(int index, T element) {
        this._list.add(index, element);
    }

    @Override
    public boolean addAll(@Nonnull Collection c) {
        return this._list.addAll(c);
    }

    @Override
    public boolean addAll(int index, @Nonnull Collection c) {
        return this._list.addAll(index, c);
    }

    @Override
    public void clear() {
        this._list.clear();
    }

    @Override
    public boolean contains(@Nonnull Object o) {
        return this._list.contains(o);
    }

    @Override
    public boolean containsAll(@Nonnull Collection c) {
        return this._list.containsAll(c);
    }

    @Override
    public T get(int index) {
        return (T)((DataType)this._list.get(index));
    }

    @Override
    public int indexOf(@Nonnull Object o) {
        return this._list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this._list.isEmpty();
    }

    @Override
    @Nonnull
    public Iterator iterator() {
        return this._list.iterator();
    }

    @Override
    public int lastIndexOf(@Nonnull Object o) {
        return this._list.lastIndexOf(o);
    }

    @Override
    @Nonnull
    public ListIterator listIterator() {
        return this._list.listIterator();
    }

    @Override
    @Nonnull
    public ListIterator listIterator(int index) {
        return this._list.listIterator(index);
    }

    @Override
    public boolean remove(@Nonnull Object o) {
        return this._list.remove(o);
    }

    @Override
    public T remove(int index) {
        return (T)((DataType)this._list.remove(index));
    }

    @Override
    public boolean removeAll(@Nonnull Collection c) {
        return this._list.removeAll(c);
    }

    @Override
    public boolean retainAll(@Nonnull Collection c) {
        return this._list.retainAll(c);
    }

    @Override
    public T set(int index, T element) {
        return (T)((DataType)this._list.set(index, element));
    }

    @Override
    public int size() {
        return this._list.size();
    }

    @Override
    @Nonnull
    public List subList(int fromIndex, int toIndex) {
        return this._list.subList(fromIndex, toIndex);
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return this._list.toArray();
    }

    @Override
    @Nonnull
    public Object[] toArray(Object[] a) {
        return this._list.toArray(a);
    }

    public DataList<T> decode(Object val, Class<? extends DataType> elementsType) throws DataTypeInfo.CastException {
        DataList<DataType> ret = new DataList<DataType>(elementsType);
        for (String s : val.toString().split(",")) {
            try {
                ret.add(elementsType.newInstance().decode(val));
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return ret;
    }

    @Override
    public DataList<T> decode(Object val) throws DataTypeInfo.CastException {
        return this.decode(val, War3String.class);
    }

    public DataList<T> clone() throws CloneNotSupportedException {
        DataList ts = (DataList)super.clone();
        DataList<DataType> other = new DataList<DataType>(this.getElementsTypeInfo());
        for (Object val : this) {
            if (val instanceof DataList) {
                val = ((DataList)val).clone();
            }
            other.add((DataType)val);
        }
        return other;
    }
}

