/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.BuiltInAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FunctionTypesKt {
    public static final boolean isFunctionType(@NotNull KotlinType $this$isFunctionType) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionType, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$isFunctionType.getConstructor().getDeclarationDescriptor();
        return (classifierDescriptor == null ? null : FunctionTypesKt.getFunctionalClassKind(classifierDescriptor)) == FunctionClassKind.Function;
    }

    public static final boolean isSuspendFunctionType(@NotNull KotlinType $this$isSuspendFunctionType) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendFunctionType, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$isSuspendFunctionType.getConstructor().getDeclarationDescriptor();
        return (classifierDescriptor == null ? null : FunctionTypesKt.getFunctionalClassKind(classifierDescriptor)) == FunctionClassKind.SuspendFunction;
    }

    public static final boolean isBuiltinFunctionalType(@NotNull KotlinType $this$isBuiltinFunctionalType) {
        Intrinsics.checkNotNullParameter((Object)$this$isBuiltinFunctionalType, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = $this$isBuiltinFunctionalType.getConstructor().getDeclarationDescriptor();
        return classifierDescriptor == null ? false : FunctionTypesKt.isBuiltinFunctionalClassDescriptor(classifierDescriptor);
    }

    public static final boolean isBuiltinFunctionalClassDescriptor(@NotNull DeclarationDescriptor $this$isBuiltinFunctionalClassDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$isBuiltinFunctionalClassDescriptor, (String)"<this>");
        FunctionClassKind functionalClassKind = FunctionTypesKt.getFunctionalClassKind($this$isBuiltinFunctionalClassDescriptor);
        return functionalClassKind == FunctionClassKind.Function || functionalClassKind == FunctionClassKind.SuspendFunction;
    }

    public static final boolean isBuiltinExtensionFunctionalType(@NotNull KotlinType $this$isBuiltinExtensionFunctionalType) {
        Intrinsics.checkNotNullParameter((Object)$this$isBuiltinExtensionFunctionalType, (String)"<this>");
        return FunctionTypesKt.isBuiltinFunctionalType($this$isBuiltinExtensionFunctionalType) && FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($this$isBuiltinExtensionFunctionalType);
    }

    private static final boolean isTypeAnnotatedWithExtensionFunctionType(KotlinType $this$isTypeAnnotatedWithExtensionFunctionType) {
        return $this$isTypeAnnotatedWithExtensionFunctionType.getAnnotations().findAnnotation(StandardNames.FqNames.extensionFunctionType) != null;
    }

    @Nullable
    public static final FunctionClassKind getFunctionalClassKind(@NotNull DeclarationDescriptor $this$getFunctionalClassKind) {
        Intrinsics.checkNotNullParameter((Object)$this$getFunctionalClassKind, (String)"<this>");
        if (!($this$getFunctionalClassKind instanceof ClassDescriptor)) {
            return null;
        }
        if (!KotlinBuiltIns.isUnderKotlinPackage($this$getFunctionalClassKind)) {
            return null;
        }
        return FunctionTypesKt.getFunctionalClassKind(DescriptorUtilsKt.getFqNameUnsafe($this$getFunctionalClassKind));
    }

    private static final FunctionClassKind getFunctionalClassKind(FqNameUnsafe $this$getFunctionalClassKind) {
        if (!$this$getFunctionalClassKind.isSafe() || $this$getFunctionalClassKind.isRoot()) {
            return null;
        }
        Object object = $this$getFunctionalClassKind.shortName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"shortName().asString()");
        String string = object;
        object = $this$getFunctionalClassKind.toSafe().parent();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toSafe().parent()");
        return FunctionClassKind.Companion.getFunctionalClassKind(string, (FqName)object);
    }

    @Nullable
    public static final KotlinType getReceiverTypeFromFunctionType(@NotNull KotlinType $this$getReceiverTypeFromFunctionType) {
        Intrinsics.checkNotNullParameter((Object)$this$getReceiverTypeFromFunctionType, (String)"<this>");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType($this$getReceiverTypeFromFunctionType);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = Intrinsics.stringPlus((String)"Not a function type: ", (Object)$this$getReceiverTypeFromFunctionType);
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType($this$getReceiverTypeFromFunctionType) ? ((TypeProjection)CollectionsKt.first($this$getReceiverTypeFromFunctionType.getArguments())).getType() : null;
    }

    @NotNull
    public static final KotlinType getReturnTypeFromFunctionType(@NotNull KotlinType $this$getReturnTypeFromFunctionType) {
        Intrinsics.checkNotNullParameter((Object)$this$getReturnTypeFromFunctionType, (String)"<this>");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType($this$getReturnTypeFromFunctionType);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = Intrinsics.stringPlus((String)"Not a function type: ", (Object)$this$getReturnTypeFromFunctionType);
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KotlinType kotlinType = ((TypeProjection)CollectionsKt.last($this$getReturnTypeFromFunctionType.getArguments())).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"arguments.last().type");
        return kotlinType;
    }

    @NotNull
    public static final List<TypeProjection> getValueParameterTypesFromFunctionType(@NotNull KotlinType $this$getValueParameterTypesFromFunctionType) {
        Intrinsics.checkNotNullParameter((Object)$this$getValueParameterTypesFromFunctionType, (String)"<this>");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType($this$getValueParameterTypesFromFunctionType);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FunctionTypesKt$getValueParameterTypesFromFunctionType$32 = false;
            String $i$a$-assert-FunctionTypesKt$getValueParameterTypesFromFunctionType$32 = Intrinsics.stringPlus((String)"Not a function type: ", (Object)$this$getValueParameterTypesFromFunctionType);
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-FunctionTypesKt$getValueParameterTypesFromFunctionType$32));
        }
        List<TypeProjection> arguments2 = $this$getValueParameterTypesFromFunctionType.getArguments();
        int first = FunctionTypesKt.isBuiltinExtensionFunctionalType($this$getValueParameterTypesFromFunctionType) ? 1 : 0;
        int last = arguments2.size() - 1;
        boolean bl3 = first <= last;
        boolean bl4 = false;
        if (_Assertions.ENABLED && !bl3) {
            boolean bl5 = false;
            String string = Intrinsics.stringPlus((String)"Not an exact function type: ", (Object)$this$getValueParameterTypesFromFunctionType);
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return arguments2.subList(first, last);
    }

    @Nullable
    public static final Name extractParameterNameFromFunctionTypeArgument(@NotNull KotlinType $this$extractParameterNameFromFunctionTypeArgument) {
        Object object;
        Object object2;
        StringValue stringValue;
        Intrinsics.checkNotNullParameter((Object)$this$extractParameterNameFromFunctionTypeArgument, (String)"<this>");
        AnnotationDescriptor annotationDescriptor = $this$extractParameterNameFromFunctionTypeArgument.getAnnotations().findAnnotation(StandardNames.FqNames.parameterName);
        if (annotationDescriptor == null) {
            return null;
        }
        AnnotationDescriptor annotation = annotationDescriptor;
        Object object3 = CollectionsKt.singleOrNull((Iterable)annotation.getAllValueArguments().values());
        StringValue stringValue2 = stringValue = object3 instanceof StringValue ? (StringValue)object3 : null;
        if (stringValue == null) {
            object2 = null;
        } else {
            object3 = (String)stringValue.getValue();
            if (object3 == null) {
                object2 = null;
            } else {
                Object object4 = object3;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object4;
                boolean bl3 = false;
                object2 = object = Name.isValidIdentifier((String)it) ? object4 : null;
            }
        }
        if (object == null) {
            return null;
        }
        Object name = object;
        return Name.identifier(name);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<TypeProjection> getFunctionTypeArgumentProjections(@Nullable KotlinType receiverType, @NotNull List<? extends KotlinType> parameterTypes, @Nullable List<Name> parameterNames, @NotNull KotlinType returnType, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkNotNullParameter(parameterTypes, (String)"parameterTypes");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        ArrayList<TypeProjection> arguments2 = new ArrayList<TypeProjection>(parameterTypes.size() + (receiverType != null ? 1 : 0) + 1);
        KotlinType kotlinType = receiverType;
        kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.addIfNotNull((Collection)arguments2, kotlinType == null ? null : TypeUtilsKt.asTypeProjection(kotlinType));
        Iterable $this$mapIndexedTo$iv = parameterTypes;
        boolean $i$f$mapIndexedTo = false;
        int index$iv = 0;
        for (Object item$iv : $this$mapIndexedTo$iv) {
            KotlinType kotlinType2;
            void type2;
            Name name;
            Object object;
            Object object2;
            Collection collection = arguments2;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KotlinType kotlinType3 = (KotlinType)item$iv;
            int n2 = n;
            Collection collection2 = collection;
            boolean bl2 = false;
            List<Name> list = parameterNames;
            if (list == null) {
                object2 = null;
            } else {
                void index;
                Name name2 = list.get((int)index);
                if (name2 == null) {
                    object2 = null;
                } else {
                    object = name2;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Name it = object;
                    boolean bl5 = false;
                    object2 = name = !it.isSpecial() ? object : null;
                }
            }
            if (name != null) {
                Name name3 = Name.identifier("name");
                object = name.asString();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"name.asString()");
                BuiltInAnnotationDescriptor parameterNameAnnotation = new BuiltInAnnotationDescriptor(builtIns, StandardNames.FqNames.parameterName, MapsKt.mapOf((Pair)TuplesKt.to((Object)name3, (Object)new StringValue((String)object))));
                kotlinType2 = TypeUtilsKt.replaceAnnotations((KotlinType)type2, Annotations.Companion.create(CollectionsKt.plus((Iterable)type2.getAnnotations(), (Object)parameterNameAnnotation)));
            } else {
                kotlinType2 = type2;
            }
            void typeToUse = kotlinType2;
            TypeProjection typeProjection = TypeUtilsKt.asTypeProjection((KotlinType)typeToUse);
            collection2.add(typeProjection);
        }
        arguments2.add(TypeUtilsKt.asTypeProjection(returnType));
        return arguments2;
    }

    @JvmOverloads
    @NotNull
    public static final SimpleType createFunctionType(@NotNull KotlinBuiltIns builtIns, @NotNull Annotations annotations2, @Nullable KotlinType receiverType, @NotNull List<? extends KotlinType> parameterTypes, @Nullable List<Name> parameterNames, @NotNull KotlinType returnType, boolean suspendFunction) {
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)annotations2, (String)"annotations");
        Intrinsics.checkNotNullParameter(parameterTypes, (String)"parameterTypes");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        List<TypeProjection> arguments2 = FunctionTypesKt.getFunctionTypeArgumentProjections(receiverType, parameterTypes, parameterNames, returnType, builtIns);
        int parameterCount = receiverType == null ? parameterTypes.size() : parameterTypes.size() + 1;
        ClassDescriptor classDescriptor = FunctionTypesKt.getFunctionDescriptor(builtIns, parameterCount, suspendFunction);
        Annotations typeAnnotations = receiverType != null ? FunctionTypesKt.withExtensionFunctionAnnotation(annotations2, builtIns) : annotations2;
        return KotlinTypeFactory.simpleNotNullType(typeAnnotations, classDescriptor, arguments2);
    }

    public static /* synthetic */ SimpleType createFunctionType$default(KotlinBuiltIns kotlinBuiltIns, Annotations annotations2, KotlinType kotlinType, List list, List list2, KotlinType kotlinType2, boolean bl, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl = false;
        }
        return FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType, list, list2, kotlinType2, bl);
    }

    @NotNull
    public static final Annotations withExtensionFunctionAnnotation(@NotNull Annotations $this$withExtensionFunctionAnnotation, @NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkNotNullParameter((Object)$this$withExtensionFunctionAnnotation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        return $this$withExtensionFunctionAnnotation.hasAnnotation(StandardNames.FqNames.extensionFunctionType) ? $this$withExtensionFunctionAnnotation : Annotations.Companion.create(CollectionsKt.plus((Iterable)$this$withExtensionFunctionAnnotation, (Object)new BuiltInAnnotationDescriptor(builtIns, StandardNames.FqNames.extensionFunctionType, MapsKt.emptyMap())));
    }

    @NotNull
    public static final ClassDescriptor getFunctionDescriptor(@NotNull KotlinBuiltIns builtIns, int parameterCount, boolean isSuspendFunction) {
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        ClassDescriptor classDescriptor = isSuspendFunction ? builtIns.getSuspendFunction(parameterCount) : builtIns.getFunction(parameterCount);
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"if (isSuspendFunction) b\u2026tFunction(parameterCount)");
        return classDescriptor;
    }
}

