/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.bytes;

import dorkbox.bytes.Base58;
import dorkbox.bytes.HashExtensionsKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0002*\u00020\u0001\u001a\n\u0010\u0005\u001a\u00020\u0002*\u00020\u0001\u00a8\u0006\u0006"}, d2={"decodeBase58", "", "", "decodeBase58WithChecksum", "encodeToBase58String", "encodeToBase58WithChecksum", "ByteUtilities"})
public final class Base58Kt {
    @NotNull
    public static final String encodeToBase58String(@NotNull byte[] $this$encodeToBase58String) {
        int zeros;
        Intrinsics.checkNotNullParameter((Object)$this$encodeToBase58String, (String)"<this>");
        byte[] byArray = Arrays.copyOf($this$encodeToBase58String, $this$encodeToBase58String.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, newSize)");
        byte[] input = byArray;
        if (input.length == 0) {
            return "";
        }
        for (zeros = 0; zeros < input.length && input[zeros] == 0; ++zeros) {
        }
        char[] encoded = new char[input.length * 2];
        int outputStart = encoded.length;
        int inputStart = zeros;
        while (inputStart < input.length) {
            encoded[--outputStart] = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz".charAt(Base58.INSTANCE.divmod-rTqQJP0$ByteUtilities(input, UInt.constructor-impl((int)inputStart), UInt.constructor-impl((int)256), UInt.constructor-impl((int)58)));
            if (input[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < encoded.length && encoded[outputStart] == '1') {
            ++outputStart;
        }
        while (--zeros >= 0) {
            encoded[--outputStart] = 49;
        }
        return new String(encoded, outputStart, encoded.length - outputStart);
    }

    @NotNull
    public static final byte[] decodeBase58(@NotNull String $this$decodeBase58) throws NumberFormatException {
        int zeros;
        Intrinsics.checkNotNullParameter((Object)$this$decodeBase58, (String)"<this>");
        if (((CharSequence)$this$decodeBase58).length() == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[$this$decodeBase58.length()];
        int n = $this$decodeBase58.length();
        for (int i = 0; i < n; ++i) {
            int digit;
            char c = $this$decodeBase58.charAt(i);
            int n2 = digit = c < '\u0080' ? Base58.INSTANCE.getAlphabetIndices$ByteUtilities()[c] : -1;
            if (digit < 0) {
                throw new NumberFormatException("Illegal character " + c + " at position " + i);
            }
            input58[i] = (byte)digit;
        }
        for (zeros = 0; zeros < input58.length && input58[zeros] == 0; ++zeros) {
        }
        byte[] decoded = new byte[$this$decodeBase58.length()];
        int outputStart = decoded.length;
        int inputStart = zeros;
        while (inputStart < input58.length) {
            decoded[--outputStart] = (byte)Base58.INSTANCE.divmod-rTqQJP0$ByteUtilities(input58, UInt.constructor-impl((int)inputStart), UInt.constructor-impl((int)58), UInt.constructor-impl((int)256));
            if (input58[inputStart] != 0) continue;
            ++inputStart;
        }
        while (outputStart < decoded.length && decoded[outputStart] == 0) {
            ++outputStart;
        }
        byte[] byArray = decoded;
        int n3 = outputStart - zeros;
        int n4 = decoded.length;
        return ArraysKt.copyOfRange((byte[])byArray, (int)n3, (int)n4);
    }

    @NotNull
    public static final String encodeToBase58WithChecksum(@NotNull byte[] $this$encodeToBase58WithChecksum) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$encodeToBase58WithChecksum, (String)"<this>");
        byte[] $this$encodeToBase58WithChecksum_u24lambda_u240 = byArray = new byte[$this$encodeToBase58WithChecksum.length + 4];
        boolean bl = false;
        System.arraycopy($this$encodeToBase58WithChecksum, 0, $this$encodeToBase58WithChecksum_u24lambda_u240, 0, $this$encodeToBase58WithChecksum.length);
        byte[] checksum = HashExtensionsKt.sha256$default(HashExtensionsKt.sha256$default($this$encodeToBase58WithChecksum, 0, 0, 3, null), 0, 0, 3, null);
        System.arraycopy(checksum, 0, $this$encodeToBase58WithChecksum_u24lambda_u240, $this$encodeToBase58WithChecksum.length, 4);
        return Base58Kt.encodeToBase58String(byArray);
    }

    @NotNull
    public static final byte[] decodeBase58WithChecksum(@NotNull String $this$decodeBase58WithChecksum) {
        int n;
        int n2;
        int n3;
        byte[] byArray;
        byte[] payload;
        byte[] hash;
        byte[] byArray2;
        byte[] computedChecksum;
        Intrinsics.checkNotNullParameter((Object)$this$decodeBase58WithChecksum, (String)"<this>");
        byte[] rawBytes = Base58Kt.decodeBase58($this$decodeBase58WithChecksum);
        if (rawBytes.length < 4) {
            throw new Exception("Too short for checksum: " + $this$decodeBase58WithChecksum + " l:  " + rawBytes.length);
        }
        byte[] byArray3 = rawBytes;
        int n4 = rawBytes.length - 4;
        int n5 = rawBytes.length;
        byte[] checksum = ArraysKt.copyOfRange((byte[])byArray3, (int)n4, (int)n5);
        if (Arrays.equals(checksum, computedChecksum = ArraysKt.copyOfRange((byte[])(byArray2 = (hash = HashExtensionsKt.sha256$default(HashExtensionsKt.sha256$default(payload = ArraysKt.copyOfRange((byte[])(byArray = rawBytes), (int)(n5 = 0), (int)(n3 = rawBytes.length - 4)), 0, 0, 3, null), 0, 0, 3, null))), (int)(n2 = 0), (int)(n = 4)))) {
            return payload;
        }
        throw new IllegalArgumentException("Checksum mismatch: " + checksum + " is not computed checksum " + computedChecksum);
    }
}

