/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.types;

import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.TypeExprList;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.jassIm.ImExprOpt;
import de.peeeq.wurstscript.jassIm.ImType;
import de.peeeq.wurstscript.jassIm.JassIm;
import de.peeeq.wurstscript.translation.imtranslation.ImTranslator;
import de.peeeq.wurstscript.types.VariableBinding;
import de.peeeq.wurstscript.types.VariablePosition;
import de.peeeq.wurstscript.types.WurstType;
import de.peeeq.wurstscript.types.WurstTypeBoundTypeParam;
import io.vavr.control.Option;
import org.eclipse.jdt.annotation.Nullable;

public class WurstTypeTypeParam
extends WurstType {
    private final TypeParamDef def;

    public WurstTypeTypeParam(TypeParamDef t) {
        this.def = t;
    }

    @Override
    VariableBinding matchAgainstSupertypeIntern(WurstType other, @Nullable Element location, VariableBinding mapping, VariablePosition variablePosition) {
        if (variablePosition == VariablePosition.LEFT) {
            Option<WurstTypeBoundTypeParam> binding = mapping.get(this.def);
            if (binding.isDefined()) {
                return ((WurstTypeBoundTypeParam)binding.get()).matchAgainstSupertypeIntern(other, location, mapping, variablePosition);
            }
            if (mapping.isVar(this.def)) {
                return mapping.set(this.def, new WurstTypeBoundTypeParam(this.def, other, location));
            }
        }
        if (other instanceof WurstTypeTypeParam) {
            WurstTypeTypeParam other2 = (WurstTypeTypeParam)other;
            if (other2.def == this.def) {
                return mapping;
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.def.getName();
    }

    @Override
    public String getFullName() {
        return this.getName() + " (type parameter line " + this.def.getSource().getLine() + ")";
    }

    public TypeParamDef getDef() {
        return this.def;
    }

    @Override
    public VariableBinding getTypeArgBinding() {
        return VariableBinding.emptyMapping();
    }

    @Override
    public WurstType setTypeArgs(VariableBinding typeParamBounds) {
        if (typeParamBounds.contains(this.def)) {
            return (WurstType)typeParamBounds.get(this.def).get();
        }
        return this;
    }

    @Override
    public ImType imTranslateType(ImTranslator tr) {
        if (this.hasTypeConstraints()) {
            return JassIm.ImTypeVarRef(tr.getTypeVar(this.def));
        }
        return JassIm.ImAnyType();
    }

    private boolean hasTypeConstraints() {
        return this.def.getTypeParamConstraints() instanceof TypeExprList;
    }

    @Override
    public ImExprOpt getDefaultValue(ImTranslator tr) {
        return JassIm.ImNull(this.imTranslateType(tr));
    }

    @Override
    public boolean isCastableToInt() {
        return !this.hasTypeConstraints();
    }

    @Override
    protected boolean isNullable() {
        return !this.hasTypeConstraints();
    }
}

