/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.StdBinInputStream;
import net.moonlightflower.wc3libs.dataTypes.app.FlagsInt;
import net.moonlightflower.wc3libs.misc.UnsupportedFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TGADecoder {
    private static final Logger log = LoggerFactory.getLogger((String)FlagsInt.class.getName());
    private int _height;
    private int _width;
    private boolean _isV2;
    private int _metaOffset;
    private int _devAreaOffset;
    private StdBinInputStream _stream;

    private void readFooter() throws IOException {
        String v2Sign = "TRUEVISION_XFILE.";
        this._stream.setPos(this._stream.size() - (long)v2Sign.length() - 1L);
        String versionSign = this._stream.readString("versionSign");
        if (versionSign.equals(v2Sign)) {
            this._stream.setPos(this._stream.size() - (long)v2Sign.length() - 9L);
            this._isV2 = true;
            this._metaOffset = this._stream.readDoubleWord("metaOffset");
            this._devAreaOffset = this._stream.readDoubleWord("devAreaOffset");
        }
    }

    private void readMeta() throws IOException {
        if (this._isV2 && this._metaOffset > 0) {
            int i;
            int size = this._stream.readWord("metaSize");
            String author = this._stream.readString("author");
            String commentA = this._stream.readString("commentA");
            String commentB = this._stream.readString("commentB");
            String commentC = this._stream.readString("commentC");
            String commentD = this._stream.readString("commentD");
            int stampMonth = this._stream.readWord("timestamp_month");
            int stampDay = this._stream.readWord("timestamp_day");
            int stampYear = this._stream.readWord("timestamp_year");
            int stampHour = this._stream.readWord("timestamp_hour");
            int stampMin = this._stream.readWord("timestamp_min");
            int stampSec = this._stream.readWord("timestamp_sec");
            String jobName = this._stream.readString("jobName");
            int jobHour = this._stream.readWord("jobHour");
            int jobMin = this._stream.readWord("jobMin");
            int jobSec = this._stream.readWord("jobSec");
            String softwareId = this._stream.readString("softwareId");
            int version = this._stream.readWord("version");
            byte softwareVersion = this._stream.readByte("softwareVersion");
            int backgroundColor = this._stream.readWord("backgroundColor");
            int pxAspectRatioNumerator = this._stream.readWord("pxAspectRatioNum");
            int pxAspectRatioDenominator = this._stream.readWord("pxAspectRatioDenom");
            int gammaNumerator = this._stream.readWord("gammaNum");
            int gammaDenominator = this._stream.readWord("gammaDenom");
            int colorCorrectionTableOffset = this._stream.readDoubleWord("colorCorrectionTableOffset");
            int thumbnailOffset = this._stream.readDoubleWord("thumbnailOffset");
            int scanLineTableOffset = this._stream.readDoubleWord("scanLineTableOffset");
            if (scanLineTableOffset > 0) {
                this._stream.setPos(scanLineTableOffset);
                int[] offsets = new int[this._height];
                for (i = 0; i < offsets.length; ++i) {
                    offsets[i] = this._stream.readWord(String.format("scanLineOffset %d", i));
                }
            }
            if (thumbnailOffset > 0) {
                this._stream.setPos(thumbnailOffset);
                byte width = this._stream.readByte("thumbnailWidth");
                byte height = this._stream.readByte("thumbnailHeight");
                throw new UnsupportedOperationException();
            }
            if (colorCorrectionTableOffset > 0) {
                this._stream.setPos(colorCorrectionTableOffset);
                int[][] colors = new int[256][];
                for (i = 0; i < 256; ++i) {
                    colors[i][0] = this._stream.readWord(String.format("colorCorrectionAlpha %d", i));
                    colors[i][1] = this._stream.readWord(String.format("colorCorrectionBlue %d", i));
                    colors[i][2] = this._stream.readWord(String.format("colorCorrectionGreen %d", i));
                    colors[i][3] = this._stream.readWord(String.format("colorCorrectionRed %d", i));
                }
            }
        }
    }

    @Nonnull
    private Color readColor(int bitsPerPx) throws IOException {
        int bytesPerPx = (bitsPerPx + 8 - 1) / 8;
        int colorData = 0;
        for (int j = 0; j < bytesPerPx; ++j) {
            int add = (this._stream.readByte() & 0xFF) << (bytesPerPx - j - 1) * 8;
            colorData += add;
        }
        double red = 0.0;
        double green = 0.0;
        double blue = 0.0;
        double alpha = 0.0;
        switch (bitsPerPx) {
            case 1: {
                red = colorData * 255;
                green = colorData * 255;
                blue = colorData * 255;
                alpha = 1.0;
                break;
            }
            case 8: {
                throw new UnsupportedOperationException();
            }
            case 15: {
                red = (float)(colorData >> 10 & 0x1F) / 31.0f;
                green = (float)(colorData >> 5 & 0x1F) / 31.0f;
                blue = (float)(colorData & 0x1F) / 31.0f;
                alpha = 1.0;
                break;
            }
            case 16: {
                red = (float)(colorData >> 10 & 0x1F) / 31.0f;
                green = (float)(colorData >> 5 & 0x1F) / 31.0f;
                blue = (float)(colorData & 0x1F) / 31.0f;
                alpha = colorData >> 15;
                break;
            }
            case 24: {
                red = (double)(colorData & 0xFF) / 255.0;
                green = (double)(colorData >> 8 & 0xFF) / 255.0;
                blue = (double)(colorData >> 16 & 0xFF) / 255.0;
                alpha = 1.0;
                break;
            }
            case 32: {
                red = (float)(colorData >> 8 & 0xFF) / 255.0f;
                green = (float)(colorData >> 16 & 0xFF) / 255.0f;
                blue = (float)(colorData >> 24 & 0xFF) / 255.0f;
                alpha = (float)(colorData & 0xFF) / 255.0f;
                break;
            }
            default: {
                throw new IOException("bitsPerPx " + bitsPerPx + " not supported");
            }
        }
        return new Color((int)(red * 255.0), (int)(green * 255.0), (int)(blue * 255.0), (int)(alpha * 255.0));
    }

    @Nonnull
    private BufferedImage readPriv(@Nonnull InputStream inStream) throws IOException, UnsupportedFormatException {
        try {
            int y;
            int i;
            boolean dirDownwards;
            this._stream = new StdBinInputStream(inStream);
            this.readFooter();
            this._stream.setPos(0L);
            byte imgIdLen = this._stream.readByte("imgIdLen");
            byte colorMapType = this._stream.readByte("colorMapType");
            byte imgTypeEx = this._stream.readByte("imgTypeEx");
            int imgType = imgTypeEx & 7;
            boolean RLE = (imgTypeEx & 8) > 0;
            int colorMapStart = this._stream.readWord("colorMapStart");
            int colorMapLen = this._stream.readWord("colorMapLen");
            byte colorMapEntryLen = this._stream.readByte("colorMapEntryLen");
            int originX = this._stream.readWord("originX");
            int originY = this._stream.readWord("originY");
            int width = this._stream.readUWord("width");
            int height = this._stream.readUWord("height");
            byte bitsPerPx = this._stream.readByte("bitsPerPx");
            byte imgDescriptor = this._stream.readByte("imgDescriptor");
            int alphaDepth = imgDescriptor & 7;
            int dir = imgDescriptor >> 4 & 3;
            boolean dirLeftwards = (dir & 1) > 0;
            boolean bl = dirDownwards = (dir & 2) > 0;
            if (imgIdLen > 0) {
                int[] imgId = new int[imgIdLen];
                for (i = 0; i < imgId.length; ++i) {
                    imgId[i] = this._stream.readByte(String.format("imgId %d", i));
                }
            }
            Color[] colorMap = null;
            if (colorMapType > 0 && colorMapLen > 0) {
                colorMap = new Color[colorMapLen];
                for (i = 0; i < colorMapLen; ++i) {
                    colorMap[i] = this.readColor(bitsPerPx);
                }
            }
            Color[][] pxColors = new Color[width][height];
            switch (imgType) {
                case 1: {
                    int x;
                    int y2;
                    int size;
                    boolean isRunLenPacket;
                    byte header;
                    int x2;
                    if (RLE) {
                        x2 = 0;
                        y = 0;
                        while (x2 < width && y < height) {
                            header = this._stream.readByte();
                            isRunLenPacket = (header & 0x80) > 0;
                            size = (header & 0x7F) + 1;
                            if (isRunLenPacket) {
                                int colorIndex = this._stream.readWord();
                                Color color = colorMap[colorIndex];
                                for (int i2 = 0; i2 < size; ++i2) {
                                    pxColors[x2][y] = color;
                                    if (++x2 < width) continue;
                                    x2 = 0;
                                    ++y;
                                }
                                continue;
                            }
                            for (int i3 = 0; i3 < size; ++i3) {
                                int colorIndex = this._stream.readWord();
                                pxColors[x2][y] = colorMap[colorIndex];
                                if (++x2 < width) continue;
                                x2 = 0;
                                ++y;
                            }
                        }
                        break;
                    }
                    for (y2 = 0; y2 < height; ++y2) {
                        for (x = 0; x < width; ++x) {
                            int colorIndex = this._stream.readWord();
                            pxColors[x][y2] = colorMap[colorIndex];
                        }
                    }
                    break;
                }
                case 2: {
                    int x;
                    int y2;
                    int size;
                    boolean isRunLenPacket;
                    byte header;
                    int x2;
                    if (RLE) {
                        x2 = 0;
                        y = 0;
                        while (x2 < width && y < height) {
                            header = this._stream.readByte();
                            isRunLenPacket = (header & 0x80) > 0;
                            size = (header & 0x7F) + 1;
                            if (isRunLenPacket) {
                                Color color = this.readColor(bitsPerPx);
                                for (int i4 = 0; i4 < size; ++i4) {
                                    pxColors[x2][y] = color;
                                    if (++x2 < width) continue;
                                    x2 = 0;
                                    ++y;
                                }
                                continue;
                            }
                            for (int i5 = 0; i5 < size; ++i5) {
                                pxColors[x2][y] = this.readColor(bitsPerPx);
                                if (++x2 < width) continue;
                                x2 = 0;
                                ++y;
                            }
                        }
                        break;
                    }
                    for (y2 = 0; y2 < height; ++y2) {
                        for (x = 0; x < width; ++x) {
                            pxColors[x][y2] = this.readColor(bitsPerPx);
                        }
                    }
                    break;
                }
                default: {
                    throw new IOException("imgType " + imgType + " is not supported");
                }
            }
            if (this._isV2 && this._devAreaOffset > 0) {
                int devEntriesLen = this._stream.readWord("devEntriesLen");
                int devId = this._stream.readWord("devId");
                int devOffset = this._stream.readDoubleWord("devOffset");
                int devLen = this._stream.readDoubleWord("devLen");
                byte[][] devEntries = new byte[devEntriesLen][];
                for (int i6 = 0; i6 < devEntriesLen; ++i6) {
                    devEntries[i6] = new byte[10];
                    for (int j = 0; j < 10; ++j) {
                        devEntries[i6][j] = this._stream.readByte(String.format("devEntry %d;%d", i6, j));
                    }
                }
            }
            this.readMeta();
            BufferedImage writeImg = new BufferedImage(width, height, 2);
            for (y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int x2 = x;
                    int y2 = y;
                    if (dirLeftwards) {
                        x2 = width - x - 1;
                    }
                    if (!dirDownwards) {
                        y2 = height - y - 1;
                    }
                    Color pxColor = pxColors[x2][y2];
                    writeImg.setRGB(x, y, pxColor.getRGB());
                }
            }
            return writeImg;
        }
        catch (Exception e) {
            this._stream.printLog(System.err);
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private TGADecoder() {
    }

    @Nonnull
    public static BufferedImage read(@Nonnull InputStream inStream) throws IOException, UnsupportedFormatException {
        TGADecoder decoder = new TGADecoder();
        return decoder.readPriv(inStream);
    }
}

