/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc;

import java.util.ArrayList;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.misc.ObservableArrayList;

public class ObservableArrayListView<T, SubType extends T>
extends ArrayList<SubType> {
    private final ObservableArrayList<T> _parent;

    public void onAdd(T val) {
    }

    @Override
    public boolean add(SubType val) {
        boolean ret = super.add(val);
        if (ret) {
            this.onAdd(val);
            this._parent.add(val);
        }
        return ret;
    }

    public void onRemove(T val) {
    }

    @Override
    public boolean remove(Object val) {
        boolean ret = super.remove(val);
        if (ret) {
            this.onRemove(val);
            this._parent.remove(val);
        }
        return ret;
    }

    public void onClear() {
    }

    @Override
    public void clear() {
        this._parent.clear();
        this.onClear();
    }

    public ObservableArrayListView(@Nonnull ObservableArrayList<T> parent, final @Nonnull Predicate<T> filter) {
        this._parent = parent;
        for (Object val : this._parent) {
            if (!filter.test(val)) continue;
            this.add((SubType)val);
        }
        this._parent._listeners.add(new ObservableArrayList.Listener<T>(){

            @Override
            public void onAdd(T val) {
                if (filter.test(val)) {
                    ObservableArrayListView.this.add(val);
                }
            }

            @Override
            public void onRemove(T val) {
                if (filter.test(val)) {
                    ObservableArrayListView.this.remove(val);
                }
            }

            @Override
            public void clear() {
            }
        });
    }
}

