/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes;

import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.parser.WPos;
import de.peeeq.wurstscript.utils.LineOffsets;
import java.io.File;
import java.io.Serializable;
import org.eclipse.jdt.annotation.Nullable;

public class CompileError
extends Error
implements Serializable {
    private static final long serialVersionUID = 5589441532198109034L;
    private final WPos source;
    private final String message;
    private final ErrorType errorType;

    public CompileError(WPos source, String message) {
        this(source, message, ErrorType.ERROR);
    }

    public CompileError(@Nullable WPos source, String message, ErrorType errorType) {
        this(source, message, errorType, null);
    }

    public CompileError(@Nullable WPos source, String message, ErrorType errorType, Throwable cause) {
        super(message, cause);
        this.source = source == null ? new WPos("", new LineOffsets(), 0, 0) : source;
        this.message = message;
        this.errorType = errorType;
    }

    public CompileError(de.peeeq.wurstscript.jassIm.Element e, String msg) {
        this(e.attrTrace().attrErrorPos(), msg);
    }

    public CompileError(Element e, String msg) {
        this(e.attrErrorPos(), msg);
    }

    public WPos getSource() {
        return this.source;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String toString() {
        File file = new File(this.source.getFile());
        return this.errorType + " in File " + file.getName() + " line " + this.source.getLine() + ":\n " + this.message;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public static enum ErrorType {
        ERROR,
        WARNING;


        public String toString() {
            if (this == ERROR) {
                return "Error";
            }
            return "Warning";
        }
    }
}

