/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.validation.controlflow;

import de.peeeq.wurstscript.ast.FunctionLike;
import de.peeeq.wurstscript.ast.InterfaceDef;
import de.peeeq.wurstscript.ast.StartFunctionStatement;
import de.peeeq.wurstscript.ast.StmtReturn;
import de.peeeq.wurstscript.ast.WStatement;
import de.peeeq.wurstscript.types.WurstTypeVoid;
import de.peeeq.wurstscript.utils.Utils;
import de.peeeq.wurstscript.validation.controlflow.ForwardMethod;
import java.util.Collection;

public class ReturnsAnalysis
extends ForwardMethod<Boolean, FunctionLike> {
    @Override
    Boolean calculate(WStatement s, Boolean incoming) {
        if (s instanceof StartFunctionStatement) {
            return false;
        }
        if (s instanceof StmtReturn) {
            return true;
        }
        return incoming;
    }

    @Override
    Boolean merge(Collection<Boolean> values) {
        if (values.isEmpty()) {
            return false;
        }
        for (Boolean v : values) {
            if (v.booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean equality(Boolean a, Boolean b) {
        return a.booleanValue() == b.booleanValue();
    }

    @Override
    void checkFinal(Boolean incoming) {
        FunctionLike f = (FunctionLike)this.getFuncDef();
        if (!(f.attrReturnType() instanceof WurstTypeVoid || f.attrNearestStructureDef() instanceof InterfaceDef || incoming.booleanValue())) {
            f.addError(Utils.printElement(f) + " is missing a return statement.");
        }
    }

    @Override
    public Boolean startValue() {
        return true;
    }
}

