/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObservableArrayList;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.MDXObject;
import net.moonlightflower.wc3libs.misc.model.mdx.TexCoord;

public class TexCoordSet
extends MDXObject {
    public final Id TOKEN = Id.valueOf("UVBS");
    private final ArrayList<TexCoord> _texCoords = new ObservableArrayList<TexCoord>();

    public ArrayList<TexCoord> getTexCoords() {
        return this._texCoords;
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        stream.writeId(this.TOKEN);
        stream.writeUInt32(this.getTexCoords().size());
        for (TexCoord texCoord : this.getTexCoords()) {
            texCoord.write(stream);
        }
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public TexCoordSet(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        Id token = stream.readId("token");
        for (long texCoordsCount = stream.readUInt32("texCoordsCount").longValue(); texCoordsCount > 0L; --texCoordsCount) {
            this._texCoords.add(new TexCoord(stream));
        }
    }

    public TexCoordSet() {
    }
}

