/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.misc.model.mdx;

import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import net.moonlightflower.wc3libs.bin.BinStream;
import net.moonlightflower.wc3libs.bin.Wc3BinInputStream;
import net.moonlightflower.wc3libs.bin.Wc3BinOutputStream;
import net.moonlightflower.wc3libs.misc.Id;
import net.moonlightflower.wc3libs.misc.ObservableLinkedHashSet;
import net.moonlightflower.wc3libs.misc.model.MDX;
import net.moonlightflower.wc3libs.misc.model.mdx.Chunk;
import net.moonlightflower.wc3libs.misc.model.mdx.IndexReference;

public class FaceGroupChunk
extends Chunk {
    public static Id TOKEN = Id.valueOf("PCNT");
    private final LinkedHashSet<IndexReference> _faceGroups = new ObservableLinkedHashSet<IndexReference>();

    @Override
    public Id getToken() {
        return TOKEN;
    }

    public LinkedHashSet<IndexReference> getFaceTypeGroups() {
        return this._faceGroups;
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream, @Nonnull MDX.EncodingFormat format) throws BinStream.StreamException {
        stream.writeId(TOKEN);
        stream.writeUInt32(this._faceGroups.size());
        for (IndexReference faceGroup : this._faceGroups) {
            faceGroup.write(stream);
        }
    }

    @Override
    public void write(@Nonnull Wc3BinOutputStream stream) throws BinStream.StreamException {
        this.write(stream, MDX.EncodingFormat.AUTO);
    }

    public FaceGroupChunk(@Nonnull Wc3BinInputStream stream) throws BinStream.StreamException {
        Id token = stream.readId("token");
        if (!token.equals(this.getToken())) {
            throw new IllegalArgumentException("invalid " + this.getToken() + " startToken (" + token + ")");
        }
        for (long faceGroupsCount = stream.readUInt32("faceGroupsCount").longValue(); faceGroupsCount > 0L; --faceGroupsCount) {
            this._faceGroups.add(new IndexReference(stream));
        }
    }

    public FaceGroupChunk() {
    }
}

