/*
 * Decompiled with CFR 0.152.
 */
package systems.crigges.jmpq3.compression;

public class Exploder {
    private static final int PK_LITERAL_SIZE_FIXED = 0;
    private static final int PK_LITERAL_SIZE_VARIABLE = 1;
    private static final short[] ChCode = new short[]{1168, 4064, 2016, 3040, 992, 3552, 1504, 2528, 480, 184, 98, 3808, 1760, 34, 2784, 736, 3296, 1248, 2272, 224, 3936, 1888, 2912, 864, 3424, 1376, 4672, 2400, 352, 3680, 1632, 2656, 15, 592, 56, 608, 80, 3168, 912, 216, 66, 2, 88, 432, 124, 41, 60, 152, 92, 9, 28, 108, 44, 76, 24, 12, 116, 232, 104, 1120, 144, 52, 176, 1808, 2144, 49, 84, 17, 33, 23, 20, 168, 40, 1, 784, 304, 62, 100, 30, 46, 36, 1296, 14, 54, 22, 68, 48, 200, 464, 208, 272, 72, 1552, 336, 96, 136, 4000, 7, 38, 6, 58, 27, 26, 42, 10, 11, 528, 4, 19, 50, 3, 29, 18, 400, 13, 21, 5, 25, 8, 120, 240, 112, 656, 1040, 16, 1952, 2976, 928, 576, 7232, 3136, 5184, 1088, 6208, 2112, 4160, 64, 8064, 3968, 6016, 1920, 7040, 2944, 4992, 896, 7552, 3456, 5504, 1408, 6528, 2432, 4480, 384, 7808, 3712, 5760, 1664, 6784, 2688, 4736, 640, 7296, 3200, 5248, 1152, 6272, 2176, 4224, 128, 7936, 3840, 5888, 1792, 6912, 2816, 4864, 3488, 1440, 2464, 416, 3744, 1696, 2720, 672, 3232, 1184, 2208, 160, 3872, 1824, 2848, 800, 3360, 1312, 2336, 288, 3616, 1568, 2592, 544, 3104, 1056, 2080, 32, 4032, 1984, 3008, 960, 3520, 1472, 2496, 448, 3776, 1728, 2752, 704, 3264, 1216, 2240, 192, 3904, 1856, 2880, 832, 768, 3392, 7424, 3328, 5376, 1344, 1280, 6400, 2304, 2368, 4352, 256, 7680, 3584, 320, 5632, 1536, 6656, 3648, 1600, 2624, 2560, 4608, 512, 7168, 3072, 5120, 1024, 6144, 2048, 4096, 0};
    private static final byte[] ChBits = new byte[]{11, 12, 12, 12, 12, 12, 12, 12, 12, 8, 7, 12, 12, 7, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 12, 12, 12, 12, 12, 4, 10, 8, 12, 10, 12, 10, 8, 7, 7, 8, 9, 7, 6, 7, 8, 7, 6, 7, 7, 7, 7, 8, 7, 7, 8, 8, 12, 11, 7, 9, 11, 12, 6, 7, 6, 6, 5, 7, 8, 8, 6, 11, 9, 6, 7, 6, 6, 7, 11, 6, 6, 6, 7, 9, 8, 9, 9, 11, 8, 11, 9, 12, 8, 12, 5, 6, 6, 6, 5, 6, 6, 6, 5, 11, 7, 5, 6, 5, 5, 6, 10, 5, 5, 5, 5, 8, 7, 8, 8, 10, 11, 11, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 12, 13, 13, 13, 12, 13, 13, 13, 12, 13, 13, 13, 13, 12, 13, 13, 13, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13};
    private static final byte[] LenCode = new byte[]{5, 3, 1, 6, 10, 2, 12, 20, 4, 24, 8, 48, 16, 32, 64, 0};
    private static final byte[] LenBits = new byte[]{3, 2, 3, 3, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 7, 7};
    private static final short[] LenBase = new short[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 16, 24, 40, 72, 136, 264};
    private static final byte[] ExLenBits = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final byte[] OffsCode = new byte[]{3, 13, 5, 25, 9, 17, 1, 62, 30, 46, 14, 54, 22, 38, 6, 58, 26, 42, 10, 50, 18, 34, 66, 2, 124, 60, 92, 28, 108, 44, 76, 12, 116, 52, 84, 20, 100, 36, 68, 4, 120, 56, 88, 24, 104, 40, 72, 8, -16, 112, -80, 48, -48, 80, -112, 16, -32, 96, -96, 32, -64, 64, -128, 0};
    private static final byte[] OffsBits = new byte[]{2, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};

    private static long TRUNCATE_VALUE(long value, int bits) {
        return value & (1L << bits) - 1L;
    }

    public static int pkexplode(byte[] pInBuffer, byte[] pOutBuffer, int inPos) {
        if (pInBuffer.length < 4) {
            throw new IllegalArgumentException("PK_ERR_INCOMPLETE_INPUT: Incomplete input");
        }
        int pOutPos = 0;
        int pInPos = inPos;
        byte nLitSize = pInBuffer[pInPos++];
        byte nDictSizeByte = pInBuffer[pInPos++];
        if (nLitSize != 0 && nLitSize != 1) {
            throw new IllegalArgumentException("PK_ERR_BAD_DATA: Invalid LitSize: " + nLitSize);
        }
        if (4 > nDictSizeByte || nDictSizeByte > 6) {
            throw new IllegalArgumentException("PK_ERR_BAD_DATA: Invalid DictSizeByte: " + nDictSizeByte);
        }
        int nDictSize = 64 << nDictSizeByte;
        byte[] Dict = new byte[4096];
        int pDictPos = 0;
        int nCurDictSize = 0;
        long nBitBuffer = (long)pInBuffer[pInPos++] & 0xFFL;
        nBitBuffer += ((long)pInBuffer[pInPos++] & 0xFFL) << 8;
        int nBits = 16;
        while (pOutPos < pOutBuffer.length) {
            int i;
            while (nBits < 16) {
                if (pInPos >= pInBuffer.length) {
                    throw new IllegalArgumentException("PK_ERR_INCOMPLETE_INPUT: Incomplete input");
                }
                nBitBuffer += (long)(pInBuffer[pInPos++] & 0xFF) << nBits;
                nBits = (byte)(nBits + 8);
            }
            if ((nBitBuffer & 1L) != 0L) {
                int pCopyOffs;
                nBitBuffer >>= 1;
                nBits = (byte)(nBits - 1);
                for (i = 0; i <= 15 && Exploder.TRUNCATE_VALUE(nBitBuffer, LenBits[i] & 0xFF) != (long)(LenCode[i] & 0xFF); ++i) {
                }
                nBits = (byte)(nBits - (LenBits[i] & 0xFF));
                int nCopyLen = (int)((long)(LenBase[i] & 0xFFFF) + Exploder.TRUNCATE_VALUE(nBitBuffer >>= LenBits[i] & 0xFF, ExLenBits[i] & 0xFF));
                nBitBuffer >>= ExLenBits[i] & 0xFF;
                if (nCopyLen == 519) break;
                for (nBits = (int)((byte)(nBits - (ExLenBits[i] & 0xFF))); nBits < 14; nBits = (int)((byte)(nBits + 8))) {
                    if (pInPos >= pInBuffer.length) {
                        throw new IllegalArgumentException("PK_ERR_INCOMPLETE_INPUT: Incomplete input");
                    }
                    nBitBuffer += (long)(pInBuffer[pInPos++] & 0xFF) << nBits;
                }
                for (i = 0; i <= 63 && Exploder.TRUNCATE_VALUE(nBitBuffer, OffsBits[i] & 0xFF) != (long)(OffsCode[i] & 0xFF); ++i) {
                }
                nBitBuffer >>= OffsBits[i] & 0xFF;
                nBits = (byte)(nBits - (OffsBits[i] & 0xFF));
                if (nCopyLen == 2) {
                    pCopyOffs = (int)((long)(pDictPos - 1) - ((long)(i << 2) + (nBitBuffer & 3L)));
                    nBitBuffer >>= 2;
                    nBits = (byte)(nBits - 2);
                } else {
                    pCopyOffs = (int)((long)(pDictPos - 1) - ((long)(i << nDictSizeByte) + Exploder.TRUNCATE_VALUE(nBitBuffer, nDictSizeByte)));
                    nBitBuffer >>= nDictSizeByte;
                    nBits = (byte)(nBits - nDictSizeByte);
                }
                while (nCopyLen-- > 0) {
                    if (pOutPos >= pOutBuffer.length) {
                        throw new IllegalArgumentException("PK_ERR_BUFFER_TOO_SMALL: Output buffer is full: " + pOutPos + " / " + pOutBuffer.length);
                    }
                    while (pCopyOffs < 0) {
                        pCopyOffs += nCurDictSize;
                    }
                    while (pCopyOffs >= nCurDictSize) {
                        pCopyOffs -= nCurDictSize;
                    }
                    int n = pDictPos++;
                    int n2 = pOutPos++;
                    byte by = Dict[pCopyOffs++];
                    pOutBuffer[n2] = by;
                    Dict[n] = by;
                    if (nCurDictSize < nDictSize) {
                        ++nCurDictSize;
                    }
                    if (pDictPos < nDictSize) continue;
                    pDictPos = 0;
                }
                continue;
            }
            if (nLitSize == 0) {
                int n = pDictPos++;
                int n3 = pOutPos++;
                byte by = (byte)(nBitBuffer >> 1);
                pOutBuffer[n3] = by;
                Dict[n] = by;
                nBitBuffer >>= 9;
                nBits = (byte)(nBits - 9);
            } else {
                nBitBuffer >>= 1;
                nBits = (byte)(nBits - 1);
                for (i = 0; i <= 255 && Exploder.TRUNCATE_VALUE(nBitBuffer, ChBits[i] & 0xFF) != (long)(ChCode[i] & 0xFFFF); ++i) {
                }
                int n = pDictPos++;
                int n4 = pOutPos++;
                byte by = (byte)i;
                pOutBuffer[n4] = by;
                Dict[n] = by;
                nBitBuffer >>= ChBits[i] & 0xFF;
                nBits = (byte)(nBits - (ChBits[i] & 0xFF));
            }
            if (nCurDictSize < nDictSize) {
                ++nCurDictSize;
            }
            if (pDictPos < nDictSize) continue;
            pDictPos = 0;
        }
        return pOutPos;
    }
}

