/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtranslation;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import de.peeeq.wurstscript.ast.Element;
import de.peeeq.wurstscript.ast.PackageOrGlobal;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.jassIm.ImClass;
import de.peeeq.wurstscript.jassIm.ImClassType;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.translation.imtranslation.ImPrinter;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;

public class TypeId {
    private static final Comparator<ImClass> class_comparator = Comparator.comparing(ImClass::getName).thenComparing(TypeId::packageName);
    private static final Comparator<ImClassType> classtype_comparator = Comparator.comparing(ct -> ct.getClassDef().getName()).thenComparing(ct -> TypeId.packageName(ct.getClassDef()));

    public static Map<ImClass, Integer> calculate(ImProg prog) {
        AtomicInteger count = new AtomicInteger();
        LinkedHashMap result = Maps.newLinkedHashMap();
        List<ImClass> classes = prog.getClasses().stream().sorted(class_comparator).collect(Collectors.toList());
        TypeId.assignIds(count, result, classes);
        return result;
    }

    private static String packageName(ImClass ic) {
        Element c = ic.attrTrace();
        @Nullable PackageOrGlobal nearestPackage = c.attrNearestPackage();
        if (nearestPackage instanceof WPackage) {
            return ((WPackage)nearestPackage).getName();
        }
        return "global";
    }

    private static void assignIds(AtomicInteger count, Map<ImClass, Integer> result, List<ImClass> classes) {
        Multimap<ImClass, ImClass> subClasses = TypeId.calculateSubclasses(classes);
        for (ImClass c : classes) {
            if (!c.getSuperClasses().isEmpty()) continue;
            TypeId.assignId(count, result, c, subClasses);
        }
    }

    private static Multimap<ImClass, ImClass> calculateSubclasses(List<ImClass> classes) {
        LinkedHashMultimap subClasses = LinkedHashMultimap.create();
        for (ImClass c : classes) {
            c.getSuperClasses().stream().map(ImClassType::getClassDef).sorted(class_comparator).forEach(arg_0 -> TypeId.lambda$calculateSubclasses$2((Multimap)subClasses, c, arg_0));
        }
        return subClasses;
    }

    private static void assignId(AtomicInteger count, Map<ImClass, Integer> result, ImClass c, Multimap<ImClass, ImClass> subClasses) {
        if (!result.containsKey(c)) {
            result.put(c, count.incrementAndGet());
            for (ImClass sub : subClasses.get((Object)c)) {
                TypeId.assignId(count, result, sub, subClasses);
            }
        }
    }

    public static int get(ImClass c) {
        Integer res = c.attrProg().attrTypeId().get(c);
        if (res == null) {
            throw new CompileError(c, "Could not get type-id for " + c.getName() + ImPrinter.smallHash(c));
        }
        return res;
    }

    public static boolean isSubclass(ImClass c, ImClass other) {
        if (c == other) {
            return true;
        }
        for (ImClassType sc : c.getSuperClasses()) {
            if (!sc.getClassDef().isSubclassOf(other)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$calculateSubclasses$2(Multimap subClasses, ImClass c, ImClass superClass) {
        subClasses.put((Object)superClass, (Object)c);
    }
}

