/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.translation.imtojass;

import de.peeeq.wurstscript.ast.Ast;
import de.peeeq.wurstscript.attributes.CompileError;
import de.peeeq.wurstscript.jassIm.Element;
import de.peeeq.wurstscript.jassIm.ElementWithTrace;
import de.peeeq.wurstscript.jassIm.ImAnyType;
import de.peeeq.wurstscript.jassIm.ImArrayType;
import de.peeeq.wurstscript.jassIm.ImArrayTypeMulti;
import de.peeeq.wurstscript.jassIm.ImClass;
import de.peeeq.wurstscript.jassIm.ImClassType;
import de.peeeq.wurstscript.jassIm.ImFunction;
import de.peeeq.wurstscript.jassIm.ImMethod;
import de.peeeq.wurstscript.jassIm.ImProg;
import de.peeeq.wurstscript.jassIm.ImSimpleType;
import de.peeeq.wurstscript.jassIm.ImTupleType;
import de.peeeq.wurstscript.jassIm.ImTypeVarRef;
import de.peeeq.wurstscript.jassIm.ImVar;
import de.peeeq.wurstscript.jassIm.ImVoid;
import de.peeeq.wurstscript.translation.imtranslation.FunctionFlag;
import de.peeeq.wurstscript.translation.imtranslation.FunctionFlagCompiletime;
import de.peeeq.wurstscript.translation.imtranslation.FunctionFlagEnum;
import java.util.ArrayDeque;

public class ImAttributes {
    public static ImFunction getNearestFunc(Element e) {
        while (e != null && !(e instanceof ImFunction)) {
            e = e.getParent();
        }
        return (ImFunction)e;
    }

    public static String translateType(ImArrayType t) {
        return t.getEntryType().translateType();
    }

    public static String translateType(ImArrayTypeMulti imArrayTypeMulti) {
        throw new Error("multi-arrays should be eliminated in earlier phase");
    }

    public static String translateType(ImSimpleType t) {
        return t.getTypename();
    }

    public static String translateType(ImTupleType t) {
        throw new Error("tuples should be eliminated in earlier phase");
    }

    public static String translateType(ImVoid t) {
        return "nothing";
    }

    public static boolean isGlobal(ImVar imVar) {
        Element parent = imVar.getParent();
        if (parent == null) {
            throw new RuntimeException("Variable " + imVar + " not attached.");
        }
        return parent.getParent() instanceof ImProg;
    }

    public static boolean isBj(ImFunction f) {
        return f.getFlags().contains(FunctionFlagEnum.IS_BJ);
    }

    public static boolean isExtern(ImFunction f) {
        return f.getFlags().contains(FunctionFlagEnum.IS_EXTERN);
    }

    public static boolean isNative(ImFunction f) {
        return f.getFlags().contains(FunctionFlagEnum.IS_NATIVE);
    }

    public static boolean isCompiletime(ImFunction f) {
        return f.getFlags().stream().anyMatch(flag -> flag instanceof FunctionFlagCompiletime);
    }

    public static de.peeeq.wurstscript.ast.Element getTrace(ElementWithTrace t) {
        return t.getTrace();
    }

    public static de.peeeq.wurstscript.ast.Element getTrace(Element t) {
        ArrayDeque<Element> q = new ArrayDeque<Element>();
        q.add(t);
        while (q.isEmpty()) {
            Element e = (Element)q.removeFirst();
            if (e == null) continue;
            q.add(e.getParent());
            for (int i = 0; i < e.size(); ++i) {
                q.add(e.get(i));
            }
            if (!(e instanceof ElementWithTrace)) continue;
            return ((ElementWithTrace)e).getTrace();
        }
        return Ast.NoExpr();
    }

    public static boolean hasFlag(ImFunction f, FunctionFlag flag) {
        return f.getFlags().contains(flag);
    }

    public static ImProg getProg(Element el) {
        for (Element e = el; e != null; e = e.getParent()) {
            if (!(e instanceof ImProg)) continue;
            return (ImProg)e;
        }
        throw new Error("Element " + el + " not attached to root.");
    }

    public static ImClass attrClass(ImMethod m) {
        return m.getMethodClass().getClassDef();
    }

    public static String translateType(ImTypeVarRef t) {
        throw new CompileError(t, "Type variable " + t.getTypeVariable().getName() + " not eliminated.");
    }

    public static String translateType(ImClassType imClassType) {
        return "integer";
    }

    public static String translateType(ImAnyType at) {
        return "integer";
    }
}

