/*
 * Decompiled with CFR 0.152.
 */
package de.peeeq.wurstscript.attributes.names;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import de.peeeq.wurstscript.ast.AstElementWithBody;
import de.peeeq.wurstscript.ast.AstElementWithTypeParameters;
import de.peeeq.wurstscript.ast.ClassDef;
import de.peeeq.wurstscript.ast.ClassOrModuleOrModuleInstanciation;
import de.peeeq.wurstscript.ast.CompilationUnit;
import de.peeeq.wurstscript.ast.EnumDef;
import de.peeeq.wurstscript.ast.ExprClosure;
import de.peeeq.wurstscript.ast.InterfaceDef;
import de.peeeq.wurstscript.ast.JassToplevelDeclaration;
import de.peeeq.wurstscript.ast.NativeFunc;
import de.peeeq.wurstscript.ast.TupleDef;
import de.peeeq.wurstscript.ast.TypeDef;
import de.peeeq.wurstscript.ast.TypeParamDef;
import de.peeeq.wurstscript.ast.WEntities;
import de.peeeq.wurstscript.ast.WEntity;
import de.peeeq.wurstscript.ast.WImport;
import de.peeeq.wurstscript.ast.WPackage;
import de.peeeq.wurstscript.ast.WScope;
import de.peeeq.wurstscript.ast.WStatements;
import de.peeeq.wurstscript.ast.WurstModel;
import de.peeeq.wurstscript.attributes.names.TypeLink;

public class TypeNameLinks {
    public static ImmutableMultimap<String, TypeLink> calculate(ClassOrModuleOrModuleInstanciation c) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        TypeNameLinks.addTypeParametersIfAny((ImmutableMultimap.Builder<String, TypeLink>)result, c);
        for (ClassDef innerClass : c.getInnerClasses()) {
            result.put((Object)innerClass.getName(), (Object)TypeLink.create(innerClass, c));
        }
        WScope nextScope = c.attrNextScope();
        if (nextScope != null) {
            result.put((Object)c.getName(), (Object)TypeLink.create(c, nextScope));
        }
        return result.build();
    }

    public static ImmutableMultimap<String, TypeLink> calculate(CompilationUnit cu) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        TypeNameLinks.addJassTypes((ImmutableMultimap.Builder<String, TypeLink>)result, cu);
        return result.build();
    }

    public static ImmutableMultimap<String, TypeLink> calculate(AstElementWithBody c) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        WScope s = (WScope)((Object)c);
        TypeNameLinks.addTypeParametersIfAny((ImmutableMultimap.Builder<String, TypeLink>)result, s);
        return result.build();
    }

    public static ImmutableMultimap<String, TypeLink> calculate(EnumDef e) {
        return ImmutableMultimap.of();
    }

    public static ImmutableMultimap<String, TypeLink> calculate(InterfaceDef i) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        TypeNameLinks.addTypeParametersIfAny((ImmutableMultimap.Builder<String, TypeLink>)result, i);
        return result.build();
    }

    public static ImmutableMultimap<String, TypeLink> calculate(NativeFunc nativeFunc) {
        return ImmutableMultimap.of();
    }

    public static ImmutableMultimap<String, TypeLink> calculate(TupleDef t) {
        return ImmutableMultimap.of();
    }

    public static ImmutableMultimap<String, TypeLink> calculate(WPackage p) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (WImport imp : p.getImports()) {
            WPackage importedPackage = imp.attrImportedPackage();
            if (importedPackage == null) continue;
            result.putAll(importedPackage.attrExportedTypeNameLinks());
        }
        return result.build();
    }

    public static ImmutableMultimap<String, TypeLink> calculate(WEntities wEntities) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (WEntity e : wEntities) {
            if (!(e instanceof TypeDef)) continue;
            TypeDef n = (TypeDef)e;
            result.put((Object)n.getName(), (Object)TypeLink.create(n, wEntities));
        }
        return result.build();
    }

    public static ImmutableMultimap<String, TypeLink> calculate(WurstModel model) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (CompilationUnit cu : model) {
            result.putAll(cu.attrTypeNameLinks());
        }
        return result.build();
    }

    public static ImmutableMultimap<String, TypeLink> calculate(WStatements statements) {
        return ImmutableMultimap.of();
    }

    private static void addTypeParametersIfAny(ImmutableMultimap.Builder<String, TypeLink> result, WScope c) {
        if (c instanceof AstElementWithTypeParameters) {
            AstElementWithTypeParameters wtp = (AstElementWithTypeParameters)((Object)c);
            for (TypeParamDef i : wtp.getTypeParameters()) {
                result.put((Object)i.getName(), (Object)TypeLink.create(i, c));
            }
        }
    }

    private static void addJassTypes(ImmutableMultimap.Builder<String, TypeLink> result, CompilationUnit cu) {
        for (JassToplevelDeclaration jd : cu.getJassDecls()) {
            if (!(jd instanceof TypeDef)) continue;
            TypeDef def = (TypeDef)((Object)jd);
            result.put((Object)def.getName(), (Object)TypeLink.create(def, cu));
        }
    }

    public static ImmutableMultimap<String, TypeLink> calculate(ExprClosure exprClosure) {
        return ImmutableMultimap.of();
    }
}

