/*
 * Decompiled with CFR 0.152.
 */
package net.moonlightflower.wc3libs.port;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.moonlightflower.wc3libs.port.Context;
import net.moonlightflower.wc3libs.port.GameDirFinder;
import net.moonlightflower.wc3libs.port.GameVersion;
import net.moonlightflower.wc3libs.port.GameVersionFinder;
import net.moonlightflower.wc3libs.port.NotFoundException;
import net.moonlightflower.wc3libs.port.Orient;
import net.moonlightflower.wc3libs.port.War3MPQs;

public abstract class MpqPort {
    private static final File workDir = new File(Orient.getExecDir(), Orient.getExecPath().getName() + "_work");
    private static final File classWorkDir = new File(workDir, Orient.localClassPath().toString());
    private static final File tempDir = new File(classWorkDir, "temp");
    private static final File importDir = new File(tempDir, "import");
    private static final File importFilesDir = new File(importDir, "files");
    private static final File exportDir = new File(tempDir, "export");
    private static final File exportFilesDir = new File(exportDir, "files");

    @Nonnull
    public abstract List<File> listFiles(@Nonnull File var1) throws IOException;

    public abstract In createIn();

    public abstract Out createOut();

    protected static GameVersion getGameVersion() throws NotFoundException {
        return (GameVersion)Context.getService(GameVersionFinder.class).get();
    }

    @Nonnull
    public static Vector<File> getWar3Mpqs(@Nonnull File war3dir) throws NotFoundException {
        Vector<File> files = new Vector<File>();
        GameVersion gameVersion = MpqPort.getGameVersion();
        if (gameVersion != null && gameVersion.compareTo(GameVersion.VERSION_1_29) < 0) {
            files.add(new File(war3dir, War3MPQs.WAR3PATCH.toString()));
        }
        files.add(new File(war3dir, War3MPQs.WAR3X.toString()));
        files.add(new File(war3dir, War3MPQs.WAR3.toString()));
        files.add(new File(war3dir, War3MPQs.WAR3X_LOCAL.toString()));
        return files.stream().filter(File::exists).collect(Collectors.toCollection(Vector::new));
    }

    @Nonnull
    public static Vector<File> getWar3Mpqs() throws IOException, NotFoundException {
        GameDirFinder finder = Context.getService(GameDirFinder.class);
        File war3dir = (File)finder.get();
        return MpqPort.getWar3Mpqs(war3dir);
    }

    @Nonnull
    public abstract Out.Result getGameFiles(File ... var1) throws IOException, NotFoundException;

    public static abstract class Out {
        private Vector<FileExport> _fileExports = new Vector();

        @Nonnull
        public Vector<FileExport> getFiles() {
            return this._fileExports;
        }

        public void add(@Nonnull File inFile) {
            this._fileExports.add(new FileExport(inFile));
        }

        public void add(@Nonnull File inFile, @Nonnull OutputStream outStream) {
            this._fileExports.add(new FileExport(inFile, outStream));
        }

        public void add(@Nonnull File inFile, @Nonnull File outFile, boolean outFileIsDir) {
            this._fileExports.add(new FileExport(inFile, outFile, outFileIsDir));
        }

        public void clear() {
            this._fileExports.clear();
        }

        @Nonnull
        public abstract Result commit(@Nonnull Vector<File> var1) throws IOException;

        @Nonnull
        public Result commit(@Nonnull File mpqFile) throws IOException {
            Vector<File> mpqFiles = new Vector<File>();
            mpqFiles.add(mpqFile);
            return this.commit(mpqFiles);
        }

        public static class FileExport {
            private File _inFile;
            private File _outDir = null;
            private File _outFile = null;
            private OutputStream _outStream = null;

            @Nonnull
            public File getInFile() {
                return this._inFile;
            }

            @Nullable
            public File getOutDir() {
                return this._outDir;
            }

            @Nullable
            public File getOutFile() {
                return this._outFile;
            }

            @Nullable
            public OutputStream getOutStream() {
                return this._outStream;
            }

            public FileExport(@Nonnull File inFile) {
                this._inFile = inFile;
            }

            public FileExport(@Nonnull File inFile, @Nullable OutputStream outStream) {
                this._inFile = inFile;
                this._outStream = outStream;
            }

            public FileExport(@Nonnull File inFile, @Nonnull File outFile, boolean outFileIsDir) {
                this._inFile = inFile;
                this._outFile = outFile;
                if (outFileIsDir) {
                    this._outFile = new File(this._outFile, this._inFile.toString());
                }
                this._outDir = this._outFile.getParentFile();
            }
        }

        public static class Result {
            private Map<File, Segment> _exports = new LinkedHashMap<File, Segment>();

            @Nonnull
            public Map<File, Segment> getExports() {
                return this._exports;
            }

            @Nullable
            public File getFile(@Nonnull File inFile) throws IOException {
                Segment segment = this.getExports().get(inFile);
                if (segment == null) {
                    throw new NoSuchFileException(String.format("noSuchFile: %s", inFile.toString()));
                }
                File outFile = segment.getExport().getOutFile();
                if (outFile != null) {
                    return outFile;
                }
                outFile = new File(exportFilesDir, inFile.getName());
                outFile.getParentFile().mkdirs();
                FileOutputStream writer = new FileOutputStream(outFile);
                byte[] outBytes = segment.getOutBytes();
                writer.write(outBytes, 0, outBytes.length);
                writer.close();
                return outFile;
            }

            @Nullable
            public InputStream getInputStream(@Nonnull File inFile) throws IOException {
                Segment segment = this.getExports().get(inFile);
                if (segment == null) {
                    throw new IOException(String.format("noSuchFile: %s", inFile.toString()));
                }
                File outFile = segment.getExport().getOutFile();
                if (outFile != null) {
                    return Files.newInputStream(outFile.toPath(), new OpenOption[0]);
                }
                byte[] outBytes = segment.getOutBytes();
                if (outBytes != null) {
                    return new ByteArrayInputStream(outBytes);
                }
                return null;
            }

            public void addExport(@Nonnull File mpqFile, @Nonnull FileExport fileExport, byte[] outBytes) {
                this._exports.put(fileExport.getInFile(), new Segment(mpqFile, fileExport, outBytes));
            }

            public void addExport(@Nonnull File mpqFile, @Nonnull FileExport fileExport) {
                this._exports.put(fileExport.getInFile(), new Segment(mpqFile, fileExport));
            }

            public class Segment {
                private final FileExport _fileExport;
                private final File _mpqFile;
                private byte[] _outBytes = null;

                @Nonnull
                public FileExport getExport() {
                    return this._fileExport;
                }

                @Nonnull
                public File getMpqFile() {
                    return this._mpqFile;
                }

                public byte[] getOutBytes() {
                    return Arrays.copyOf(this._outBytes, this._outBytes.length);
                }

                private Segment(@Nonnull File mpqFile, FileExport fileExport, byte[] outBytes) {
                    this._fileExport = fileExport;
                    this._mpqFile = mpqFile;
                    this._outBytes = outBytes;
                }

                private Segment(@Nonnull File mpqFile, FileExport fileExport) {
                    this._fileExport = fileExport;
                    this._mpqFile = mpqFile;
                }
            }
        }

        static class DummyOutputStream
        extends OutputStream {
            private final ByteArrayOutputStream _outBytes = new ByteArrayOutputStream();

            public byte[] getBytes() {
                return this._outBytes.toByteArray();
            }

            @Override
            public void write(int val) {
                this._outBytes.write(val);
            }

            @Override
            public void close() throws IOException {
                super.close();
            }

            public void close(@Nonnull OutputStream outStream) throws IOException {
                for (byte val : this.getBytes()) {
                    outStream.write(val);
                }
                super.close();
            }
        }
    }

    public static class PortException
    extends IOException {
        public PortException(@Nonnull String msg) {
            super(msg);
        }

        public PortException(@Nonnull IOException e) {
            super(e);
        }
    }

    public static abstract class In {
        private Vector<FileImport> _fileImports = new Vector();

        @Nonnull
        public Vector<FileImport> getFiles() {
            return new Vector<FileImport>(this._fileImports);
        }

        public void add(@Nullable File outPath, @Nonnull File inPath) {
            this._fileImports.add(new FileImport(outPath, inPath));
        }

        public void addDel(@Nonnull File inPath) {
            this.add(null, inPath);
        }

        public void clear() {
            this._fileImports.clear();
        }

        public abstract void commit(@Nonnull Vector<File> var1) throws Exception;

        public void commit(@Nonnull File mpqFile) throws Exception {
            Vector<File> mpqFiles = new Vector<File>();
            mpqFiles.add(mpqFile);
            this.commit(mpqFiles);
        }

        public static class FileImport {
            private File _outFile;
            private File _inFile;

            public File getOutFile() {
                return this._outFile;
            }

            public File getInFile() {
                return this._inFile;
            }

            public FileImport(@Nullable File outPath, @Nonnull File inPath) {
                this._outFile = outPath;
                this._inFile = inPath;
            }
        }
    }

    public static class ResourceFile
    extends File {
        public ResourceFile(@Nonnull String pathname) {
            super(pathname);
        }

        public ResourceFile(@Nonnull File parent, @Nonnull String child) {
            super(parent, child);
        }
    }
}

